/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.util.Timeout;
import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.common.actor.CommonConfig;
import scala.concurrent.duration.FiniteDuration;

public class RemoteRpcProviderConfig
extends CommonConfig {
    protected static final String TAG_RPC_BROKER_NAME = "rpc-broker-name";
    protected static final String TAG_RPC_REGISTRAR_NAME = "rpc-registrar-name";
    protected static final String TAG_RPC_REGISTRY_NAME = "registry-name";
    protected static final String TAG_RPC_MGR_NAME = "rpc-manager-name";
    protected static final String TAG_RPC_BROKER_PATH = "rpc-broker-path";
    protected static final String TAG_RPC_REGISTRY_PATH = "rpc-registry-path";
    protected static final String TAG_RPC_MGR_PATH = "rpc-manager-path";
    protected static final String TAG_ASK_DURATION = "ask-duration";
    private static final String TAG_GOSSIP_TICK_INTERVAL = "gossip-tick-interval";
    private static final String TAG_RPC_REGISTRY_PERSISTENCE_ID = "rpc-registry-persistence-id";
    private Timeout cachedAskDuration;
    private FiniteDuration cachedGossipTickInterval;

    public RemoteRpcProviderConfig(Config config) {
        super(config);
    }

    public String getRpcBrokerName() {
        return this.get().getString(TAG_RPC_BROKER_NAME);
    }

    public String getRpcRegistrarName() {
        return this.get().getString(TAG_RPC_REGISTRAR_NAME);
    }

    public String getRpcRegistryName() {
        return this.get().getString(TAG_RPC_REGISTRY_NAME);
    }

    public String getRpcManagerName() {
        return this.get().getString(TAG_RPC_MGR_NAME);
    }

    public String getRpcBrokerPath() {
        return this.get().getString(TAG_RPC_BROKER_PATH);
    }

    public String getRpcRegistryPath() {
        return this.get().getString(TAG_RPC_REGISTRY_PATH);
    }

    public String getRpcRegistryPersistenceId() {
        return this.get().getString(TAG_RPC_REGISTRY_PERSISTENCE_ID);
    }

    public String getRpcManagerPath() {
        return this.get().getString(TAG_RPC_MGR_PATH);
    }

    public Timeout getAskDuration() {
        if (this.cachedAskDuration != null) {
            return this.cachedAskDuration;
        }
        this.cachedAskDuration = new Timeout(new FiniteDuration(this.get().getDuration(TAG_ASK_DURATION, TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS));
        return this.cachedAskDuration;
    }

    public FiniteDuration getGossipTickInterval() {
        if (this.cachedGossipTickInterval != null) {
            return this.cachedGossipTickInterval;
        }
        this.cachedGossipTickInterval = new FiniteDuration(this.get().getDuration(TAG_GOSSIP_TICK_INTERVAL, TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        return this.cachedGossipTickInterval;
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Findbugs flags this as an unconfirmed cast of return value but the build method clearly returns RemoteRpcProviderConfig. Perhaps it's confused b/c the build method is overloaded and and differs in return type from the base class.")
    public static RemoteRpcProviderConfig newInstance(String actorSystemName, boolean metricCaptureEnabled, int mailboxCapacity) {
        return ((Builder)((Builder)new Builder(actorSystemName).metricCaptureEnabled(metricCaptureEnabled)).mailboxCapacity(mailboxCapacity)).build();
    }

    public static class Builder
    extends CommonConfig.Builder<Builder> {
        public Builder(String actorSystemName) {
            super(actorSystemName);
            this.configHolder.put(RemoteRpcProviderConfig.TAG_RPC_BROKER_NAME, "broker");
            this.configHolder.put(RemoteRpcProviderConfig.TAG_RPC_REGISTRAR_NAME, "registrar");
            this.configHolder.put(RemoteRpcProviderConfig.TAG_RPC_REGISTRY_NAME, "registry");
            this.configHolder.put(RemoteRpcProviderConfig.TAG_RPC_MGR_NAME, "rpc");
            this.configHolder.put(RemoteRpcProviderConfig.TAG_RPC_BROKER_PATH, "/user/rpc/broker");
            this.configHolder.put(RemoteRpcProviderConfig.TAG_RPC_REGISTRY_PATH, "/user/rpc/registry");
            this.configHolder.put(RemoteRpcProviderConfig.TAG_RPC_MGR_PATH, "/user/rpc");
            this.configHolder.put(RemoteRpcProviderConfig.TAG_ASK_DURATION, "15s");
            this.configHolder.put(RemoteRpcProviderConfig.TAG_GOSSIP_TICK_INTERVAL, "500ms");
            this.configHolder.put(RemoteRpcProviderConfig.TAG_RPC_REGISTRY_PERSISTENCE_ID, "remote-rpc-registry");
        }

        public Builder gossipTickInterval(String interval) {
            this.configHolder.put(RemoteRpcProviderConfig.TAG_GOSSIP_TICK_INTERVAL, interval);
            return this;
        }

        public RemoteRpcProviderConfig build() {
            return new RemoteRpcProviderConfig(this.merge());
        }
    }
}

