/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.ActorRef;
import akka.actor.OneForOneStrategy;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.controller.remote.rpc.RemoteRpcProviderConfig;
import org.opendaylight.controller.remote.rpc.RpcInvoker;
import org.opendaylight.controller.remote.rpc.RpcListener;
import org.opendaylight.controller.remote.rpc.RpcRegistrar;
import org.opendaylight.controller.remote.rpc.registry.RpcRegistry;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class RpcManager
extends AbstractUntypedActor {
    private final DOMRpcProviderService rpcProvisionRegistry;
    private final RemoteRpcProviderConfig config;
    private final DOMRpcService rpcServices;
    private ListenerRegistration<RpcListener> listenerReg;
    private ActorRef rpcInvoker;
    private ActorRef rpcRegistry;
    private ActorRef rpcRegistrar;

    RpcManager(DOMRpcProviderService rpcProvisionRegistry, DOMRpcService rpcServices, RemoteRpcProviderConfig config) {
        this.rpcProvisionRegistry = (DOMRpcProviderService)Preconditions.checkNotNull((Object)rpcProvisionRegistry);
        this.rpcServices = (DOMRpcService)Preconditions.checkNotNull((Object)rpcServices);
        this.config = (RemoteRpcProviderConfig)((Object)Preconditions.checkNotNull((Object)((Object)config)));
    }

    public static Props props(DOMRpcProviderService rpcProvisionRegistry, DOMRpcService rpcServices, RemoteRpcProviderConfig config) {
        Preconditions.checkNotNull((Object)rpcProvisionRegistry, (Object)"RpcProviderService can not be null!");
        Preconditions.checkNotNull((Object)rpcServices, (Object)"RpcService can not be null!");
        Preconditions.checkNotNull((Object)((Object)config), (Object)"RemoteRpcProviderConfig can not be null!");
        return Props.create(RpcManager.class, (Object[])new Object[]{rpcProvisionRegistry, rpcServices, config});
    }

    public void preStart() throws Exception {
        super.preStart();
        this.rpcInvoker = this.getContext().actorOf(RpcInvoker.props(this.rpcServices).withMailbox(this.config.getMailBoxName()), this.config.getRpcBrokerName());
        this.LOG.debug("Listening for RPC invocation requests with {}", (Object)this.rpcInvoker);
        this.rpcRegistrar = this.getContext().actorOf(RpcRegistrar.props(this.config, this.rpcProvisionRegistry).withMailbox(this.config.getMailBoxName()), this.config.getRpcRegistrarName());
        this.LOG.debug("Registering remote RPCs with {}", (Object)this.rpcRegistrar);
        this.rpcRegistry = this.getContext().actorOf(RpcRegistry.props(this.config, this.rpcInvoker, this.rpcRegistrar).withMailbox(this.config.getMailBoxName()), this.config.getRpcRegistryName());
        this.LOG.debug("Propagating RPC information with {}", (Object)this.rpcRegistry);
        RpcListener rpcListener = new RpcListener(this.rpcRegistry);
        this.LOG.debug("Registering local availabitility listener {}", (Object)rpcListener);
        this.listenerReg = this.rpcServices.registerRpcListener((DOMRpcAvailabilityListener)rpcListener);
    }

    public void postStop() throws Exception {
        if (this.listenerReg != null) {
            this.listenerReg.close();
            this.listenerReg = null;
        }
        super.postStop();
    }

    protected void handleReceive(Object message) {
        this.unknownMessage(message);
    }

    public SupervisorStrategy supervisorStrategy() {
        return new OneForOneStrategy(10, (Duration)FiniteDuration.create((long)1L, (TimeUnit)TimeUnit.MINUTES), t -> {
            this.LOG.error("An exception happened actor will be resumed", t);
            return SupervisorStrategy.resume();
        });
    }
}

