/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.messages;

import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.SerializationUtils;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public final class ExecuteRpc
implements Serializable {
    private static final long serialVersionUID = 1128904894827335676L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="This field is not Serializable but this class implements writeReplace to delegate serialization to a Proxy class and thus instances of this class aren't serialized. FindBugs does not recognize this.")
    private final NormalizedNode<?, ?> inputNormalizedNode;
    private final QName rpc;

    private ExecuteRpc(@Nullable NormalizedNode<?, ?> inputNormalizedNode, @NonNull QName rpc) {
        this.rpc = Objects.requireNonNull(rpc, "rpc Qname should not be null");
        this.inputNormalizedNode = inputNormalizedNode;
    }

    public static ExecuteRpc from(@NonNull DOMRpcIdentifier rpc, @Nullable NormalizedNode<?, ?> input) {
        return new ExecuteRpc(input, rpc.getType().getLastComponent());
    }

    public @Nullable NormalizedNode<?, ?> getInputNormalizedNode() {
        return this.inputNormalizedNode;
    }

    public @NonNull QName getRpc() {
        return this.rpc;
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rpc", (Object)this.rpc).add("normalizedNode", this.inputNormalizedNode).toString();
    }

    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ExecuteRpc executeRpc;

        public Proxy() {
        }

        Proxy(ExecuteRpc executeRpc) {
            this.executeRpc = executeRpc;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.executeRpc.getRpc());
            SerializationUtils.serializeNormalizedNode(this.executeRpc.getInputNormalizedNode(), (DataOutput)out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            QName qname = (QName)in.readObject();
            this.executeRpc = new ExecuteRpc(SerializationUtils.deserializeNormalizedNode((DataInput)in), qname);
        }

        private Object readResolve() {
            return this.executeRpc;
        }
    }
}

