/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry;

import akka.actor.ActorRef;
import akka.actor.ExtendedActorSystem;
import akka.serialization.JavaSerializer;
import akka.serialization.Serialization;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataInput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataOutput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeInputOutput;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketData;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class RoutingTable
implements BucketData<RoutingTable>,
Serializable {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="We deal with the field in serialization methods.")
    private final Set<DOMRpcIdentifier> rpcs;
    private final ActorRef rpcInvoker;

    RoutingTable(ActorRef rpcInvoker, Collection<DOMRpcIdentifier> table) {
        this.rpcInvoker = (ActorRef)Preconditions.checkNotNull((Object)rpcInvoker);
        this.rpcs = ImmutableSet.copyOf(table);
    }

    @Override
    public Optional<ActorRef> getWatchActor() {
        return Optional.of(this.rpcInvoker);
    }

    public Set<DOMRpcIdentifier> getRoutes() {
        return this.rpcs;
    }

    ActorRef getRpcInvoker() {
        return this.rpcInvoker;
    }

    RoutingTable addRpcs(Collection<DOMRpcIdentifier> toAdd) {
        HashSet<DOMRpcIdentifier> newRpcs = new HashSet<DOMRpcIdentifier>(this.rpcs);
        newRpcs.addAll(toAdd);
        return new RoutingTable(this.rpcInvoker, newRpcs);
    }

    RoutingTable removeRpcs(Collection<DOMRpcIdentifier> toRemove) {
        HashSet<DOMRpcIdentifier> newRpcs = new HashSet<DOMRpcIdentifier>(this.rpcs);
        newRpcs.removeAll(toRemove);
        return new RoutingTable(this.rpcInvoker, newRpcs);
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    @VisibleForTesting
    boolean contains(DOMRpcIdentifier routeId) {
        return this.rpcs.contains(routeId);
    }

    @VisibleForTesting
    int size() {
        return this.rpcs.size();
    }

    public String toString() {
        return "RoutingTable{rpcs=" + this.rpcs + ", rpcInvoker=" + this.rpcInvoker + '}';
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="We deal with the field in serialization methods.")
        private Collection<DOMRpcIdentifier> rpcs;
        private ActorRef rpcInvoker;

        public Proxy() {
        }

        Proxy(RoutingTable table) {
            this.rpcs = table.getRoutes();
            this.rpcInvoker = table.getRpcInvoker();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(Serialization.serializedActorPath((ActorRef)this.rpcInvoker));
            NormalizedNodeDataOutput nnout = NormalizedNodeInputOutput.newDataOutput((DataOutput)out);
            nnout.writeInt(this.rpcs.size());
            for (DOMRpcIdentifier id : this.rpcs) {
                nnout.writeSchemaPath(id.getType());
                nnout.writeYangInstanceIdentifier(id.getContextReference());
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.rpcInvoker = ((ExtendedActorSystem)JavaSerializer.currentSystem().value()).provider().resolveActorRef((String)in.readObject());
            NormalizedNodeDataInput nnin = NormalizedNodeInputOutput.newDataInput((DataInput)in);
            int size = nnin.readInt();
            this.rpcs = new ArrayList<DOMRpcIdentifier>(size);
            for (int i = 0; i < size; ++i) {
                this.rpcs.add(DOMRpcIdentifier.create((SchemaPath)nnin.readSchemaPath(), (YangInstanceIdentifier)nnin.readYangInstanceIdentifier()));
            }
        }

        private Object readResolve() {
            return new RoutingTable(this.rpcInvoker, this.rpcs);
        }
    }
}

