/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry;

import akka.actor.ActorRef;
import akka.actor.Address;
import akka.actor.Props;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.controller.remote.rpc.RemoteRpcProviderConfig;
import org.opendaylight.controller.remote.rpc.registry.RoutingTable;
import org.opendaylight.controller.remote.rpc.registry.gossip.Bucket;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketStoreAccess;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketStoreActor;
import org.opendaylight.controller.remote.rpc.registry.mbeans.RemoteRpcRegistryMXBeanImpl;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import scala.concurrent.ExecutionContext;

public class RpcRegistry
extends BucketStoreActor<RoutingTable> {
    private final ActorRef rpcRegistrar;
    private final RemoteRpcRegistryMXBeanImpl mxBean;

    public RpcRegistry(RemoteRpcProviderConfig config, ActorRef rpcInvoker, ActorRef rpcRegistrar) {
        super(config, config.getRpcRegistryPersistenceId(), new RoutingTable(rpcInvoker, (Collection<DOMRpcIdentifier>)ImmutableSet.of()));
        this.rpcRegistrar = (ActorRef)Preconditions.checkNotNull((Object)rpcRegistrar);
        this.mxBean = new RemoteRpcRegistryMXBeanImpl(new BucketStoreAccess(this.self(), (ExecutionContext)this.getContext().dispatcher(), config.getAskDuration()), config.getAskDuration());
    }

    public static Props props(RemoteRpcProviderConfig config, ActorRef rpcInvoker, ActorRef rpcRegistrar) {
        return Props.create(RpcRegistry.class, (Object[])new Object[]{config, rpcInvoker, rpcRegistrar});
    }

    public void postStop() {
        super.postStop();
        this.mxBean.unregister();
    }

    @Override
    protected void handleCommand(Object message) throws Exception {
        if (message instanceof Messages.AddOrUpdateRoutes) {
            this.receiveAddRoutes((Messages.AddOrUpdateRoutes)message);
        } else if (message instanceof Messages.RemoveRoutes) {
            this.receiveRemoveRoutes((Messages.RemoveRoutes)message);
        } else {
            super.handleCommand(message);
        }
    }

    private void receiveAddRoutes(Messages.AddOrUpdateRoutes msg) {
        this.LOG.debug("AddOrUpdateRoutes: {}", msg.getRouteIdentifiers());
        this.updateLocalBucket(((RoutingTable)this.getLocalData()).addRpcs(msg.getRouteIdentifiers()));
    }

    private void receiveRemoveRoutes(Messages.RemoveRoutes msg) {
        this.LOG.debug("RemoveRoutes: {}", msg.getRouteIdentifiers());
        this.updateLocalBucket(((RoutingTable)this.getLocalData()).removeRpcs(msg.getRouteIdentifiers()));
    }

    @Override
    protected void onBucketRemoved(Address address, Bucket<RoutingTable> bucket) {
        this.rpcRegistrar.tell((Object)new Messages.UpdateRemoteEndpoints((Map<Address, Optional<RemoteRpcEndpoint>>)ImmutableMap.of((Object)address, Optional.empty())), ActorRef.noSender());
    }

    @Override
    protected void onBucketsUpdated(Map<Address, Bucket<RoutingTable>> buckets) {
        HashMap<Address, Optional<RemoteRpcEndpoint>> endpoints = new HashMap<Address, Optional<RemoteRpcEndpoint>>(buckets.size());
        for (Map.Entry<Address, Bucket<RoutingTable>> e : buckets.entrySet()) {
            RoutingTable table = e.getValue().getData();
            Set<DOMRpcIdentifier> rpcs = table.getRoutes();
            endpoints.put(e.getKey(), rpcs.isEmpty() ? Optional.empty() : Optional.of(new RemoteRpcEndpoint(table.getRpcInvoker(), rpcs)));
        }
        if (!endpoints.isEmpty()) {
            this.rpcRegistrar.tell((Object)new Messages.UpdateRemoteEndpoints(endpoints), ActorRef.noSender());
        }
    }

    public static class Messages {

        public static final class UpdateRemoteEndpoints {
            private final Map<Address, Optional<RemoteRpcEndpoint>> endpoints;

            @VisibleForTesting
            public UpdateRemoteEndpoints(Map<Address, Optional<RemoteRpcEndpoint>> endpoints) {
                this.endpoints = ImmutableMap.copyOf(endpoints);
            }

            public Map<Address, Optional<RemoteRpcEndpoint>> getEndpoints() {
                return this.endpoints;
            }
        }

        public static final class RemoveRoutes
        extends AbstractRouteMessage {
            public RemoveRoutes(Collection<DOMRpcIdentifier> routeIdentifiers) {
                super(routeIdentifiers);
            }
        }

        public static final class AddOrUpdateRoutes
        extends AbstractRouteMessage {
            public AddOrUpdateRoutes(Collection<DOMRpcIdentifier> routeIdentifiers) {
                super(routeIdentifiers);
            }
        }

        static abstract class AbstractRouteMessage {
            final List<DOMRpcIdentifier> routeIdentifiers;

            AbstractRouteMessage(Collection<DOMRpcIdentifier> routeIdentifiers) {
                Preconditions.checkArgument((routeIdentifiers != null && !routeIdentifiers.isEmpty() ? 1 : 0) != 0, (Object)"Route Identifiers must be supplied");
                this.routeIdentifiers = ImmutableList.copyOf(routeIdentifiers);
            }

            List<DOMRpcIdentifier> getRouteIdentifiers() {
                return this.routeIdentifiers;
            }

            public String toString() {
                return "ContainsRoute{routeIdentifiers=" + this.routeIdentifiers + '}';
            }
        }
    }

    public static final class RemoteRpcEndpoint {
        private final Set<DOMRpcIdentifier> rpcs;
        private final ActorRef router;

        @VisibleForTesting
        public RemoteRpcEndpoint(ActorRef router, Collection<DOMRpcIdentifier> rpcs) {
            this.router = (ActorRef)Preconditions.checkNotNull((Object)router);
            this.rpcs = ImmutableSet.copyOf(rpcs);
        }

        public ActorRef getRouter() {
            return this.router;
        }

        public Set<DOMRpcIdentifier> getRpcs() {
            return this.rpcs;
        }
    }
}

