/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry.mbeans;

import akka.actor.Address;
import akka.util.Timeout;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;
import org.opendaylight.controller.remote.rpc.registry.RoutingTable;
import org.opendaylight.controller.remote.rpc.registry.gossip.Bucket;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketStoreAccess;
import org.opendaylight.controller.remote.rpc.registry.mbeans.RemoteRpcRegistryMXBean;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.duration.Duration;

public class RemoteRpcRegistryMXBeanImpl
extends AbstractMXBean
implements RemoteRpcRegistryMXBean {
    @SuppressFBWarnings(value={"SLF4J_LOGGER_SHOULD_BE_PRIVATE"})
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String LOCAL_CONSTANT = "local";
    private static final String ROUTE_CONSTANT = "route:";
    private static final String NAME_CONSTANT = " | name:";
    private final BucketStoreAccess rpcRegistryAccess;
    private final Timeout timeout;

    public RemoteRpcRegistryMXBeanImpl(BucketStoreAccess rpcRegistryAccess, Timeout timeout) {
        super("RemoteRpcRegistry", "RemoteRpcBroker", null);
        this.rpcRegistryAccess = rpcRegistryAccess;
        this.timeout = timeout;
        this.registerMBean();
    }

    private RoutingTable getLocalData() {
        try {
            return (RoutingTable)Await.result(this.rpcRegistryAccess.getLocalData(), (Duration)this.timeout.duration());
        }
        catch (Exception e) {
            throw new RuntimeException("getLocalData failed", e);
        }
    }

    private Map<Address, Bucket<RoutingTable>> getRemoteBuckets() {
        try {
            return (Map)Await.result(this.rpcRegistryAccess.getRemoteBuckets(), (Duration)this.timeout.duration());
        }
        catch (Exception e) {
            throw new RuntimeException("getRemoteBuckets failed", e);
        }
    }

    @Override
    public Set<String> getGlobalRpc() {
        RoutingTable table = this.getLocalData();
        HashSet<String> globalRpc = new HashSet<String>(table.getRoutes().size());
        for (DOMRpcIdentifier route : table.getRoutes()) {
            if (!route.getContextReference().isEmpty()) continue;
            globalRpc.add(route.getType().toString());
        }
        this.log.debug("Locally registered global RPCs {}", globalRpc);
        return globalRpc;
    }

    @Override
    public Set<String> getLocalRegisteredRoutedRpc() {
        RoutingTable table = this.getLocalData();
        HashSet<String> routedRpc = new HashSet<String>(table.getRoutes().size());
        for (DOMRpcIdentifier route : table.getRoutes()) {
            if (route.getContextReference().isEmpty()) continue;
            routedRpc.add(ROUTE_CONSTANT + route.getContextReference() + NAME_CONSTANT + route.getType());
        }
        this.log.debug("Locally registered routed RPCs {}", routedRpc);
        return routedRpc;
    }

    @Override
    public Map<String, String> findRpcByName(String name) {
        RoutingTable localTable = this.getLocalData();
        HashMap<String, String> rpcMap = new HashMap<String, String>(RemoteRpcRegistryMXBeanImpl.getRpcMemberMapByName(localTable, name, LOCAL_CONSTANT));
        Map<Address, Bucket<RoutingTable>> buckets = this.getRemoteBuckets();
        for (Map.Entry<Address, Bucket<RoutingTable>> entry : buckets.entrySet()) {
            RoutingTable table = entry.getValue().getData();
            rpcMap.putAll(RemoteRpcRegistryMXBeanImpl.getRpcMemberMapByName(table, name, entry.getKey().toString()));
        }
        this.log.debug("list of RPCs {} searched by name {}", rpcMap, (Object)name);
        return rpcMap;
    }

    @Override
    public Map<String, String> findRpcByRoute(String routeId) {
        RoutingTable localTable = this.getLocalData();
        HashMap<String, String> rpcMap = new HashMap<String, String>(RemoteRpcRegistryMXBeanImpl.getRpcMemberMapByRoute(localTable, routeId, LOCAL_CONSTANT));
        Map<Address, Bucket<RoutingTable>> buckets = this.getRemoteBuckets();
        for (Map.Entry<Address, Bucket<RoutingTable>> entry : buckets.entrySet()) {
            RoutingTable table = entry.getValue().getData();
            rpcMap.putAll(RemoteRpcRegistryMXBeanImpl.getRpcMemberMapByRoute(table, routeId, entry.getKey().toString()));
        }
        this.log.debug("list of RPCs {} searched by route {}", rpcMap, (Object)routeId);
        return rpcMap;
    }

    private static Map<String, String> getRpcMemberMapByRoute(RoutingTable table, String routeName, String address) {
        Set<DOMRpcIdentifier> routes = table.getRoutes();
        HashMap<String, String> rpcMap = new HashMap<String, String>(routes.size());
        for (DOMRpcIdentifier route : routes) {
            String routeString;
            if (route.getContextReference().isEmpty() || !(routeString = route.getContextReference().toString()).contains(routeName)) continue;
            rpcMap.put(ROUTE_CONSTANT + routeString + NAME_CONSTANT + route.getType(), address);
        }
        return rpcMap;
    }

    private static Map<String, String> getRpcMemberMapByName(RoutingTable table, String name, String address) {
        Set<DOMRpcIdentifier> routes = table.getRoutes();
        HashMap<String, String> rpcMap = new HashMap<String, String>(routes.size());
        for (DOMRpcIdentifier route : routes) {
            String type;
            if (route.getContextReference().isEmpty() || !(type = route.getType().toString()).contains(name)) continue;
            rpcMap.put(ROUTE_CONSTANT + route.getContextReference() + NAME_CONSTANT + type, address);
        }
        return rpcMap;
    }

    @Override
    public String getBucketVersions() {
        try {
            return Await.result(this.rpcRegistryAccess.getBucketVersions(), (Duration)this.timeout.duration()).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("getVersions failed", e);
        }
    }
}

