/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.sql.CommonDataSource;
import org.ops4j.pax.jdbc.config.ConfigLoader;
import org.ops4j.pax.jdbc.config.impl.DataSourceConfigManager;
import org.ops4j.pax.jdbc.config.impl.DataSourceWrapper;
import org.ops4j.pax.jdbc.config.impl.ExternalConfigLoader;
import org.ops4j.pax.jdbc.config.impl.FileConfigLoader;
import org.ops4j.pax.jdbc.config.impl.ServiceTrackerHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final String FACTORY_PID = "org.ops4j.datasource";
    private ServiceTracker<?, ?> dataSourceTracker;
    private ExternalConfigLoader externalConfigLoader;
    private ServiceRegistration<ConfigLoader> configLoaderRegistration;
    private DataSourceConfigManager configManager;
    private ServiceRegistration<ManagedServiceFactory> registration;

    public void start(BundleContext context) throws Exception {
        this.configLoaderRegistration = context.registerService(ConfigLoader.class, (Object)new FileConfigLoader(), new Hashtable());
        this.externalConfigLoader = new ExternalConfigLoader(context);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", FACTORY_PID);
        this.configManager = new DataSourceConfigManager(context, this.externalConfigLoader);
        this.registration = context.registerService(ManagedServiceFactory.class, (Object)this.configManager, props);
        ServiceTrackerHelper helper = ServiceTrackerHelper.helper(context);
        String filter = "(&(pool=*)(!(pax.jdbc.managed=true))(|(objectClass=javax.sql.DataSource)(objectClass=javax.sql.XADataSource)))";
        this.dataSourceTracker = helper.track(CommonDataSource.class, filter, (ds, reference) -> new DataSourceWrapper(context, this.externalConfigLoader, (CommonDataSource)ds, (ServiceReference<CommonDataSource>)reference), DataSourceWrapper::close);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.dataSourceTracker != null) {
            this.dataSourceTracker.close();
        }
        this.registration.unregister();
        this.configManager.destroy();
        this.configLoaderRegistration.unregister();
        this.externalConfigLoader.destroy();
    }
}

