/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import java.util.Arrays;

public enum ModifyAction {
    MERGE(true),
    REPLACE(true),
    CREATE(false),
    DELETE(false),
    REMOVE(false),
    NONE(true, false);

    private final boolean asDefaultPermitted;
    private final boolean onElementPermitted;

    public static ModifyAction fromXmlValue(String xmlNameOfAction) {
        switch (xmlNameOfAction) {
            case "merge": {
                return MERGE;
            }
            case "replace": {
                return REPLACE;
            }
            case "remove": {
                return REMOVE;
            }
            case "delete": {
                return DELETE;
            }
            case "create": {
                return CREATE;
            }
            case "none": {
                return NONE;
            }
        }
        throw new IllegalArgumentException("Unknown operation " + xmlNameOfAction + " available operations " + Arrays.toString((Object[])ModifyAction.values()));
    }

    private ModifyAction(boolean asDefaultPermitted, boolean onElementPermitted) {
        this.asDefaultPermitted = asDefaultPermitted;
        this.onElementPermitted = onElementPermitted;
    }

    private ModifyAction(boolean asDefaultPermitted) {
        this(asDefaultPermitted, true);
    }

    public boolean isAsDefaultPermitted() {
        return this.asDefaultPermitted;
    }

    public boolean isOnElementPermitted() {
        return this.onElementPermitted;
    }
}

