/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.stream;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.YangModeledAnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamAttributeWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class NormalizedNodeWriter
implements Closeable,
Flushable {
    private final NormalizedNodeStreamWriter writer;

    protected NormalizedNodeWriter(NormalizedNodeStreamWriter writer) {
        this.writer = Objects.requireNonNull(writer);
    }

    protected final NormalizedNodeStreamWriter getWriter() {
        return this.writer;
    }

    public static NormalizedNodeWriter forStreamWriter(NormalizedNodeStreamWriter writer) {
        return NormalizedNodeWriter.forStreamWriter(writer, true);
    }

    public static NormalizedNodeWriter forStreamWriter(NormalizedNodeStreamWriter writer, boolean orderKeyLeaves) {
        return orderKeyLeaves ? new OrderedNormalizedNodeWriter(writer) : new NormalizedNodeWriter(writer);
    }

    public NormalizedNodeWriter write(NormalizedNode<?, ?> node) throws IOException {
        if (this.wasProcessedAsCompositeNode(node)) {
            return this;
        }
        if (this.wasProcessAsSimpleNode(node)) {
            return this;
        }
        throw new IllegalStateException("It wasn't possible to serialize node " + node);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    protected static int childSizeHint(Iterable<?> children) {
        return children instanceof Collection ? ((Collection)children).size() : -1;
    }

    protected boolean wasProcessAsSimpleNode(NormalizedNode<?, ?> node) throws IOException {
        if (node instanceof LeafSetEntryNode) {
            LeafSetEntryNode nodeAsLeafList = (LeafSetEntryNode)node;
            QName name = nodeAsLeafList.getIdentifier().getNodeType();
            if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
                ((NormalizedNodeStreamAttributeWriter)this.writer).leafSetEntryNode(name, nodeAsLeafList.getValue(), nodeAsLeafList.getAttributes());
            } else {
                this.writer.leafSetEntryNode(name, nodeAsLeafList.getValue());
            }
            return true;
        }
        if (node instanceof LeafNode) {
            LeafNode nodeAsLeaf = (LeafNode)node;
            if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
                ((NormalizedNodeStreamAttributeWriter)this.writer).leafNode((YangInstanceIdentifier.NodeIdentifier)nodeAsLeaf.getIdentifier(), nodeAsLeaf.getValue(), nodeAsLeaf.getAttributes());
            } else {
                this.writer.leafNode((YangInstanceIdentifier.NodeIdentifier)nodeAsLeaf.getIdentifier(), nodeAsLeaf.getValue());
            }
            return true;
        }
        if (node instanceof AnyXmlNode) {
            AnyXmlNode anyXmlNode = (AnyXmlNode)node;
            this.writer.anyxmlNode((YangInstanceIdentifier.NodeIdentifier)anyXmlNode.getIdentifier(), anyXmlNode.getValue());
            return true;
        }
        return false;
    }

    protected boolean writeChildren(Iterable<? extends NormalizedNode<?, ?>> children) throws IOException {
        for (NormalizedNode<?, ?> child : children) {
            this.write(child);
        }
        this.writer.endNode();
        return true;
    }

    protected boolean writeMapEntryNode(MapEntryNode node) throws IOException {
        if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
            ((NormalizedNodeStreamAttributeWriter)this.writer).startMapEntryNode(node.getIdentifier(), NormalizedNodeWriter.childSizeHint(node.getValue()), node.getAttributes());
        } else {
            this.writer.startMapEntryNode(node.getIdentifier(), NormalizedNodeWriter.childSizeHint(node.getValue()));
        }
        return this.writeChildren((Iterable<? extends NormalizedNode<?, ?>>)node.getValue());
    }

    protected boolean wasProcessedAsCompositeNode(NormalizedNode<?, ?> node) throws IOException {
        if (node instanceof ContainerNode) {
            ContainerNode n = (ContainerNode)node;
            if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
                ((NormalizedNodeStreamAttributeWriter)this.writer).startContainerNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), NormalizedNodeWriter.childSizeHint(n.getValue()), n.getAttributes());
            } else {
                this.writer.startContainerNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), NormalizedNodeWriter.childSizeHint(n.getValue()));
            }
            return this.writeChildren((Iterable<? extends NormalizedNode<?, ?>>)n.getValue());
        }
        if (node instanceof YangModeledAnyXmlNode) {
            YangModeledAnyXmlNode n = (YangModeledAnyXmlNode)node;
            if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
                ((NormalizedNodeStreamAttributeWriter)this.writer).startYangModeledAnyXmlNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), NormalizedNodeWriter.childSizeHint(n.getValue()), n.getAttributes());
            } else {
                this.writer.startYangModeledAnyXmlNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), NormalizedNodeWriter.childSizeHint(n.getValue()));
            }
            return this.writeChildren((Iterable<? extends NormalizedNode<?, ?>>)n.getValue());
        }
        if (node instanceof MapEntryNode) {
            return this.writeMapEntryNode((MapEntryNode)node);
        }
        if (node instanceof UnkeyedListEntryNode) {
            UnkeyedListEntryNode n = (UnkeyedListEntryNode)node;
            this.writer.startUnkeyedListItem((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), NormalizedNodeWriter.childSizeHint(n.getValue()));
            return this.writeChildren((Iterable<? extends NormalizedNode<?, ?>>)n.getValue());
        }
        if (node instanceof ChoiceNode) {
            ChoiceNode n = (ChoiceNode)node;
            this.writer.startChoiceNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), NormalizedNodeWriter.childSizeHint(n.getValue()));
            return this.writeChildren((Iterable<? extends NormalizedNode<?, ?>>)n.getValue());
        }
        if (node instanceof AugmentationNode) {
            AugmentationNode n = (AugmentationNode)node;
            this.writer.startAugmentationNode(n.getIdentifier());
            return this.writeChildren((Iterable<? extends NormalizedNode<?, ?>>)n.getValue());
        }
        if (node instanceof UnkeyedListNode) {
            UnkeyedListNode n = (UnkeyedListNode)node;
            this.writer.startUnkeyedList((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), NormalizedNodeWriter.childSizeHint((Iterable)n.getValue()));
            return this.writeChildren((Iterable)n.getValue());
        }
        if (node instanceof OrderedMapNode) {
            OrderedMapNode n = (OrderedMapNode)node;
            this.writer.startOrderedMapNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), NormalizedNodeWriter.childSizeHint(n.getValue()));
            return this.writeChildren((Iterable<? extends NormalizedNode<?, ?>>)n.getValue());
        }
        if (node instanceof MapNode) {
            MapNode n = (MapNode)node;
            this.writer.startMapNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), NormalizedNodeWriter.childSizeHint(n.getValue()));
            return this.writeChildren((Iterable<? extends NormalizedNode<?, ?>>)n.getValue());
        }
        if (node instanceof OrderedLeafSetNode) {
            LeafSetNode n = (LeafSetNode)node;
            this.writer.startOrderedLeafSet((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), NormalizedNodeWriter.childSizeHint(n.getValue()));
            return this.writeChildren((Iterable<? extends NormalizedNode<?, ?>>)n.getValue());
        }
        if (node instanceof LeafSetNode) {
            LeafSetNode n = (LeafSetNode)node;
            this.writer.startLeafSet((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), NormalizedNodeWriter.childSizeHint(n.getValue()));
            return this.writeChildren((Iterable<? extends NormalizedNode<?, ?>>)n.getValue());
        }
        return false;
    }

    private static final class OrderedNormalizedNodeWriter
    extends NormalizedNodeWriter {
        private static final Logger LOG = LoggerFactory.getLogger(OrderedNormalizedNodeWriter.class);

        OrderedNormalizedNodeWriter(NormalizedNodeStreamWriter writer) {
            super(writer);
        }

        @Override
        protected boolean writeMapEntryNode(MapEntryNode node) throws IOException {
            NormalizedNodeStreamWriter nnWriter = this.getWriter();
            if (nnWriter instanceof NormalizedNodeStreamAttributeWriter) {
                ((NormalizedNodeStreamAttributeWriter)nnWriter).startMapEntryNode(node.getIdentifier(), OrderedNormalizedNodeWriter.childSizeHint(node.getValue()), node.getAttributes());
            } else {
                nnWriter.startMapEntryNode(node.getIdentifier(), OrderedNormalizedNodeWriter.childSizeHint(node.getValue()));
            }
            Set<QName> qnames = node.getIdentifier().getKeyValues().keySet();
            for (QName qname : qnames) {
                Optional child = node.getChild(new YangInstanceIdentifier.NodeIdentifier(qname));
                if (child.isPresent()) {
                    this.write((NormalizedNode)child.get());
                    continue;
                }
                LOG.info("No child for key element {} found", (Object)qname);
            }
            return this.writeChildren(Iterables.filter((Iterable)node.getValue(), input -> {
                if (input instanceof AugmentationNode) {
                    return true;
                }
                if (!qnames.contains(input.getNodeType())) {
                    return true;
                }
                LOG.debug("Skipping key child {}", input);
                return false;
            }));
        }
    }
}

