/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.impl.ModuleContext;
import org.opendaylight.mdsal.binding.model.api.AccessModifier;
import org.opendaylight.mdsal.binding.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.model.api.Constant;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Restrictions;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.EnumBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.TypeMemberBuilder;
import org.opendaylight.mdsal.binding.model.util.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.model.util.BindingTypes;
import org.opendaylight.mdsal.binding.model.util.ReferencedTypeImpl;
import org.opendaylight.mdsal.binding.model.util.Types;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.GeneratedPropertyBuilderImpl;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.mdsal.binding.yang.types.AbstractTypeProvider;
import org.opendaylight.mdsal.binding.yang.types.BaseYangTypes;
import org.opendaylight.mdsal.binding.yang.types.GroupingDefinitionDependencySort;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.ActionNodeContainer;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.DataNodeIterator;
import org.opendaylight.yangtools.yang.model.util.ModuleDependencySort;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.opendaylight.yangtools.yang.model.util.SchemaNodeUtils;
import org.opendaylight.yangtools.yang.model.util.type.CompatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTypeGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTypeGenerator.class);
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private static final JavaTypeName DEPRECATED_ANNOTATION = JavaTypeName.create(Deprecated.class);
    private static final JavaTypeName OVERRIDE_ANNOTATION = JavaTypeName.create(Override.class);
    private static final Type LIST_STRING_TYPE = Types.listTypeFor((Type)BaseYangTypes.STRING_TYPE);
    private static final Comparator<AugmentationSchemaNode> AUGMENT_COMP = (o1, o2) -> {
        Iterator thisIt = o1.getTargetPath().getPathFromRoot().iterator();
        Iterator otherIt = o2.getTargetPath().getPathFromRoot().iterator();
        while (thisIt.hasNext()) {
            if (!otherIt.hasNext()) {
                return 1;
            }
            int comp = ((QName)thisIt.next()).compareTo((QName)otherIt.next());
            if (comp == 0) continue;
            return comp;
        }
        return otherIt.hasNext() ? -1 : 0;
    };
    private static final String AUGMENT_IDENTIFIER_NAME = "augment-identifier";
    private static final String YANG_EXT_NAMESPACE = "urn:opendaylight:yang:extension:yang-ext";
    private final Map<QNameModule, ModuleContext> genCtx = new HashMap<QNameModule, ModuleContext>();
    private final Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders = new HashMap<String, Map<String, GeneratedTypeBuilder>>();
    private final AbstractTypeProvider typeProvider;
    private final SchemaContext schemaContext;
    private final Map<SchemaNode, JavaTypeName> renames;

    AbstractTypeGenerator(SchemaContext context, AbstractTypeProvider typeProvider, Map<SchemaNode, JavaTypeName> renames) {
        this.schemaContext = Objects.requireNonNull(context);
        this.typeProvider = Objects.requireNonNull(typeProvider);
        this.renames = Objects.requireNonNull(renames);
        List contextModules = ModuleDependencySort.sort((Collection)this.schemaContext.getModules());
        ArrayList<ModuleContext> contexts = new ArrayList<ModuleContext>(contextModules.size());
        for (Module contextModule : contextModules) {
            contexts.add(this.moduleToGenTypes(contextModule));
        }
        contexts.forEach(this::allAugmentsToGenTypes);
    }

    final Collection<ModuleContext> moduleContexts() {
        return this.genCtx.values();
    }

    final ModuleContext moduleContext(QNameModule module) {
        return Objects.requireNonNull(this.genCtx.get(module), () -> "Module context not found for module " + module);
    }

    final AbstractTypeProvider typeProvider() {
        return this.typeProvider;
    }

    abstract void addCodegenInformation(GeneratedTypeBuilderBase<?> var1, Module var2);

    abstract void addCodegenInformation(GeneratedTypeBuilderBase<?> var1, Module var2, SchemaNode var3);

    abstract void addCodegenInformation(GeneratedTypeBuilder var1, Module var2, String var3, Set<? extends SchemaNode> var4);

    abstract void addComment(TypeMemberBuilder<?> var1, DocumentedNode var2);

    private ModuleContext moduleToGenTypes(Module module) {
        ModuleContext context = new ModuleContext(module);
        this.genCtx.put(module.getQNameModule(), context);
        this.allTypeDefinitionsToGenTypes(context);
        this.groupingsToGenTypes(context, module.getGroupings());
        this.rpcMethodsToGenType(context);
        this.allIdentitiesToGenTypes(context);
        this.notificationsToGenType(context);
        if (!module.getChildNodes().isEmpty()) {
            GeneratedTypeBuilder moduleType = this.moduleToDataType(context);
            context.addModuleNode(moduleType);
            this.resolveDataSchemaNodes(context, moduleType, (Type)moduleType, module.getChildNodes(), false);
        }
        return context;
    }

    private void allTypeDefinitionsToGenTypes(ModuleContext context) {
        Module module = context.module();
        Preconditions.checkArgument((module.getName() != null ? 1 : 0) != 0, (Object)"Module name cannot be NULL.");
        DataNodeIterator it = new DataNodeIterator((DataNodeContainer)module);
        List typeDefinitions = it.allTypedefs();
        Preconditions.checkState((typeDefinitions != null ? 1 : 0) != 0, (String)"Type Definitions for module %s cannot be NULL.", (Object)module.getName());
        for (TypeDefinition typedef : typeDefinitions) {
            Type type;
            if (typedef == null || (type = this.typeProvider.generatedTypeForExtendedDefinitionType(typedef, (SchemaNode)typedef)) == null) continue;
            context.addTypedefType(typedef, type);
            context.addTypeToSchema(type, typedef);
        }
    }

    private GeneratedTypeBuilder processDataSchemaNode(ModuleContext context, Type baseInterface, DataSchemaNode node, boolean inGrouping) {
        if (node.isAugmenting() || node.isAddedByUses()) {
            return null;
        }
        GeneratedTypeBuilder genType = this.addDefaultInterfaceDefinition(context, (SchemaNode)node, baseInterface);
        AbstractTypeGenerator.annotateDeprecatedIfNecessary(node.getStatus(), (AnnotableTypeBuilder)genType);
        Module module = context.module();
        genType.setModuleName(module.getName());
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)genType, module, (SchemaNode)node);
        genType.setSchemaPath(node.getPath());
        if (node instanceof DataNodeContainer) {
            context.addChildNodeType((SchemaNode)node, genType);
            this.groupingsToGenTypes(context, ((DataNodeContainer)node).getGroupings());
            this.processUsesAugments((DataNodeContainer)node, context, inGrouping);
        }
        return genType;
    }

    private void containerToGenType(ModuleContext context, GeneratedTypeBuilder parent, Type baseInterface, ContainerSchemaNode node, boolean inGrouping) {
        GeneratedTypeBuilder genType = this.processDataSchemaNode(context, baseInterface, (DataSchemaNode)node, inGrouping);
        if (genType != null) {
            this.constructGetter(parent, (Type)genType, (SchemaNode)node);
            this.resolveDataSchemaNodes(context, genType, (Type)genType, node.getChildNodes(), inGrouping);
            this.actionsToGenType(context, (Type)genType, node, null, inGrouping);
        }
    }

    private void listToGenType(ModuleContext context, GeneratedTypeBuilder parent, Type baseInterface, ListSchemaNode node, boolean inGrouping) {
        GeneratedTypeBuilder genType = this.processDataSchemaNode(context, baseInterface, (DataSchemaNode)node, inGrouping);
        if (genType != null) {
            ParameterizedType listType = Types.listTypeFor((Type)genType);
            this.constructGetter(parent, (Type)listType, (SchemaNode)node);
            AbstractTypeGenerator.constructNonnull(parent, (Type)listType, node);
            List<String> listKeys = AbstractTypeGenerator.listKeys(node);
            GeneratedTOBuilder genTOBuilder = this.resolveListKeyTOBuilder(context, node);
            if (genTOBuilder != null) {
                ParameterizedType identifierMarker = BindingTypes.identifier((Type)genType);
                ParameterizedType identifiableMarker = BindingTypes.identifiable((Type)genTOBuilder);
                genTOBuilder.addImplementsType((Type)identifierMarker);
                genType.addImplementsType((Type)identifiableMarker);
            }
            this.actionsToGenType(context, (Type)genType, node, (Type)genTOBuilder, inGrouping);
            for (DataSchemaNode schemaNode : node.getChildNodes()) {
                if (schemaNode.isAugmenting()) continue;
                this.addSchemaNodeToListBuilders(context, schemaNode, genType, genTOBuilder, listKeys, inGrouping);
            }
            if (genTOBuilder != null) {
                GeneratedPropertyBuilderImpl prop = new GeneratedPropertyBuilderImpl("serialVersionUID");
                prop.setValue(Long.toString(BindingGeneratorUtil.computeDefaultSUID((GeneratedTypeBuilderBase)genTOBuilder)));
                genTOBuilder.setSUID((GeneratedPropertyBuilder)prop);
            }
            AbstractTypeGenerator.typeBuildersToGenTypes(context, genType, genTOBuilder);
        }
    }

    private void processUsesAugments(DataNodeContainer node, ModuleContext context, boolean inGrouping) {
        for (UsesNode usesNode : node.getUses()) {
            for (AugmentationSchemaNode augment : usesNode.getAugmentations()) {
                this.usesAugmentationToGenTypes(context, augment, usesNode, node, inGrouping);
                this.processUsesAugments((DataNodeContainer)augment, context, inGrouping);
            }
        }
    }

    private void allAugmentsToGenTypes(ModuleContext context) {
        Module module = context.module();
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL.");
        Preconditions.checkArgument((module.getName() != null ? 1 : 0) != 0, (Object)"Module name cannot be NULL.");
        Preconditions.checkState((module.getAugmentations() != null ? 1 : 0) != 0, (Object)"Augmentations Set cannot be NULL.");
        for (AugmentationSchemaNode augment : AbstractTypeGenerator.resolveAugmentations(module)) {
            this.augmentationToGenTypes(context, augment);
        }
    }

    private static List<AugmentationSchemaNode> resolveAugmentations(Module module) {
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL.");
        Preconditions.checkState((module.getAugmentations() != null ? 1 : 0) != 0, (Object)"Augmentations Set cannot be NULL.");
        Set augmentations = module.getAugmentations();
        ArrayList<AugmentationSchemaNode> sortedAugmentations = new ArrayList<AugmentationSchemaNode>(augmentations);
        sortedAugmentations.sort(AUGMENT_COMP);
        return sortedAugmentations;
    }

    private GeneratedTypeBuilder moduleToDataType(ModuleContext context) {
        GeneratedTypeBuilder moduleDataTypeBuilder = this.moduleTypeBuilder(context, "Data");
        Module module = context.module();
        this.addImplementedInterfaceFromUses((DataNodeContainer)module, moduleDataTypeBuilder);
        moduleDataTypeBuilder.addImplementsType((Type)BindingTypes.DATA_ROOT);
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)moduleDataTypeBuilder, module);
        return moduleDataTypeBuilder;
    }

    private <T extends DataNodeContainer & ActionNodeContainer> void actionsToGenType(ModuleContext context, Type parent, T parentSchema, Type keyType, boolean inGrouping) {
        for (ActionDefinition action : ((ActionNodeContainer)parentSchema).getActions()) {
            GeneratedType output;
            GeneratedType input;
            if (action.isAddedByUses()) {
                ActionDefinition orig = this.findOrigAction(parentSchema, action).get();
                input = context.getChildNode(orig.getInput().getPath()).build();
                output = context.getChildNode(orig.getOutput().getPath()).build();
            } else {
                input = this.actionContainer(context, (Type)BindingTypes.RPC_INPUT, action.getInput(), inGrouping);
                output = this.actionContainer(context, (Type)BindingTypes.RPC_OUTPUT, action.getOutput(), inGrouping);
            }
            if (parentSchema instanceof GroupingDefinition) continue;
            QName qname = action.getQName();
            GeneratedTypeBuilder builder = this.typeProvider.newGeneratedTypeBuilder(JavaTypeName.create((String)BindingGeneratorUtil.packageNameForGeneratedType((String)context.modulePackageName(), (SchemaPath)action.getPath()), (String)BindingMapping.getClassName((QName)qname)));
            AbstractTypeGenerator.qnameConstant(builder, JavaTypeName.create((String)context.modulePackageName(), (String)"$YangModuleInfoImpl"), qname.getLocalName());
            AbstractTypeGenerator.annotateDeprecatedIfNecessary(action.getStatus(), (AnnotableTypeBuilder)builder);
            builder.addImplementsType((Type)(keyType != null ? BindingTypes.keyedListAction((Type)parent, (Type)keyType, (Type)input, (Type)output) : BindingTypes.action((Type)parent, (Type)input, (Type)output)));
            this.addCodegenInformation((GeneratedTypeBuilderBase<?>)builder, context.module(), (SchemaNode)action);
            context.addChildNodeType((SchemaNode)action, builder);
        }
    }

    private Optional<ActionDefinition> findOrigAction(DataNodeContainer parent, ActionDefinition action) {
        for (UsesNode uses : parent.getUses()) {
            GroupingDefinition grp = this.findUsedGrouping(uses);
            Optional<ActionDefinition> found = grp.getActions().stream().filter(act -> action.getQName().equals((Object)act.getQName())).findFirst();
            if (!found.isPresent()) continue;
            ActionDefinition result = found.get();
            return result.isAddedByUses() ? this.findOrigAction((DataNodeContainer)grp, result) : found;
        }
        return Optional.empty();
    }

    private GeneratedType actionContainer(ModuleContext context, Type baseInterface, ContainerSchemaNode schema, boolean inGrouping) {
        GeneratedTypeBuilder genType = this.processDataSchemaNode(context, baseInterface, (DataSchemaNode)schema, inGrouping);
        this.resolveDataSchemaNodes(context, genType, (Type)genType, schema.getChildNodes(), inGrouping);
        return genType.build();
    }

    private void rpcMethodsToGenType(ModuleContext context) {
        Module module = context.module();
        Preconditions.checkArgument((module.getName() != null ? 1 : 0) != 0, (Object)"Module name cannot be NULL.");
        Set rpcDefinitions = module.getRpcs();
        Preconditions.checkState((rpcDefinitions != null ? 1 : 0) != 0, (Object)("Set of rpcs from module " + module.getName() + " cannot be NULL."));
        if (rpcDefinitions.isEmpty()) {
            return;
        }
        GeneratedTypeBuilder interfaceBuilder = this.moduleTypeBuilder(context, "Service");
        interfaceBuilder.addImplementsType((Type)BindingTypes.RPC_SERVICE);
        this.addCodegenInformation(interfaceBuilder, module, "RPCs", rpcDefinitions);
        for (RpcDefinition rpc : rpcDefinitions) {
            if (rpc == null) continue;
            String rpcName = BindingMapping.getClassName((QName)rpc.getQName());
            String rpcMethodName = BindingMapping.getPropertyName((String)rpcName);
            MethodSignatureBuilder method = interfaceBuilder.addMethod(rpcMethodName);
            this.addComment((TypeMemberBuilder<?>)method, (DocumentedNode)rpc);
            method.addParameter(this.createRpcContainer(context, rpcName, rpc, (ContainerSchemaNode)Verify.verifyNotNull((Object)rpc.getInput()), (Type)BindingTypes.RPC_INPUT), "input");
            method.setReturnType((Type)Types.listenableFutureTypeFor((Type)BindingTypes.rpcResult((Type)this.createRpcContainer(context, rpcName, rpc, (ContainerSchemaNode)Verify.verifyNotNull((Object)rpc.getOutput()), (Type)BindingTypes.RPC_OUTPUT))));
        }
        context.addTopLevelNodeType(interfaceBuilder);
    }

    private Type createRpcContainer(ModuleContext context, String rpcName, RpcDefinition rpc, ContainerSchemaNode schema, Type type) {
        this.processUsesAugments((DataNodeContainer)schema, context, false);
        GeneratedTypeBuilder outType = this.addRawInterfaceDefinition(JavaTypeName.create((String)context.modulePackageName(), (String)(rpcName + BindingMapping.getClassName((QName)schema.getQName()))), (SchemaNode)schema);
        this.addImplementedInterfaceFromUses((DataNodeContainer)schema, outType);
        outType.addImplementsType(type);
        outType.addImplementsType((Type)BindingTypes.augmentable((Type)outType));
        AbstractTypeGenerator.annotateDeprecatedIfNecessary(rpc.getStatus(), (AnnotableTypeBuilder)outType);
        this.resolveDataSchemaNodes(context, outType, (Type)outType, schema.getChildNodes(), false);
        context.addChildNodeType((SchemaNode)schema, outType);
        return outType.build();
    }

    private void notificationsToGenType(ModuleContext context) {
        Module module = context.module();
        Preconditions.checkArgument((module.getName() != null ? 1 : 0) != 0, (Object)"Module name cannot be NULL.");
        Set notifications = module.getNotifications();
        if (notifications.isEmpty()) {
            return;
        }
        GeneratedTypeBuilder listenerInterface = this.moduleTypeBuilder(context, "Listener");
        listenerInterface.addImplementsType((Type)BindingTypes.NOTIFICATION_LISTENER);
        for (NotificationDefinition notification : notifications) {
            if (notification == null) continue;
            this.processUsesAugments((DataNodeContainer)notification, context, false);
            GeneratedTypeBuilder notificationInterface = this.addDefaultInterfaceDefinition(context.modulePackageName(), (SchemaNode)notification, (Type)BindingTypes.DATA_OBJECT, context);
            AbstractTypeGenerator.annotateDeprecatedIfNecessary(notification.getStatus(), (AnnotableTypeBuilder)notificationInterface);
            notificationInterface.addImplementsType((Type)BindingTypes.NOTIFICATION);
            context.addChildNodeType((SchemaNode)notification, notificationInterface);
            this.resolveDataSchemaNodes(context, notificationInterface, (Type)notificationInterface, notification.getChildNodes(), false);
            this.addComment(((MethodSignatureBuilder)listenerInterface.addMethod("on" + notificationInterface.getName()).setAccessModifier(AccessModifier.PUBLIC)).addParameter((Type)notificationInterface, "notification").setReturnType((Type)Types.primitiveVoidType()), (DocumentedNode)notification);
        }
        this.addCodegenInformation(listenerInterface, module, "notifications", notifications);
        context.addTopLevelNodeType(listenerInterface);
    }

    private void allIdentitiesToGenTypes(ModuleContext context) {
        Set schemaIdentities = context.module().getIdentities();
        if (schemaIdentities != null && !schemaIdentities.isEmpty()) {
            for (IdentitySchemaNode identity : schemaIdentities) {
                this.identityToGenType(context, identity);
            }
        }
    }

    private void identityToGenType(ModuleContext context, IdentitySchemaNode identity) {
        if (identity == null) {
            return;
        }
        JavaTypeName name = this.renames.get(identity);
        if (name == null) {
            name = JavaTypeName.create((String)BindingGeneratorUtil.packageNameForGeneratedType((String)context.modulePackageName(), (SchemaPath)identity.getPath()), (String)BindingMapping.getClassName((QName)identity.getQName()));
        }
        GeneratedTypeBuilder newType = this.typeProvider.newGeneratedTypeBuilder(name);
        Set baseIdentities = identity.getBaseIdentities();
        if (!baseIdentities.isEmpty()) {
            for (IdentitySchemaNode baseIdentity : baseIdentities) {
                JavaTypeName base = this.renames.get(baseIdentity);
                if (base == null) {
                    QName qname = baseIdentity.getQName();
                    base = JavaTypeName.create((String)BindingMapping.getRootPackageName((QNameModule)qname.getModule()), (String)BindingMapping.getClassName((QName)qname));
                }
                GeneratedTransferObject gto = this.typeProvider.newGeneratedTOBuilder(base).build();
                newType.addImplementsType((Type)gto);
            }
        } else {
            newType.addImplementsType((Type)BindingTypes.BASE_IDENTITY);
        }
        Module module = context.module();
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)newType, module, (SchemaNode)identity);
        newType.setModuleName(module.getName());
        newType.setSchemaPath(identity.getPath());
        AbstractTypeGenerator.qnameConstant(newType, JavaTypeName.create((String)context.modulePackageName(), (String)"$YangModuleInfoImpl"), identity.getQName().getLocalName());
        context.addIdentityType(identity, newType);
    }

    private static Constant qnameConstant(GeneratedTypeBuilderBase<?> toBuilder, JavaTypeName yangModuleInfo, String localName) {
        return toBuilder.addConstant((Type)Types.typeForClass(QName.class), "QNAME", new AbstractMap.SimpleImmutableEntry<JavaTypeName, String>(yangModuleInfo, localName));
    }

    private void groupingsToGenTypes(ModuleContext context, Collection<GroupingDefinition> groupings) {
        for (GroupingDefinition grouping : new GroupingDefinitionDependencySort().sort(groupings)) {
            GeneratedTypeBuilder genType = this.addDefaultInterfaceDefinition(context, (SchemaNode)grouping);
            AbstractTypeGenerator.annotateDeprecatedIfNecessary(grouping.getStatus(), (AnnotableTypeBuilder)genType);
            context.addGroupingType(grouping, genType);
            this.resolveDataSchemaNodes(context, genType, (Type)genType, grouping.getChildNodes(), true);
            this.groupingsToGenTypes(context, grouping.getGroupings());
            this.processUsesAugments((DataNodeContainer)grouping, context, true);
            this.actionsToGenType(context, (Type)genType, grouping, null, true);
        }
    }

    private EnumBuilder resolveInnerEnumFromTypeDefinition(EnumTypeDefinition enumTypeDef, QName enumName, GeneratedTypeBuilder typeBuilder, ModuleContext context) {
        if (enumTypeDef != null && typeBuilder != null && enumTypeDef.getQName().getLocalName() != null) {
            EnumBuilder enumBuilder = typeBuilder.addEnumeration(BindingMapping.getClassName((QName)enumName));
            this.typeProvider.addEnumDescription(enumBuilder, enumTypeDef);
            enumBuilder.updateEnumPairsFromEnumTypeDef(enumTypeDef);
            context.addInnerTypedefType(enumTypeDef.getPath(), (Type)enumBuilder);
            return enumBuilder;
        }
        return null;
    }

    private GeneratedTypeBuilder moduleTypeBuilder(ModuleContext context, String postfix) {
        Module module = context.module();
        String moduleName = BindingMapping.getClassName((String)module.getName()) + postfix;
        GeneratedTypeBuilder moduleBuilder = this.typeProvider.newGeneratedTypeBuilder(JavaTypeName.create((String)context.modulePackageName(), (String)moduleName));
        moduleBuilder.setModuleName(moduleName);
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)moduleBuilder, module);
        return moduleBuilder;
    }

    private void augmentationToGenTypes(ModuleContext context, AugmentationSchemaNode augSchema) {
        Preconditions.checkArgument((augSchema != null ? 1 : 0) != 0, (Object)"Augmentation Schema cannot be NULL.");
        Preconditions.checkState((augSchema.getTargetPath() != null ? 1 : 0) != 0, (Object)"Augmentation Schema does not contain Target Path (Target Path is NULL).");
        this.processUsesAugments((DataNodeContainer)augSchema, context, false);
        SchemaPath targetPath = augSchema.getTargetPath();
        SchemaNode targetSchemaNode = null;
        targetSchemaNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)targetPath);
        if (targetSchemaNode instanceof DataSchemaNode && ((DataSchemaNode)targetSchemaNode).isAddedByUses()) {
            if (targetSchemaNode instanceof DerivableSchemaNode) {
                targetSchemaNode = ((DerivableSchemaNode)targetSchemaNode).getOriginal().orElse(null);
            }
            if (targetSchemaNode == null) {
                throw new IllegalStateException("Failed to find target node from grouping in augmentation " + augSchema + " in module " + context.module().getName());
            }
        }
        if (targetSchemaNode == null) {
            throw new IllegalArgumentException("augment target not found: " + targetPath);
        }
        GeneratedTypeBuilder targetTypeBuilder = this.findChildNodeByPath(targetSchemaNode.getPath());
        if (targetTypeBuilder == null) {
            targetTypeBuilder = this.findCaseByPath(targetSchemaNode.getPath());
        }
        if (targetTypeBuilder == null) {
            throw new NullPointerException("Target type not yet generated: " + targetSchemaNode);
        }
        if (!(targetSchemaNode instanceof ChoiceSchemaNode)) {
            ReferencedTypeImpl targetType = new ReferencedTypeImpl((JavaTypeName)targetTypeBuilder.getIdentifier());
            this.addRawAugmentGenTypeDefinition(context, (Type)targetType, augSchema, false);
        } else {
            this.generateTypesFromAugmentedChoiceCases(context, (Type)targetTypeBuilder.build(), (ChoiceSchemaNode)targetSchemaNode, augSchema.getChildNodes(), null, false);
        }
    }

    private void usesAugmentationToGenTypes(ModuleContext context, AugmentationSchemaNode augSchema, UsesNode usesNode, DataNodeContainer usesNodeParent, boolean inGrouping) {
        Preconditions.checkArgument((augSchema != null ? 1 : 0) != 0, (Object)"Augmentation Schema cannot be NULL.");
        Preconditions.checkState((augSchema.getTargetPath() != null ? 1 : 0) != 0, (Object)"Augmentation Schema does not contain Target Path (Target Path is NULL).");
        this.processUsesAugments((DataNodeContainer)augSchema, context, inGrouping);
        SchemaPath targetPath = augSchema.getTargetPath();
        DataSchemaNode targetSchemaNode = this.findOriginalTargetFromGrouping(targetPath, usesNode);
        if (targetSchemaNode == null) {
            throw new IllegalArgumentException("augment target not found: " + targetPath);
        }
        GeneratedTypeBuilder targetTypeBuilder = this.findChildNodeByPath(targetSchemaNode.getPath());
        if (targetTypeBuilder == null) {
            targetTypeBuilder = this.findCaseByPath(targetSchemaNode.getPath());
        }
        if (targetTypeBuilder == null) {
            throw new NullPointerException("Target type not yet generated: " + targetSchemaNode);
        }
        if (!(targetSchemaNode instanceof ChoiceSchemaNode)) {
            if (usesNodeParent instanceof SchemaNode) {
                this.addRawAugmentGenTypeDefinition(context, BindingGeneratorUtil.packageNameForAugmentedGeneratedType((String)context.modulePackageName(), (SchemaPath)((SchemaNode)usesNodeParent).getPath()), (Type)targetTypeBuilder.build(), augSchema, inGrouping);
            } else {
                this.addRawAugmentGenTypeDefinition(context, (Type)targetTypeBuilder.build(), augSchema, inGrouping);
            }
        } else {
            this.generateTypesFromAugmentedChoiceCases(context, (Type)targetTypeBuilder.build(), (ChoiceSchemaNode)targetSchemaNode, augSchema.getChildNodes(), usesNodeParent, inGrouping);
        }
    }

    private GroupingDefinition findUsedGrouping(UsesNode uses) {
        SchemaNode targetGrouping = SchemaContextUtil.findNodeInSchemaContext((SchemaContext)this.schemaContext, (Iterable)uses.getGroupingPath().getPathFromRoot());
        if (targetGrouping instanceof GroupingDefinition) {
            return (GroupingDefinition)targetGrouping;
        }
        throw new IllegalArgumentException("Failed to resolve used grouping for " + uses);
    }

    private DataSchemaNode findOriginalTargetFromGrouping(SchemaPath targetPath, UsesNode parentUsesNode) {
        GroupingDefinition result = this.findUsedGrouping(parentUsesNode);
        for (QName node : targetPath.getPathFromRoot()) {
            if (result instanceof DataNodeContainer) {
                QName resultNode = node.withModule(result.getQName().getModule());
                result = ((DataNodeContainer)result).getDataChildByName(resultNode);
                continue;
            }
            if (!(result instanceof ChoiceSchemaNode)) continue;
            result = AbstractTypeGenerator.findNamedCase((ChoiceSchemaNode)result, node.getLocalName());
        }
        if (result == null) {
            return null;
        }
        if (result instanceof DerivableSchemaNode) {
            DerivableSchemaNode castedResult = (DerivableSchemaNode)result;
            Optional originalNode = castedResult.getOriginal();
            if (castedResult.isAddedByUses() && originalNode.isPresent()) {
                result = (SchemaNode)originalNode.get();
            }
        }
        if (result instanceof DataSchemaNode) {
            DataSchemaNode resultDataSchemaNode = (DataSchemaNode)result;
            if (resultDataSchemaNode.isAddedByUses()) {
                throw new IllegalStateException("Failed to generate code for augment in " + parentUsesNode);
            }
            return resultDataSchemaNode;
        }
        throw new IllegalStateException("Target node of uses-augment statement must be DataSchemaNode. Failed to generate code for augment in " + parentUsesNode);
    }

    private GeneratedTypeBuilder addRawAugmentGenTypeDefinition(ModuleContext context, String augmentPackageName, Type targetTypeRef, AugmentationSchemaNode augSchema, boolean inGrouping) {
        Map augmentBuilders = this.genTypeBuilders.computeIfAbsent(augmentPackageName, k -> new HashMap());
        String augIdentifier = AbstractTypeGenerator.getAugmentIdentifier(augSchema.getUnknownSchemaNodes());
        String augTypeName = augIdentifier != null ? BindingMapping.getClassName((String)augIdentifier) : AbstractTypeGenerator.augGenTypeName(augmentBuilders, targetTypeRef.getName());
        GeneratedTypeBuilder augTypeBuilder = this.typeProvider.newGeneratedTypeBuilder(JavaTypeName.create((String)augmentPackageName, (String)augTypeName));
        augTypeBuilder.addImplementsType((Type)BindingTypes.DATA_OBJECT);
        augTypeBuilder.addImplementsType((Type)Types.augmentationTypeFor((Type)targetTypeRef));
        AbstractTypeGenerator.annotateDeprecatedIfNecessary(augSchema.getStatus(), (AnnotableTypeBuilder)augTypeBuilder);
        this.addImplementedInterfaceFromUses((DataNodeContainer)augSchema, augTypeBuilder);
        this.augSchemaNodeToMethods(context, augTypeBuilder, augSchema.getChildNodes(), inGrouping);
        augmentBuilders.put(augTypeName, augTypeBuilder);
        if (!augSchema.getChildNodes().isEmpty()) {
            context.addTypeToAugmentation(augTypeBuilder, augSchema);
        }
        context.addAugmentType(augTypeBuilder);
        return augTypeBuilder;
    }

    private GeneratedTypeBuilder addRawAugmentGenTypeDefinition(ModuleContext context, Type targetTypeRef, AugmentationSchemaNode augSchema, boolean inGrouping) {
        return this.addRawAugmentGenTypeDefinition(context, context.modulePackageName(), targetTypeRef, augSchema, inGrouping);
    }

    private static String getAugmentIdentifier(List<UnknownSchemaNode> unknownSchemaNodes) {
        for (UnknownSchemaNode unknownSchemaNode : unknownSchemaNodes) {
            QName nodeType = unknownSchemaNode.getNodeType();
            if (!AUGMENT_IDENTIFIER_NAME.equals(nodeType.getLocalName()) || !YANG_EXT_NAMESPACE.equals(nodeType.getNamespace().toString())) continue;
            return unknownSchemaNode.getNodeParameter();
        }
        return null;
    }

    private static String augGenTypeName(Map<String, GeneratedTypeBuilder> builders, String genTypeName) {
        int index = 1;
        if (builders != null) {
            while (builders.containsKey(genTypeName + index)) {
                ++index;
            }
        }
        return genTypeName + index;
    }

    private GeneratedTypeBuilder resolveDataSchemaNodes(ModuleContext context, GeneratedTypeBuilder parent, @Nullable Type childOf, Iterable<DataSchemaNode> schemaNodes, boolean inGrouping) {
        if (schemaNodes != null && parent != null) {
            ConcreteType baseInterface = childOf == null ? BindingTypes.DATA_OBJECT : BindingTypes.childOf((Type)childOf);
            for (DataSchemaNode schemaNode : schemaNodes) {
                if (schemaNode.isAugmenting() || schemaNode.isAddedByUses()) continue;
                this.addSchemaNodeToBuilderAsMethod(context, schemaNode, parent, (Type)baseInterface, inGrouping);
            }
        }
        return parent;
    }

    private GeneratedTypeBuilder augSchemaNodeToMethods(ModuleContext context, GeneratedTypeBuilder typeBuilder, Iterable<DataSchemaNode> schemaNodes, boolean inGrouping) {
        if (schemaNodes != null && typeBuilder != null) {
            ParameterizedType baseInterface = BindingTypes.childOf((Type)typeBuilder);
            for (DataSchemaNode schemaNode : schemaNodes) {
                if (schemaNode.isAugmenting()) continue;
                this.addSchemaNodeToBuilderAsMethod(context, schemaNode, typeBuilder, (Type)baseInterface, inGrouping);
            }
        }
        return typeBuilder;
    }

    private void addSchemaNodeToBuilderAsMethod(ModuleContext context, DataSchemaNode node, GeneratedTypeBuilder typeBuilder, Type baseInterface, boolean inGrouping) {
        if (node != null && typeBuilder != null) {
            if (node instanceof LeafSchemaNode) {
                this.resolveLeafSchemaNodeAsMethod(typeBuilder, (LeafSchemaNode)node, context, inGrouping);
            } else if (node instanceof LeafListSchemaNode) {
                this.resolveLeafListSchemaNode(typeBuilder, (LeafListSchemaNode)node, context, inGrouping);
            } else if (node instanceof ContainerSchemaNode) {
                this.containerToGenType(context, typeBuilder, baseInterface, (ContainerSchemaNode)node, inGrouping);
            } else if (node instanceof ListSchemaNode) {
                this.listToGenType(context, typeBuilder, baseInterface, (ListSchemaNode)node, inGrouping);
            } else if (node instanceof ChoiceSchemaNode) {
                this.choiceToGeneratedType(context, typeBuilder, (ChoiceSchemaNode)node, inGrouping);
            } else {
                LOG.debug("Unable to add schema node {} as method in {}: unsupported type of node.", node.getClass(), (Object)typeBuilder.getFullyQualifiedName());
            }
        }
    }

    private void choiceToGeneratedType(ModuleContext context, GeneratedTypeBuilder parent, ChoiceSchemaNode choiceNode, boolean inGrouping) {
        Preconditions.checkArgument((choiceNode != null ? 1 : 0) != 0, (Object)"Choice Schema Node cannot be NULL.");
        if (!choiceNode.isAddedByUses()) {
            GeneratedTypeBuilder choiceTypeBuilder = this.addRawInterfaceDefinition(JavaTypeName.create((String)BindingGeneratorUtil.packageNameForGeneratedType((String)context.modulePackageName(), (SchemaPath)choiceNode.getPath()), (String)BindingMapping.getClassName((QName)choiceNode.getQName())), (SchemaNode)choiceNode);
            choiceTypeBuilder.addImplementsType((Type)BindingTypes.choiceIn((Type)parent));
            AbstractTypeGenerator.annotateDeprecatedIfNecessary(choiceNode.getStatus(), (AnnotableTypeBuilder)choiceTypeBuilder);
            context.addChildNodeType((SchemaNode)choiceNode, choiceTypeBuilder);
            GeneratedType choiceType = choiceTypeBuilder.build();
            this.generateTypesFromChoiceCases(context, (Type)choiceType, choiceNode, inGrouping);
            this.constructGetter(parent, (Type)choiceType, (SchemaNode)choiceNode);
        }
    }

    private void generateTypesFromChoiceCases(ModuleContext context, Type refChoiceType, ChoiceSchemaNode choiceNode, boolean inGrouping) {
        Preconditions.checkArgument((refChoiceType != null ? 1 : 0) != 0, (Object)"Referenced Choice Type cannot be NULL.");
        Preconditions.checkArgument((choiceNode != null ? 1 : 0) != 0, (Object)"ChoiceNode cannot be NULL.");
        for (CaseSchemaNode caseNode : choiceNode.getCases().values()) {
            if (caseNode != null && !caseNode.isAddedByUses() && !caseNode.isAugmenting()) {
                GeneratedTypeBuilder caseTypeBuilder = this.addDefaultInterfaceDefinition(context, (SchemaNode)caseNode);
                caseTypeBuilder.addImplementsType(refChoiceType);
                AbstractTypeGenerator.annotateDeprecatedIfNecessary(caseNode.getStatus(), (AnnotableTypeBuilder)caseTypeBuilder);
                context.addCaseType(caseNode.getPath(), caseTypeBuilder);
                context.addChoiceToCaseMapping(refChoiceType, (Type)caseTypeBuilder, caseNode);
                Collection caseChildNodes = caseNode.getChildNodes();
                if (caseChildNodes != null) {
                    SchemaPath choiceNodeParentPath = choiceNode.getPath().getParent();
                    if (!Iterables.isEmpty((Iterable)choiceNodeParentPath.getPathFromRoot())) {
                        SchemaNode parent = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)choiceNodeParentPath);
                        if (parent instanceof AugmentationSchemaNode) {
                            AugmentationSchemaNode augSchema = (AugmentationSchemaNode)parent;
                            SchemaPath targetPath = augSchema.getTargetPath();
                            SchemaNode targetSchemaNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)targetPath);
                            if (targetSchemaNode instanceof DataSchemaNode && ((DataSchemaNode)targetSchemaNode).isAddedByUses()) {
                                if (targetSchemaNode instanceof DerivableSchemaNode) {
                                    targetSchemaNode = ((DerivableSchemaNode)targetSchemaNode).getOriginal().orElse(null);
                                }
                                if (targetSchemaNode == null) {
                                    throw new IllegalStateException("Failed to find target node from grouping for augmentation " + augSchema + " in module " + context.module().getName());
                                }
                            }
                            parent = targetSchemaNode;
                        }
                        Preconditions.checkState((parent != null ? 1 : 0) != 0, (String)"Could not find Choice node parent %s", (Object)choiceNodeParentPath);
                        GeneratedTypeBuilder childOfType = this.findChildNodeByPath(parent.getPath());
                        if (childOfType == null) {
                            childOfType = this.findGroupingByPath(parent.getPath());
                        }
                        this.resolveDataSchemaNodes(context, caseTypeBuilder, (Type)childOfType, caseChildNodes, inGrouping);
                    } else {
                        this.resolveDataSchemaNodes(context, caseTypeBuilder, (Type)this.moduleToDataType(context), caseChildNodes, inGrouping);
                    }
                }
            }
            this.processUsesAugments((DataNodeContainer)caseNode, context, inGrouping);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    private void generateTypesFromAugmentedChoiceCases(ModuleContext context, Type targetType, ChoiceSchemaNode targetNode, Iterable<DataSchemaNode> augmentedNodes, DataNodeContainer usesNodeParent, boolean inGrouping) {
        Preconditions.checkArgument((targetType != null ? 1 : 0) != 0, (Object)"Referenced Choice Type cannot be NULL.");
        Preconditions.checkArgument((augmentedNodes != null ? 1 : 0) != 0, (Object)"Set of Choice Case Nodes cannot be NULL.");
        for (DataSchemaNode caseNode : augmentedNodes) {
            if (caseNode == null) continue;
            GeneratedTypeBuilder caseTypeBuilder = this.addDefaultInterfaceDefinition(context, (SchemaNode)caseNode);
            caseTypeBuilder.addImplementsType(targetType);
            CaseSchemaNode node = null;
            String caseLocalName = caseNode.getQName().getLocalName();
            if (caseNode instanceof CaseSchemaNode) {
                node = (CaseSchemaNode)caseNode;
            } else if (AbstractTypeGenerator.findNamedCase(targetNode, caseLocalName) == null) {
                String targetNodeLocalName = targetNode.getQName().getLocalName();
                for (DataSchemaNode dataSchemaNode : usesNodeParent.getChildNodes()) {
                    if (!(dataSchemaNode instanceof ChoiceSchemaNode) || !targetNodeLocalName.equals(dataSchemaNode.getQName().getLocalName())) continue;
                    node = AbstractTypeGenerator.findNamedCase((ChoiceSchemaNode)dataSchemaNode, caseLocalName);
                    break;
                }
            } else {
                node = AbstractTypeGenerator.findNamedCase(targetNode, caseLocalName);
            }
            Collection childNodes = node.getChildNodes();
            if (childNodes != null) {
                this.resolveDataSchemaNodes(context, caseTypeBuilder, (Type)this.findChildOfType(targetNode), childNodes, inGrouping);
            }
            context.addCaseType(caseNode.getPath(), caseTypeBuilder);
            context.addChoiceToCaseMapping(targetType, (Type)caseTypeBuilder, node);
        }
    }

    private GeneratedTypeBuilder findChildOfType(ChoiceSchemaNode targetNode) {
        SchemaPath nodePath = targetNode.getPath();
        SchemaPath parentSp = nodePath.getParent();
        if (parentSp.getParent() == null) {
            return this.moduleContext(nodePath.getLastComponent().getModule()).getModuleNode();
        }
        SchemaNode parent = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)parentSp);
        GeneratedTypeBuilder childOfType = null;
        if (parent instanceof CaseSchemaNode) {
            childOfType = this.findCaseByPath(parent.getPath());
        } else if (parent instanceof DataSchemaNode || parent instanceof NotificationDefinition) {
            childOfType = this.findChildNodeByPath(parent.getPath());
        } else if (parent instanceof GroupingDefinition) {
            childOfType = this.findGroupingByPath(parent.getPath());
        }
        if (childOfType == null) {
            throw new IllegalArgumentException("Failed to find parent type of choice " + targetNode);
        }
        return childOfType;
    }

    private static CaseSchemaNode findNamedCase(ChoiceSchemaNode choice, String caseName) {
        List cases = choice.findCaseNodes(caseName);
        return cases.isEmpty() ? null : (CaseSchemaNode)cases.get(0);
    }

    private static boolean isInnerType(LeafSchemaNode leaf, TypeDefinition<?> type) {
        if (leaf.getPath().equals((Object)type.getPath())) {
            return true;
        }
        return leaf.getPath().equals((Object)type.getPath().getParent());
    }

    private void addPatternConstant(GeneratedTypeBuilder typeBuilder, String leafName, List<PatternConstraint> patternConstraints) {
        if (!patternConstraints.isEmpty()) {
            StringBuilder field = new StringBuilder().append("PATTERN_CONSTANTS").append("_").append(BindingMapping.getPropertyName((String)leafName));
            typeBuilder.addConstant(LIST_STRING_TYPE, field.toString(), this.typeProvider.resolveRegExpressions(patternConstraints));
        }
    }

    private Type resolveLeafSchemaNodeAsMethod(GeneratedTypeBuilder typeBuilder, LeafSchemaNode leaf, ModuleContext context, boolean inGrouping) {
        Restrictions restrictions;
        if (leaf == null || typeBuilder == null || leaf.isAddedByUses()) {
            return null;
        }
        Module parentModule = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)leaf);
        Type returnType = null;
        TypeDefinition typeDef = CompatUtils.compatLeafType((LeafSchemaNode)leaf);
        if (AbstractTypeGenerator.isInnerType(leaf, typeDef)) {
            if (typeDef instanceof EnumTypeDefinition) {
                returnType = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)leaf, inGrouping);
                EnumTypeDefinition enumTypeDef = (EnumTypeDefinition)typeDef;
                EnumBuilder enumBuilder = this.resolveInnerEnumFromTypeDefinition(enumTypeDef, leaf.getQName(), typeBuilder, context);
                if (enumBuilder != null) {
                    returnType = enumBuilder.toInstance((Type)typeBuilder);
                }
                this.typeProvider.putReferencedType(leaf.getPath(), returnType);
            } else if (typeDef instanceof UnionTypeDefinition) {
                UnionTypeDefinition unionDef = (UnionTypeDefinition)typeDef;
                returnType = this.addTOToTypeBuilder(unionDef, typeBuilder, (DataSchemaNode)leaf, parentModule);
                context.addInnerTypedefType(typeDef.getPath(), returnType);
            } else if (typeDef instanceof BitsTypeDefinition) {
                GeneratedTOBuilder genTOBuilder = this.addTOToTypeBuilder((BitsTypeDefinition)typeDef, typeBuilder, (DataSchemaNode)leaf, parentModule);
                if (genTOBuilder != null) {
                    returnType = genTOBuilder.build();
                }
            } else {
                restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
                returnType = this.typeProvider.javaTypeForSchemaDefinitionType(AbstractTypeGenerator.getBaseOrDeclaredType(typeDef), (SchemaNode)leaf, restrictions, inGrouping);
                this.addPatternConstant(typeBuilder, leaf.getQName().getLocalName(), restrictions.getPatternConstraints());
            }
        } else {
            restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
            returnType = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)leaf, restrictions, inGrouping);
            this.addPatternConstant(typeBuilder, leaf.getQName().getLocalName(), restrictions.getPatternConstraints());
        }
        if (returnType == null) {
            return null;
        }
        if (typeDef instanceof EnumTypeDefinition) {
            this.typeProvider.putReferencedType(leaf.getPath(), returnType);
        }
        MethodSignatureBuilder getter = this.constructGetter(typeBuilder, returnType, (SchemaNode)leaf);
        this.processContextRefExtension(leaf, getter, parentModule);
        return returnType;
    }

    private static TypeDefinition<?> getBaseOrDeclaredType(TypeDefinition<?> typeDef) {
        TypeDefinition baseType = typeDef.getBaseType();
        return baseType != null && baseType.getBaseType() != null ? baseType : typeDef;
    }

    private void processContextRefExtension(LeafSchemaNode leaf, MethodSignatureBuilder getter, Module module) {
        for (UnknownSchemaNode node : leaf.getUnknownSchemaNodes()) {
            QName nodeType = node.getNodeType();
            if (!"context-reference".equals(nodeType.getLocalName())) continue;
            String nodeParam = node.getNodeParameter();
            IdentitySchemaNode identity = null;
            String basePackageName = null;
            Iterable splittedElement = COLON_SPLITTER.split((CharSequence)nodeParam);
            Iterator iterator = splittedElement.iterator();
            int length = Iterables.size((Iterable)splittedElement);
            if (length == 1) {
                identity = AbstractTypeGenerator.findIdentityByName(module.getIdentities(), (String)iterator.next());
                basePackageName = BindingMapping.getRootPackageName((QNameModule)module.getQNameModule());
            } else if (length == 2) {
                String prefix = (String)iterator.next();
                Module dependentModule = this.findModuleFromImports(module.getImports(), prefix);
                if (dependentModule == null) {
                    throw new IllegalArgumentException("Failed to process context-reference: unknown prefix " + prefix);
                }
                identity = AbstractTypeGenerator.findIdentityByName(dependentModule.getIdentities(), (String)iterator.next());
                basePackageName = BindingMapping.getRootPackageName((QNameModule)dependentModule.getQNameModule());
            } else {
                throw new IllegalArgumentException("Failed to process context-reference: unknown identity " + nodeParam);
            }
            if (identity == null) {
                throw new IllegalArgumentException("Failed to process context-reference: unknown identity " + nodeParam);
            }
            AnnotationTypeBuilder rc = getter.addAnnotation(BindingTypes.ROUTING_CONTEXT);
            String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)identity.getPath());
            String genTypeName = BindingMapping.getClassName((String)identity.getQName().getLocalName());
            rc.addParameter("value", packageName + "." + genTypeName + ".class");
        }
    }

    private static IdentitySchemaNode findIdentityByName(Set<IdentitySchemaNode> identities, String name) {
        for (IdentitySchemaNode id : identities) {
            if (!id.getQName().getLocalName().equals(name)) continue;
            return id;
        }
        return null;
    }

    private Module findModuleFromImports(Set<ModuleImport> imports, String prefix) {
        for (ModuleImport imp : imports) {
            if (!imp.getPrefix().equals(prefix)) continue;
            return this.schemaContext.findModule(imp.getModuleName(), imp.getRevision()).orElse(null);
        }
        return null;
    }

    private boolean resolveLeafSchemaNodeAsProperty(GeneratedTOBuilder toBuilder, LeafSchemaNode leaf, boolean isReadOnly) {
        if (leaf != null && toBuilder != null) {
            Type returnType;
            TypeDefinition typeDef = CompatUtils.compatLeafType((LeafSchemaNode)leaf);
            if (typeDef instanceof UnionTypeDefinition) {
                ModuleContext mc = this.moduleContext(typeDef.getQName().getModule());
                returnType = mc.getTypedefs().get(typeDef.getPath());
                if (returnType == null) {
                    returnType = mc.getInnerType(typeDef.getPath());
                }
            } else if (typeDef instanceof EnumTypeDefinition && typeDef.getBaseType() == null) {
                LeafSchemaNode originalLeaf = (LeafSchemaNode)SchemaNodeUtils.getRootOriginalIfPossible((SchemaNode)leaf);
                QName qname = originalLeaf.getQName();
                returnType = this.moduleContext(qname.getModule()).getInnerType(originalLeaf.getType().getPath());
            } else {
                returnType = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)leaf);
            }
            return this.resolveLeafSchemaNodeAsProperty(toBuilder, leaf, returnType, isReadOnly);
        }
        return false;
    }

    private boolean resolveLeafSchemaNodeAsProperty(GeneratedTOBuilder toBuilder, LeafSchemaNode leaf, Type returnType, boolean isReadOnly) {
        if (returnType == null) {
            return false;
        }
        String leafName = leaf.getQName().getLocalName();
        GeneratedPropertyBuilder propBuilder = toBuilder.addProperty(BindingMapping.getPropertyName((String)leafName));
        propBuilder.setReadOnly(isReadOnly);
        propBuilder.setReturnType(returnType);
        this.addComment((TypeMemberBuilder<?>)propBuilder, (DocumentedNode)leaf);
        toBuilder.addEqualsIdentity(propBuilder);
        toBuilder.addHashIdentity(propBuilder);
        toBuilder.addToStringProperty(propBuilder);
        return true;
    }

    private boolean resolveLeafListSchemaNode(GeneratedTypeBuilder typeBuilder, LeafListSchemaNode node, ModuleContext context, boolean inGrouping) {
        if (node == null || typeBuilder == null || node.isAddedByUses()) {
            return false;
        }
        QName nodeName = node.getQName();
        TypeDefinition typeDef = node.getType();
        Module parentModule = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)node);
        Type returnType = null;
        if (typeDef.getBaseType() == null) {
            if (typeDef instanceof EnumTypeDefinition) {
                returnType = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)node, inGrouping);
                EnumTypeDefinition enumTypeDef = (EnumTypeDefinition)typeDef;
                EnumBuilder enumBuilder = this.resolveInnerEnumFromTypeDefinition(enumTypeDef, nodeName, typeBuilder, context);
                returnType = new ReferencedTypeImpl((JavaTypeName)enumBuilder.getIdentifier());
                this.typeProvider.putReferencedType(node.getPath(), returnType);
            } else if (typeDef instanceof UnionTypeDefinition) {
                UnionTypeDefinition unionDef = (UnionTypeDefinition)typeDef;
                returnType = this.addTOToTypeBuilder(unionDef, typeBuilder, (DataSchemaNode)node, parentModule);
            } else if (typeDef instanceof BitsTypeDefinition) {
                GeneratedTOBuilder genTOBuilder = this.addTOToTypeBuilder((BitsTypeDefinition)typeDef, typeBuilder, (DataSchemaNode)node, parentModule);
                returnType = genTOBuilder.build();
            } else {
                Restrictions restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
                returnType = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)node, restrictions, inGrouping);
                this.addPatternConstant(typeBuilder, node.getQName().getLocalName(), restrictions.getPatternConstraints());
            }
        } else {
            Restrictions restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
            returnType = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)node, restrictions, inGrouping);
            this.addPatternConstant(typeBuilder, node.getQName().getLocalName(), restrictions.getPatternConstraints());
        }
        this.constructGetter(typeBuilder, (Type)Types.listTypeFor((Type)returnType), (SchemaNode)node);
        return true;
    }

    private Type createReturnTypeForUnion(GeneratedTOBuilder genTOBuilder, UnionTypeDefinition typeDef, GeneratedTypeBuilder typeBuilder, Module parentModule) {
        GeneratedTOBuilder returnTypeBuilder = this.typeProvider.newGeneratedTOBuilder((JavaTypeName)genTOBuilder.getIdentifier());
        returnTypeBuilder.setIsUnion(true);
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)returnTypeBuilder, parentModule, (SchemaNode)typeDef);
        returnTypeBuilder.setSchemaPath(typeDef.getPath());
        returnTypeBuilder.setModuleName(parentModule.getName());
        GeneratedTransferObject returnType = returnTypeBuilder.build();
        genTOBuilder.setTypedef(true);
        genTOBuilder.setIsUnion(true);
        AbstractTypeProvider.addUnitsToGenTO(genTOBuilder, typeDef.getUnits().orElse(null));
        this.createUnionBuilder(genTOBuilder, typeBuilder, returnType, parentModule);
        return returnType;
    }

    private void createUnionBuilder(GeneratedTOBuilder genTOBuilder, GeneratedTypeBuilder typeBuilder, GeneratedTransferObject returnType, Module parentModule) {
        StringBuilder sb = new StringBuilder();
        ((JavaTypeName)genTOBuilder.getIdentifier()).localNameComponents().forEach(sb::append);
        GeneratedTOBuilder unionBuilder = this.typeProvider.newGeneratedTOBuilder(JavaTypeName.create((String)typeBuilder.getPackageName(), (String)sb.append("Builder").toString()));
        unionBuilder.setIsUnionBuilder(true);
        MethodSignatureBuilder method = unionBuilder.addMethod("getDefaultInstance");
        method.setReturnType((Type)returnType);
        method.addParameter((Type)Types.STRING, "defaultValue");
        method.setAccessModifier(AccessModifier.PUBLIC);
        method.setStatic(true);
        GeneratedTransferObject unionBuilderType = unionBuilder.build();
        this.typeProvider.getAdditionalTypes().computeIfAbsent(parentModule, key -> new HashSet()).add(unionBuilderType);
    }

    private GeneratedTypeBuilder addDefaultInterfaceDefinition(ModuleContext context, SchemaNode schemaNode) {
        return this.addDefaultInterfaceDefinition(context, schemaNode, (Type)BindingTypes.DATA_OBJECT);
    }

    private GeneratedTypeBuilder addDefaultInterfaceDefinition(ModuleContext context, SchemaNode schemaNode, Type baseInterface) {
        String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)context.modulePackageName(), (SchemaPath)schemaNode.getPath());
        return this.addDefaultInterfaceDefinition(packageName, schemaNode, baseInterface, context);
    }

    private GeneratedTypeBuilder addDefaultInterfaceDefinition(String packageName, SchemaNode schemaNode, Type baseInterface, ModuleContext context) {
        JavaTypeName name = this.renames.get(schemaNode);
        if (name == null) {
            name = JavaTypeName.create((String)packageName, (String)BindingMapping.getClassName((QName)schemaNode.getQName()));
        }
        GeneratedTypeBuilder it = this.addRawInterfaceDefinition(name, schemaNode);
        it.addImplementsType(baseInterface);
        if (!(schemaNode instanceof GroupingDefinition)) {
            it.addImplementsType((Type)BindingTypes.augmentable((Type)it));
        }
        if (schemaNode instanceof DataNodeContainer) {
            DataNodeContainer containerSchema = (DataNodeContainer)schemaNode;
            this.groupingsToGenTypes(context, containerSchema.getGroupings());
            this.addImplementedInterfaceFromUses(containerSchema, it);
        }
        return it;
    }

    private GeneratedTypeBuilder addRawInterfaceDefinition(JavaTypeName identifier, SchemaNode schemaNode) {
        Preconditions.checkArgument((schemaNode != null ? 1 : 0) != 0, (Object)"Data Schema Node cannot be NULL.");
        Preconditions.checkArgument((schemaNode.getQName() != null ? 1 : 0) != 0, (Object)"QName for Data Schema Node cannot be NULL.");
        String schemaNodeName = schemaNode.getQName().getLocalName();
        Preconditions.checkArgument((schemaNodeName != null ? 1 : 0) != 0, (Object)"Local Name of QName for Data Schema Node cannot be NULL.");
        GeneratedTypeBuilder newType = this.typeProvider.newGeneratedTypeBuilder(identifier);
        Module module = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)schemaNode);
        AbstractTypeGenerator.qnameConstant(newType, JavaTypeName.create((String)BindingMapping.getRootPackageName((QNameModule)module.getQNameModule()), (String)"$YangModuleInfoImpl"), schemaNode.getQName().getLocalName());
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)newType, module, schemaNode);
        newType.setSchemaPath(schemaNode.getPath());
        newType.setModuleName(module.getName());
        String packageName = identifier.packageName();
        String simpleName = identifier.simpleName();
        if (!this.genTypeBuilders.containsKey(packageName)) {
            HashMap<String, GeneratedTypeBuilder> builders = new HashMap<String, GeneratedTypeBuilder>();
            builders.put(simpleName, newType);
            this.genTypeBuilders.put(packageName, builders);
        } else {
            Map<String, GeneratedTypeBuilder> builders = this.genTypeBuilders.get(packageName);
            if (!builders.containsKey(simpleName)) {
                builders.put(simpleName, newType);
            }
        }
        return newType;
    }

    public static String getterMethodName(String localName, Type returnType) {
        return BindingMapping.getGetterMethodName((String)localName, (boolean)Types.BOOLEAN.equals(returnType));
    }

    private MethodSignatureBuilder constructGetter(GeneratedTypeBuilder interfaceBuilder, Type returnType, SchemaNode node) {
        MethodSignatureBuilder getMethod = interfaceBuilder.addMethod(AbstractTypeGenerator.getterMethodName(node.getQName().getLocalName(), returnType));
        getMethod.setReturnType(returnType);
        AbstractTypeGenerator.annotateDeprecatedIfNecessary(node.getStatus(), (AnnotableTypeBuilder)getMethod);
        this.addComment((TypeMemberBuilder<?>)getMethod, (DocumentedNode)node);
        return getMethod;
    }

    private static void constructNonnull(GeneratedTypeBuilder interfaceBuilder, Type returnType, ListSchemaNode node) {
        MethodSignatureBuilder getMethod = interfaceBuilder.addMethod(BindingMapping.getNonnullMethodName((String)node.getQName().getLocalName()));
        ((MethodSignatureBuilder)getMethod.setReturnType(returnType)).setDefault(true);
        AbstractTypeGenerator.annotateDeprecatedIfNecessary(node.getStatus(), (AnnotableTypeBuilder)getMethod);
    }

    private void addSchemaNodeToListBuilders(ModuleContext context, DataSchemaNode schemaNode, GeneratedTypeBuilder typeBuilder, GeneratedTOBuilder genTOBuilder, List<String> listKeys, boolean inGrouping) {
        Preconditions.checkArgument((schemaNode != null ? 1 : 0) != 0, (Object)"Data Schema Node cannot be NULL.");
        Preconditions.checkArgument((typeBuilder != null ? 1 : 0) != 0, (Object)"Generated Type Builder cannot be NULL.");
        if (schemaNode instanceof LeafSchemaNode) {
            LeafSchemaNode leaf = (LeafSchemaNode)schemaNode;
            String leafName = leaf.getQName().getLocalName();
            Type type = this.resolveLeafSchemaNodeAsMethod(typeBuilder, leaf, context, inGrouping);
            if (listKeys.contains(leafName)) {
                if (type == null) {
                    this.resolveLeafSchemaNodeAsProperty(genTOBuilder, leaf, true);
                } else {
                    this.resolveLeafSchemaNodeAsProperty(genTOBuilder, leaf, type, true);
                }
            }
        } else if (!schemaNode.isAddedByUses()) {
            if (schemaNode instanceof LeafListSchemaNode) {
                this.resolveLeafListSchemaNode(typeBuilder, (LeafListSchemaNode)schemaNode, context, inGrouping);
            } else if (schemaNode instanceof ContainerSchemaNode) {
                this.containerToGenType(context, typeBuilder, (Type)BindingTypes.childOf((Type)typeBuilder), (ContainerSchemaNode)schemaNode, inGrouping);
            } else if (schemaNode instanceof ChoiceSchemaNode) {
                this.choiceToGeneratedType(context, typeBuilder, (ChoiceSchemaNode)schemaNode, inGrouping);
            } else if (schemaNode instanceof ListSchemaNode) {
                this.listToGenType(context, typeBuilder, (Type)BindingTypes.childOf((Type)typeBuilder), (ListSchemaNode)schemaNode, inGrouping);
            }
        }
    }

    private static void typeBuildersToGenTypes(ModuleContext context, GeneratedTypeBuilder typeBuilder, GeneratedTOBuilder genTOBuilder) {
        Preconditions.checkArgument((typeBuilder != null ? 1 : 0) != 0, (Object)"Generated Type Builder cannot be NULL.");
        if (genTOBuilder != null) {
            GeneratedTransferObject genTO = genTOBuilder.build();
            ((MethodSignatureBuilder)typeBuilder.addMethod("key").setReturnType((Type)genTO)).addAnnotation(OVERRIDE_ANNOTATION);
            context.addGeneratedTOBuilder(genTOBuilder);
        }
    }

    private static List<String> listKeys(ListSchemaNode list) {
        ArrayList<String> listKeys = new ArrayList<String>();
        List keyDefinition = list.getKeyDefinition();
        if (keyDefinition != null) {
            for (QName keyDef : keyDefinition) {
                listKeys.add(keyDef.getLocalName());
            }
        }
        return listKeys;
    }

    private GeneratedTOBuilder resolveListKeyTOBuilder(ModuleContext context, ListSchemaNode list) {
        if (list.getKeyDefinition() != null && !list.getKeyDefinition().isEmpty()) {
            return this.typeProvider.newGeneratedTOBuilder(JavaTypeName.create((String)BindingGeneratorUtil.packageNameForGeneratedType((String)context.modulePackageName(), (SchemaPath)list.getPath()), (String)BindingMapping.getClassName((String)(list.getQName().getLocalName() + "Key"))));
        }
        return null;
    }

    private Type addTOToTypeBuilder(UnionTypeDefinition typeDef, GeneratedTypeBuilder typeBuilder, DataSchemaNode leaf, Module parentModule) {
        List<GeneratedTOBuilder> types = this.typeProvider.provideGeneratedTOBuildersForUnionTypeDef(((JavaTypeName)typeBuilder.getIdentifier()).createEnclosed(BindingMapping.getClassName((QName)leaf.getQName())), typeDef, (SchemaNode)leaf);
        Preconditions.checkState((!types.isEmpty() ? 1 : 0) != 0, (String)"No GeneratedTOBuilder objects generated from union %s", (Object)typeDef);
        ArrayList<GeneratedTOBuilder> genTOBuilders = new ArrayList<GeneratedTOBuilder>(types);
        GeneratedTOBuilder resultTOBuilder = types.remove(0);
        types.forEach(arg_0 -> ((GeneratedTOBuilder)resultTOBuilder).addEnclosingTransferObject(arg_0));
        genTOBuilders.forEach(arg_0 -> ((GeneratedTypeBuilder)typeBuilder).addEnclosingTransferObject(arg_0));
        for (GeneratedTOBuilder builder : types) {
            if (!builder.isUnion()) continue;
            GeneratedTransferObject type = builder.build();
            this.createUnionBuilder(builder, typeBuilder, type, parentModule);
        }
        return this.createReturnTypeForUnion(resultTOBuilder, typeDef, typeBuilder, parentModule);
    }

    private GeneratedTOBuilder addTOToTypeBuilder(BitsTypeDefinition typeDef, GeneratedTypeBuilder typeBuilder, DataSchemaNode leaf, Module parentModule) {
        GeneratedTOBuilder genTOBuilder = this.typeProvider.provideGeneratedTOBuilderForBitsTypeDefinition(((JavaTypeName)typeBuilder.getIdentifier()).createEnclosed(BindingMapping.getClassName((QName)leaf.getQName())), typeDef, parentModule.getName());
        typeBuilder.addEnclosingTransferObject(genTOBuilder);
        return genTOBuilder;
    }

    private GeneratedTypeBuilder addImplementedInterfaceFromUses(DataNodeContainer dataNodeContainer, GeneratedTypeBuilder builder) {
        for (UsesNode usesNode : dataNodeContainer.getUses()) {
            GeneratedType genType = this.findGroupingByPath(usesNode.getGroupingPath()).build();
            if (genType == null) {
                throw new IllegalStateException("Grouping " + usesNode.getGroupingPath() + "is not resolved for " + builder.getName());
            }
            builder.addImplementsType((Type)genType);
        }
        return builder;
    }

    private GeneratedTypeBuilder findChildNodeByPath(SchemaPath path) {
        for (ModuleContext ctx : this.genCtx.values()) {
            GeneratedTypeBuilder result = ctx.getChildNode(path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private GeneratedTypeBuilder findGroupingByPath(SchemaPath path) {
        for (ModuleContext ctx : this.genCtx.values()) {
            GeneratedTypeBuilder result = ctx.getGrouping(path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private GeneratedTypeBuilder findCaseByPath(SchemaPath path) {
        for (ModuleContext ctx : this.genCtx.values()) {
            GeneratedTypeBuilder result = ctx.getCase(path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static void annotateDeprecatedIfNecessary(Status status, AnnotableTypeBuilder builder) {
        if (status == Status.DEPRECATED) {
            builder.addAnnotation(DEPRECATED_ANNOTATION);
        }
    }
}

