/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl;

import com.google.common.base.Preconditions;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.mdsal.binding.generator.api.BindingGenerator;
import org.opendaylight.mdsal.binding.generator.api.BindingRuntimeGenerator;
import org.opendaylight.mdsal.binding.generator.api.BindingRuntimeTypes;
import org.opendaylight.mdsal.binding.generator.impl.CodegenTypeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.RenameMappingException;
import org.opendaylight.mdsal.binding.generator.impl.RuntimeTypeGenerator;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingGeneratorImpl
implements BindingGenerator,
BindingRuntimeGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(BindingGeneratorImpl.class);

    public List<Type> generateTypes(SchemaContext context, Set<Module> modules) {
        BindingGeneratorImpl.checkContext(context);
        Preconditions.checkArgument((modules != null ? 1 : 0) != 0, (Object)"Set of Modules cannot be NULL.");
        IdentityHashMap<SchemaNode, JavaTypeName> renames = new IdentityHashMap<SchemaNode, JavaTypeName>();
        while (true) {
            try {
                return new CodegenTypeGenerator(context, renames).toTypes(modules);
            }
            catch (RenameMappingException e) {
                BindingGeneratorImpl.rename(renames, e);
                continue;
            }
            break;
        }
    }

    public BindingRuntimeTypes generateTypeMapping(SchemaContext context) {
        BindingGeneratorImpl.checkContext(context);
        IdentityHashMap<SchemaNode, JavaTypeName> renames = new IdentityHashMap<SchemaNode, JavaTypeName>();
        while (true) {
            try {
                return new RuntimeTypeGenerator(context, renames).toTypeMapping();
            }
            catch (RenameMappingException e) {
                BindingGeneratorImpl.rename(renames, e);
                continue;
            }
            break;
        }
    }

    private static void checkContext(SchemaContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Schema Context reference cannot be NULL.");
        Preconditions.checkState((context.getModules() != null ? 1 : 0) != 0, (Object)"Schema Context does not contain defined modules.");
    }

    private static void rename(Map<SchemaNode, JavaTypeName> renames, RenameMappingException ex) {
        String suffix;
        JavaTypeName name = ex.getName();
        SchemaNode def = ex.getDefinition();
        JavaTypeName existing = renames.get(def);
        if (existing != null) {
            throw new IllegalStateException("Attempted to relocate " + def + " to " + name + ", already remapped to " + existing, ex);
        }
        if (def instanceof IdentitySchemaNode) {
            suffix = "$I";
        } else if (def instanceof GroupingDefinition) {
            suffix = "$G";
        } else if (def instanceof TypeDefinition) {
            suffix = "$T";
        } else {
            throw new IllegalStateException("Unhandled remapping of " + def + " at " + name, ex);
        }
        JavaTypeName newName = name.createSibling(name.simpleName() + suffix);
        renames.put(def, newName);
        LOG.debug("Restarting code generation after remapping {} to {}", (Object)name, (Object)newName);
    }
}

