/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl;

import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.yangtools.util.ClassLoaderUtils;

public abstract class GeneratedClassLoadingStrategy
implements ClassLoadingStrategy {
    private static final GeneratedClassLoadingStrategy TCCL_STRATEGY = new TCCLClassLoadingStrategy();
    private static final GeneratedClassLoadingStrategy ALWAYS_FAIL_STRATEGY = new GeneratedClassLoadingStrategy(){

        @Override
        public Class<?> loadClass(String fullyQualifiedName) throws ClassNotFoundException {
            throw new ClassNotFoundException(fullyQualifiedName);
        }
    };

    public Class<?> loadClass(Type type) throws ClassNotFoundException {
        return this.loadClass(type.getFullyQualifiedName());
    }

    public abstract Class<?> loadClass(String var1) throws ClassNotFoundException;

    public static final GeneratedClassLoadingStrategy getTCCLClassLoadingStrategy() {
        return TCCL_STRATEGY;
    }

    public static final GeneratedClassLoadingStrategy getAlwaysFailClassLoadingStrategy() {
        return ALWAYS_FAIL_STRATEGY;
    }

    private static final class TCCLClassLoadingStrategy
    extends GeneratedClassLoadingStrategy {
        private TCCLClassLoadingStrategy() {
        }

        @Override
        public Class<?> loadClass(String fullyQualifiedName) throws ClassNotFoundException {
            return ClassLoaderUtils.loadClassWithTCCL((String)fullyQualifiedName);
        }
    }
}

