/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.opendaylight.mdsal.binding.generator.api.BindingRuntimeTypes;
import org.opendaylight.mdsal.binding.generator.impl.AbstractTypeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.ModuleContext;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.api.type.builder.TypeMemberBuilder;
import org.opendaylight.mdsal.binding.yang.types.RuntimeTypeProvider;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

final class RuntimeTypeGenerator
extends AbstractTypeGenerator {
    RuntimeTypeGenerator(SchemaContext context, Map<SchemaNode, JavaTypeName> renames) {
        super(context, new RuntimeTypeProvider(context, renames), renames);
    }

    BindingRuntimeTypes toTypeMapping() {
        HashMap augmentationToSchema = new HashMap();
        HashBiMap typeToDefiningSchema = HashBiMap.create();
        HashMultimap choiceToCases = HashMultimap.create();
        HashMap identities = new HashMap();
        IdentityHashMap<Type, Type> builderToType = new IdentityHashMap<Type, Type>();
        for (ModuleContext ctx : this.moduleContexts()) {
            for (Map.Entry entry : ctx.getTypeToAugmentation().entrySet()) {
                augmentationToSchema.put(RuntimeTypeGenerator.builtType(builderToType, (Type)entry.getKey()), entry.getValue());
            }
            for (Map.Entry entry : ctx.getTypeToSchema().entrySet()) {
                typeToDefiningSchema.put((Object)RuntimeTypeGenerator.builtType(builderToType, (Type)entry.getKey()), entry.getValue());
            }
            for (Map.Entry entry : ctx.getChoiceToCases().entries()) {
                choiceToCases.put((Object)RuntimeTypeGenerator.builtType(builderToType, (Type)entry.getKey()), (Object)RuntimeTypeGenerator.builtType(builderToType, (Type)entry.getValue()));
            }
            for (Map.Entry entry : ctx.getIdentities().entrySet()) {
                identities.put(entry.getKey(), RuntimeTypeGenerator.builtType(builderToType, (Type)entry.getValue()));
            }
        }
        return new BindingRuntimeTypes(augmentationToSchema, (BiMap)typeToDefiningSchema, (Multimap)choiceToCases, identities);
    }

    private static Type builtType(Map<Type, Type> knownTypes, Type type) {
        if (type instanceof Builder) {
            Type existing = knownTypes.get(type);
            if (existing != null) {
                return existing;
            }
            Type built = (Type)((Builder)type).build();
            knownTypes.put(type, built);
            return built;
        }
        return type;
    }

    @Override
    void addCodegenInformation(GeneratedTypeBuilderBase<?> genType, Module module) {
    }

    @Override
    void addCodegenInformation(GeneratedTypeBuilderBase<?> genType, Module module, SchemaNode node) {
    }

    @Override
    void addCodegenInformation(GeneratedTypeBuilder interfaceBuilder, Module module, String string, Set<? extends SchemaNode> nodes) {
    }

    @Override
    void addComment(TypeMemberBuilder<?> genType, DocumentedNode node) {
    }
}

