/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.api.BindingRuntimeTypes;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.BindingGeneratorImpl;
import org.opendaylight.mdsal.binding.generator.impl.BindingSchemaContextUtils;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.util.ReferencedTypeImpl;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.EffectiveAugmentationSchema;
import org.opendaylight.yangtools.yang.model.util.SchemaNodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BindingRuntimeContext
implements Immutable {
    private static final Logger LOG = LoggerFactory.getLogger(BindingRuntimeContext.class);
    private static final char DOT = '.';
    private final BindingRuntimeTypes runtimeTypes;
    private final ClassLoadingStrategy strategy;
    private final SchemaContext schemaContext;
    private final LoadingCache<QName, Class<?>> identityClasses = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<QName, Class<?>>(){

        public Class<?> load(QName key) {
            Optional identityType = BindingRuntimeContext.this.runtimeTypes.findIdentity(key);
            Preconditions.checkArgument((boolean)identityType.isPresent(), (String)"Supplied QName %s is not a valid identity", (Object)key);
            try {
                return BindingRuntimeContext.this.strategy.loadClass((Type)identityType.get());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Required class " + identityType + "was not found.", e);
            }
        }
    });

    private BindingRuntimeContext(ClassLoadingStrategy strategy, SchemaContext schema) {
        this.strategy = strategy;
        this.schemaContext = schema;
        this.runtimeTypes = new BindingGeneratorImpl().generateTypeMapping(schema);
    }

    public static BindingRuntimeContext create(ClassLoadingStrategy strategy, SchemaContext ctx) {
        return new BindingRuntimeContext(strategy, ctx);
    }

    public ClassLoadingStrategy getStrategy() {
        return this.strategy;
    }

    public SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public @Nullable AugmentationSchemaNode getAugmentationDefinition(Class<?> augClass) {
        Preconditions.checkArgument((boolean)Augmentation.class.isAssignableFrom(augClass), (String)"Class %s does not represent augmentation", augClass);
        return this.runtimeTypes.findAugmentation(BindingRuntimeContext.referencedType(augClass)).orElse(null);
    }

    public DataSchemaNode getSchemaDefinition(Class<?> cls) {
        Preconditions.checkArgument((!Augmentation.class.isAssignableFrom(cls) ? 1 : 0) != 0, (String)"Supplied class must not be an augmentation (%s is)", cls);
        Preconditions.checkArgument((!Action.class.isAssignableFrom(cls) ? 1 : 0) != 0, (String)"Supplied class must not be an action (%s is)", cls);
        return this.runtimeTypes.findSchema(BindingRuntimeContext.referencedType(cls)).orElse(null);
    }

    public ActionDefinition getActionDefinition(Class<? extends Action<?, ?, ?>> cls) {
        return this.runtimeTypes.findSchema(BindingRuntimeContext.referencedType(cls)).orElse(null);
    }

    public Map.Entry<YangInstanceIdentifier.AugmentationIdentifier, AugmentationSchemaNode> getResolvedAugmentationSchema(DataNodeContainer target, Class<? extends Augmentation<?>> aug) {
        AugmentationSchemaNode origSchema = this.getAugmentationDefinition(aug);
        Preconditions.checkArgument((origSchema != null ? 1 : 0) != 0, (String)"Augmentation %s is not known in current schema context", aug);
        HashSet<QName> childNames = new HashSet<QName>();
        HashSet<DataSchemaNode> realChilds = new HashSet<DataSchemaNode>();
        for (DataSchemaNode child : origSchema.getChildNodes()) {
            DataSchemaNode dataChildQNname = target.getDataChildByName(child.getQName());
            String childLocalName = child.getQName().getLocalName();
            if (dataChildQNname == null) {
                for (DataSchemaNode dataSchemaNode : target.getChildNodes()) {
                    if (!childLocalName.equals(dataSchemaNode.getQName().getLocalName())) continue;
                    realChilds.add(dataSchemaNode);
                    childNames.add(dataSchemaNode.getQName());
                }
                continue;
            }
            realChilds.add(dataChildQNname);
            childNames.add(child.getQName());
        }
        YangInstanceIdentifier.AugmentationIdentifier identifier = new YangInstanceIdentifier.AugmentationIdentifier(childNames);
        EffectiveAugmentationSchema proxy = new EffectiveAugmentationSchema(origSchema, realChilds);
        return new AbstractMap.SimpleEntry<YangInstanceIdentifier.AugmentationIdentifier, EffectiveAugmentationSchema>(identifier, proxy);
    }

    public Optional<CaseSchemaNode> getCaseSchemaDefinition(ChoiceSchemaNode schema, Class<?> childClass) {
        DataSchemaNode origSchema = this.getSchemaDefinition(childClass);
        Preconditions.checkArgument((boolean)(origSchema instanceof CaseSchemaNode), (String)"Supplied schema %s is not case.", (Object)origSchema);
        Optional<CaseSchemaNode> found = BindingSchemaContextUtils.findInstantiatedCase(schema, (CaseSchemaNode)origSchema);
        return found;
    }

    public Map.Entry<GeneratedType, DocumentedNode.WithStatus> getTypeWithSchema(Class<?> type) {
        return this.getTypeWithSchema(BindingRuntimeContext.referencedType(type));
    }

    private Map.Entry<GeneratedType, DocumentedNode.WithStatus> getTypeWithSchema(Type referencedType) {
        DocumentedNode.WithStatus schema = (DocumentedNode.WithStatus)this.runtimeTypes.findSchema(referencedType).orElseThrow(() -> new NullPointerException("Failed to find schema for type " + referencedType));
        Type definedType = (Type)this.runtimeTypes.findType(schema).orElseThrow(() -> new NullPointerException("Failed to find defined type for " + referencedType + " schema " + schema));
        if (definedType instanceof GeneratedTypeBuilder) {
            return new AbstractMap.SimpleEntry<GeneratedType, DocumentedNode.WithStatus>(((GeneratedTypeBuilder)definedType).build(), schema);
        }
        Preconditions.checkArgument((boolean)(definedType instanceof GeneratedType), (String)"Type %s is not a GeneratedType", (Object)referencedType);
        return new AbstractMap.SimpleEntry<GeneratedType, DocumentedNode.WithStatus>((GeneratedType)definedType, schema);
    }

    public ImmutableMap<Type, Map.Entry<Type, Type>> getChoiceCaseChildren(DataNodeContainer schema) {
        HashMap<Type, AbstractMap.SimpleEntry<Type, Type>> childToCase = new HashMap<Type, AbstractMap.SimpleEntry<Type, Type>>();
        for (ChoiceSchemaNode choice : Iterables.filter((Iterable)schema.getChildNodes(), ChoiceSchemaNode.class)) {
            ChoiceSchemaNode originalChoice = BindingRuntimeContext.getOriginalSchema(choice);
            Optional optType = this.runtimeTypes.findType((DocumentedNode.WithStatus)originalChoice);
            Preconditions.checkState((boolean)optType.isPresent(), (String)"Failed to find generated type for choice %s", (Object)originalChoice);
            Type choiceType = (Type)optType.get();
            for (Type caze : this.runtimeTypes.findCases(BindingRuntimeContext.referencedType(choiceType))) {
                AbstractMap.SimpleEntry<Type, Type> caseIdentifier = new AbstractMap.SimpleEntry<Type, Type>(choiceType, caze);
                HashSet<Type> caseChildren = new HashSet<Type>();
                if (caze instanceof GeneratedTypeBuilder) {
                    caze = ((GeneratedTypeBuilder)caze).build();
                }
                BindingRuntimeContext.collectAllContainerTypes((GeneratedType)caze, caseChildren);
                for (Type caseChild : caseChildren) {
                    childToCase.put(caseChild, caseIdentifier);
                }
            }
        }
        return ImmutableMap.copyOf(childToCase);
    }

    public BiMap<String, String> getEnumMapping(Class<?> enumClass) {
        Map.Entry<GeneratedType, DocumentedNode.WithStatus> typeWithSchema = this.getTypeWithSchema(enumClass);
        return BindingRuntimeContext.getEnumMapping(typeWithSchema);
    }

    public BiMap<String, String> getEnumMapping(String enumClassName) {
        return BindingRuntimeContext.getEnumMapping(this.findTypeWithSchema(enumClassName));
    }

    private static BiMap<String, String> getEnumMapping(Map.Entry<GeneratedType, DocumentedNode.WithStatus> typeWithSchema) {
        TypeDefinition typeDef = (TypeDefinition)typeWithSchema.getValue();
        Preconditions.checkArgument((boolean)(typeDef instanceof EnumTypeDefinition));
        EnumTypeDefinition enumType = (EnumTypeDefinition)typeDef;
        HashBiMap mappedEnums = HashBiMap.create();
        for (EnumTypeDefinition.EnumPair enumPair : enumType.getValues()) {
            mappedEnums.put((Object)enumPair.getName(), (Object)BindingMapping.getClassName((String)enumPair.getName()));
        }
        return mappedEnums;
    }

    private Map.Entry<GeneratedType, DocumentedNode.WithStatus> findTypeWithSchema(String className) {
        ArrayList<String> components = new ArrayList<String>();
        String packageName = className;
        int lastDot = packageName.lastIndexOf(46);
        while (lastDot != -1) {
            DocumentedNode.WithStatus schema;
            Optional optDefinedType;
            components.add(packageName.substring(lastDot + 1));
            packageName = packageName.substring(0, lastDot);
            Iterator it = components.iterator();
            JavaTypeName name = JavaTypeName.create((String)packageName, (String)((String)it.next()));
            while (it.hasNext()) {
                name = name.createEnclosed((String)it.next());
            }
            ReferencedTypeImpl type = new ReferencedTypeImpl(name);
            Optional optSchema = this.runtimeTypes.findSchema((Type)type);
            if (optSchema.isPresent() && (optDefinedType = this.runtimeTypes.findType(schema = (DocumentedNode.WithStatus)optSchema.get())).isPresent()) {
                Type definedType = (Type)optDefinedType.get();
                if (definedType instanceof GeneratedTypeBuilder) {
                    return new AbstractMap.SimpleEntry<GeneratedType, DocumentedNode.WithStatus>(((GeneratedTypeBuilder)definedType).build(), schema);
                }
                Preconditions.checkArgument((boolean)(definedType instanceof GeneratedType), (String)"Type %s is not a GeneratedType", (Object)className);
                return new AbstractMap.SimpleEntry<GeneratedType, DocumentedNode.WithStatus>((GeneratedType)definedType, schema);
            }
            lastDot = packageName.lastIndexOf(46);
        }
        throw new IllegalArgumentException("Failed to find type for " + className);
    }

    public Set<Class<?>> getCases(Class<?> choice) {
        Collection cazes = this.runtimeTypes.findCases(BindingRuntimeContext.referencedType(choice));
        HashSet ret = new HashSet(cazes.size());
        for (Type caze : cazes) {
            try {
                Class c = this.strategy.loadClass(caze);
                ret.add(c);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Failed to load class for case {}, ignoring it", (Object)caze, (Object)e);
            }
        }
        return ret;
    }

    public Class<?> getClassForSchema(SchemaNode childSchema) {
        SchemaNode origSchema = BindingRuntimeContext.getOriginalSchema(childSchema);
        Optional clazzType = this.runtimeTypes.findType((DocumentedNode.WithStatus)origSchema);
        Preconditions.checkArgument((boolean)clazzType.isPresent(), (String)"Failed to find binding type for %s (original %s)", (Object)childSchema, (Object)origSchema);
        try {
            return this.strategy.loadClass((Type)clazzType.get());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public ImmutableMap<YangInstanceIdentifier.AugmentationIdentifier, Type> getAvailableAugmentationTypes(DataNodeContainer container) {
        HashMap identifierToType = new HashMap();
        if (container instanceof AugmentationTarget) {
            Set augments = ((AugmentationTarget)container).getAvailableAugmentations();
            Iterator iterator = augments.iterator();
            while (iterator.hasNext()) {
                Optional augType;
                AugmentationSchemaNode augment;
                AugmentationSchemaNode augOrig = augment = (AugmentationSchemaNode)iterator.next();
                while (augOrig.getOriginalDefinition().isPresent()) {
                    augOrig = (AugmentationSchemaNode)augOrig.getOriginalDefinition().get();
                }
                if (augment.getChildNodes().isEmpty() || !(augType = this.runtimeTypes.findType((DocumentedNode.WithStatus)augOrig)).isPresent()) continue;
                identifierToType.put(BindingRuntimeContext.getAugmentationIdentifier(augment), augType.get());
            }
        }
        return ImmutableMap.copyOf(identifierToType);
    }

    private static YangInstanceIdentifier.AugmentationIdentifier getAugmentationIdentifier(AugmentationSchemaNode augment) {
        HashSet<QName> childNames = new HashSet<QName>();
        for (DataSchemaNode child : augment.getChildNodes()) {
            childNames.add(child.getQName());
        }
        return new YangInstanceIdentifier.AugmentationIdentifier(childNames);
    }

    private static Type referencedType(Class<?> type) {
        return new ReferencedTypeImpl(JavaTypeName.create(type));
    }

    private static Type referencedType(Type type) {
        if (type instanceof ReferencedTypeImpl) {
            return type;
        }
        return new ReferencedTypeImpl((JavaTypeName)type.getIdentifier());
    }

    private static Set<Type> collectAllContainerTypes(GeneratedType type, Set<Type> collection) {
        for (MethodSignature definition : type.getMethodDefinitions()) {
            Type childType = definition.getReturnType();
            if (childType instanceof ParameterizedType) {
                childType = ((ParameterizedType)childType).getActualTypeArguments()[0];
            }
            if (!(childType instanceof GeneratedType) && !(childType instanceof GeneratedTypeBuilder)) continue;
            collection.add(BindingRuntimeContext.referencedType(childType));
        }
        for (Type parent : type.getImplements()) {
            if (!(parent instanceof GeneratedType)) continue;
            BindingRuntimeContext.collectAllContainerTypes((GeneratedType)parent, collection);
        }
        return collection;
    }

    private static <T extends SchemaNode> T getOriginalSchema(T choice) {
        SchemaNode original = SchemaNodeUtils.getRootOriginalIfPossible(choice);
        if (original != null) {
            return (T)original;
        }
        return choice;
    }

    public Class<?> getIdentityClass(QName input) {
        return (Class)this.identityClasses.getUnchecked((Object)input);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ClassLoadingStrategy", (Object)this.strategy).add("runtimeTypes", (Object)this.runtimeTypes).add("schemaContext", (Object)this.schemaContext).toString();
    }
}

