/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.util;

import com.google.common.annotations.Beta;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javax.annotation.concurrent.GuardedBy;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.binding.generator.util.ClassCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public final class JavassistUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JavassistUtils.class);
    private static final Map<ClassPool, JavassistUtils> INSTANCES = new WeakHashMap<ClassPool, JavassistUtils>();
    @GuardedBy(value="this")
    private final Map<ClassLoader, ClassPath> loaderClassPaths = new WeakHashMap<ClassLoader, ClassPath>();
    @GuardedBy(value="this")
    private final ClassPool classPool;

    private JavassistUtils(ClassPool pool) {
        this.classPool = Objects.requireNonNull(pool);
    }

    public static synchronized JavassistUtils forClassPool(ClassPool pool) {
        return INSTANCES.computeIfAbsent(Objects.requireNonNull(pool), JavassistUtils::new);
    }

    @Beta
    public synchronized CtClass instantiatePrototype(String prototype, String fqn, ClassCustomizer customizer) throws CannotCompileException, NotFoundException {
        CtClass result = this.classPool.getAndRename(prototype, fqn);
        try {
            customizer.customizeClass(result);
        }
        catch (CannotCompileException | NotFoundException e) {
            result.detach();
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Failed to customize {} from prototype {}", new Object[]{fqn, prototype, e});
            result.detach();
            throw new IllegalStateException(String.format("Failed to instantiate prototype %s as %s", prototype, fqn), e);
        }
        result.stopPruning(false);
        return result;
    }

    @GuardedBy(value="this")
    public CtClass asCtClass(Class<?> cls) {
        try {
            return this.classPool.get(cls.getName());
        }
        catch (NotFoundException nfe1) {
            this.appendClassLoaderIfMissing(cls.getClassLoader());
            try {
                return this.classPool.get(cls.getName());
            }
            catch (NotFoundException nfe2) {
                LOG.warn("Appending ClassClassPath for {}", cls, (Object)nfe2);
                this.classPool.appendClassPath((ClassPath)new ClassClassPath(cls));
                try {
                    return this.classPool.get(cls.getName());
                }
                catch (NotFoundException e) {
                    LOG.warn("Failed to load class {} from pool {}", new Object[]{cls, this.classPool, e});
                    throw new IllegalStateException("Failed to load class", e);
                }
            }
        }
    }

    public synchronized void appendClassLoaderIfMissing(ClassLoader loader) {
        if (!this.loaderClassPaths.containsKey(loader)) {
            LoaderClassPath ctLoader = new LoaderClassPath(loader);
            this.classPool.appendClassPath((ClassPath)ctLoader);
            this.loaderClassPaths.put(loader, (ClassPath)ctLoader);
        }
    }
}

