/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.util;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.NamespaceRevisionAware;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

public final class YangSchemaUtils {
    public static final String AUGMENT_IDENTIFIER = "augment-identifier";

    private YangSchemaUtils() {
        throw new UnsupportedOperationException("Helper class. Instantiation is prohibited");
    }

    public static QName getAugmentationQName(AugmentationSchemaNode augmentation) {
        Objects.requireNonNull(augmentation, "Augmentation must not be null.");
        QName identifier = YangSchemaUtils.getAugmentationIdentifier(augmentation);
        if (identifier != null) {
            return identifier;
        }
        URI namespace = null;
        Optional revision = null;
        if (augmentation instanceof NamespaceRevisionAware) {
            namespace = ((NamespaceRevisionAware)augmentation).getNamespace();
            revision = ((NamespaceRevisionAware)augmentation).getRevision();
        }
        if (namespace == null || revision == null) {
            for (DataSchemaNode child : augmentation.getChildNodes()) {
                if (child.isAugmenting()) continue;
                namespace = child.getQName().getNamespace();
                revision = child.getQName().getRevision();
                break;
            }
        }
        Preconditions.checkState((namespace != null ? 1 : 0) != 0, (Object)"Augmentation namespace must not be null");
        Preconditions.checkState((revision != null ? 1 : 0) != 0, (Object)"Augmentation revision must not be null");
        return QName.create((URI)namespace, (Optional)revision, (String)"foo_augment");
    }

    public static QName getAugmentationIdentifier(AugmentationSchemaNode augmentation) {
        for (UnknownSchemaNode extension : augmentation.getUnknownSchemaNodes()) {
            if (!AUGMENT_IDENTIFIER.equals(extension.getNodeType().getLocalName())) continue;
            return extension.getQName();
        }
        return null;
    }

    public static @Nullable TypeDefinition<?> findTypeDefinition(SchemaContext context, SchemaPath path) {
        Iterator arguments = path.getPathFromRoot().iterator();
        Preconditions.checkArgument((boolean)arguments.hasNext(), (Object)"Type Definition path must contain at least one element.");
        QName currentArg = (QName)arguments.next();
        DataNodeContainer currentNode = context.findModule(currentArg.getModule()).orElse(null);
        if (currentNode == null) {
            return null;
        }
        while (arguments.hasNext()) {
            DataSchemaNode child = currentNode.getDataChildByName(currentArg);
            if (child instanceof DataNodeContainer) {
                currentNode = (DataNodeContainer)child;
            } else if (child instanceof ChoiceSchemaNode) {
                QName caseQName = (QName)arguments.next();
                Preconditions.checkArgument((boolean)arguments.hasNext(), (Object)"Path must not refer case only.");
                currentNode = ((ChoiceSchemaNode)child).getCaseNodeByName(caseQName);
            } else {
                for (GroupingDefinition grouping : currentNode.getGroupings()) {
                    if (!currentArg.equals((Object)grouping.getQName())) continue;
                    currentNode = grouping;
                    break;
                }
            }
            currentArg = (QName)arguments.next();
        }
        for (TypeDefinition typedef : currentNode.getTypeDefinitions()) {
            if (!typedef.getQName().equals((Object)currentArg)) continue;
            return typedef;
        }
        return null;
    }
}

