/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.yang.types;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.opendaylight.mdsal.binding.generator.spi.TypeProvider;
import org.opendaylight.mdsal.binding.model.api.AccessModifier;
import org.opendaylight.mdsal.binding.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.model.api.Enumeration;
import org.opendaylight.mdsal.binding.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Restrictions;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.EnumBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.util.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.model.util.BindingTypes;
import org.opendaylight.mdsal.binding.model.util.Types;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.AbstractEnumerationBuilder;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.GeneratedPropertyBuilderImpl;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.mdsal.binding.yang.types.BaseYangTypes;
import org.opendaylight.mdsal.binding.yang.types.TypedefResolver;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.ModuleDependencySort;
import org.opendaylight.yangtools.yang.model.util.RevisionAwareXPathImpl;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.opendaylight.yangtools.yang.model.util.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.util.type.CompatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractTypeProvider
implements TypeProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTypeProvider.class);
    private static final Pattern GROUPS_PATTERN = Pattern.compile("\\[(.*?)\\]");
    private static final SchemaPath UNION_PATH = SchemaPath.create((boolean)true, (QName[])new QName[]{org.opendaylight.yangtools.yang.model.util.BaseTypes.UNION_QNAME});
    private final SchemaContext schemaContext;
    private final Map<String, Map<Optional<Revision>, Map<String, Type>>> genTypeDefsContextMap = new HashMap<String, Map<Optional<Revision>, Map<String, Type>>>();
    private final Map<SchemaPath, Type> referencedTypes = new HashMap<SchemaPath, Type>();
    private final Map<Module, Set<Type>> additionalTypes = new HashMap<Module, Set<Type>>();
    private final Map<SchemaNode, JavaTypeName> renames;
    private static final Comparator<BitsTypeDefinition.Bit> BIT_NAME_COMPARATOR = Comparator.comparing(BitsTypeDefinition.Bit::getName);

    AbstractTypeProvider(SchemaContext schemaContext, Map<SchemaNode, JavaTypeName> renames) {
        Preconditions.checkArgument((schemaContext != null ? 1 : 0) != 0, (Object)"Schema Context cannot be null!");
        this.schemaContext = schemaContext;
        this.renames = Objects.requireNonNull(renames);
        this.resolveTypeDefsFromContext();
    }

    public void putReferencedType(SchemaPath refTypePath, Type refType) {
        Preconditions.checkArgument((refTypePath != null ? 1 : 0) != 0, (Object)"Path reference of Enumeration Type Definition cannot be NULL!");
        Preconditions.checkArgument((refType != null ? 1 : 0) != 0, (Object)"Reference to Enumeration Type cannot be NULL!");
        this.referencedTypes.put(refTypePath, refType);
    }

    public Map<Module, Set<Type>> getAdditionalTypes() {
        return this.additionalTypes;
    }

    public Type javaTypeForSchemaDefinitionType(TypeDefinition<?> typeDefinition, SchemaNode parentNode, boolean lenientRelativeLeafrefs) {
        return this.javaTypeForSchemaDefinitionType(typeDefinition, parentNode, null, lenientRelativeLeafrefs);
    }

    public Type javaTypeForSchemaDefinitionType(TypeDefinition<?> typeDefinition, SchemaNode parentNode, Restrictions restrictions, boolean lenientRelativeLeafrefs) {
        Preconditions.checkArgument((typeDefinition != null ? 1 : 0) != 0, (Object)"Type Definition cannot be NULL!");
        Preconditions.checkArgument((typeDefinition.getQName() != null ? 1 : 0) != 0, (Object)"Type Definition cannot have non specified QName (QName cannot be NULL!)");
        String typedefName = typeDefinition.getQName().getLocalName();
        Preconditions.checkArgument((typedefName != null ? 1 : 0) != 0, (Object)"Type Definitions Local Name cannot be NULL!");
        if (typeDefinition.getBaseType() == null) {
            Type ret;
            if (typeDefinition instanceof DecimalTypeDefinition && (ret = BaseYangTypes.BASE_YANG_TYPES_PROVIDER.javaTypeForSchemaDefinitionType(typeDefinition, parentNode, restrictions, lenientRelativeLeafrefs)) != null) {
                return ret;
            }
            ret = this.javaTypeForLeafrefOrIdentityRef(typeDefinition, parentNode, lenientRelativeLeafrefs);
            if (ret != null) {
                return ret;
            }
            ret = BaseYangTypes.javaTypeForYangType(typeDefinition.getQName().getLocalName());
            if (ret == null) {
                LOG.debug("Failed to resolve Java type for {}", typeDefinition);
            }
            return ret;
        }
        Type returnType = this.javaTypeForExtendedType(typeDefinition, lenientRelativeLeafrefs);
        if (restrictions != null && returnType instanceof GeneratedTransferObject) {
            GeneratedTransferObject gto = (GeneratedTransferObject)returnType;
            Module module = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode);
            String basePackageName = BindingMapping.getRootPackageName((QNameModule)module.getQNameModule());
            String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)typeDefinition.getPath());
            String genTOName = BindingMapping.getClassName((String)typedefName);
            String name = packageName + "." + genTOName;
            if (!returnType.getFullyQualifiedName().equals(name)) {
                returnType = this.shadedTOWithRestrictions(gto, restrictions);
            }
        }
        return returnType;
    }

    private GeneratedTransferObject shadedTOWithRestrictions(GeneratedTransferObject gto, Restrictions restrictions) {
        GeneratedTOBuilder gtob = this.newGeneratedTOBuilder((JavaTypeName)gto.getIdentifier());
        GeneratedTransferObject parent = gto.getSuperType();
        if (parent != null) {
            gtob.setExtendsType(parent);
        }
        gtob.setRestrictions(restrictions);
        for (GeneratedProperty gp : gto.getProperties()) {
            GeneratedPropertyBuilder gpb = gtob.addProperty(gp.getName());
            gpb.setValue(gp.getValue());
            gpb.setReadOnly(gp.isReadOnly());
            gpb.setAccessModifier(gp.getAccessModifier());
            gpb.setReturnType(gp.getReturnType());
            gpb.setFinal(gp.isFinal());
            gpb.setStatic(gp.isStatic());
        }
        return gtob.build();
    }

    private boolean isLeafRefSelfReference(LeafrefTypeDefinition leafref, SchemaNode parentNode) {
        RevisionAwareXPath leafRefXPath = leafref.getPathStatement();
        RevisionAwareXPathImpl leafRefStrippedXPath = new RevisionAwareXPathImpl(GROUPS_PATTERN.matcher(leafRefXPath.toString()).replaceAll(""), leafRefXPath.isAbsolute());
        Iterator iterator = parentNode.getPath().getPathFromRoot().iterator();
        boolean isAugmenting = false;
        DataNodeContainer current = null;
        while (iterator.hasNext() && !isAugmenting) {
            QName next = (QName)iterator.next();
            DataSchemaNode dataChildByName = current == null ? this.schemaContext.getDataChildByName(next) : current.getDataChildByName(next);
            if (dataChildByName == null) {
                return false;
            }
            isAugmenting = dataChildByName.isAugmenting();
            if (!(dataChildByName instanceof DataNodeContainer)) continue;
            current = (DataNodeContainer)dataChildByName;
        }
        if (isAugmenting) {
            return false;
        }
        Module parentModule = this.getParentModule(parentNode);
        SchemaNode leafRefValueNode = !leafRefStrippedXPath.isAbsolute() ? SchemaContextUtil.findDataSchemaNodeForRelativeXPath((SchemaContext)this.schemaContext, (Module)parentModule, (SchemaNode)parentNode, (RevisionAwareXPath)leafRefStrippedXPath) : SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (Module)parentModule, (RevisionAwareXPath)leafRefStrippedXPath);
        return leafRefValueNode != null && leafRefValueNode.equals(parentNode);
    }

    private Type javaTypeForLeafrefOrIdentityRef(TypeDefinition<?> typeDefinition, SchemaNode parentNode, boolean inGrouping) {
        if (typeDefinition instanceof LeafrefTypeDefinition) {
            LeafrefTypeDefinition leafref = (LeafrefTypeDefinition)typeDefinition;
            Preconditions.checkArgument((!this.isLeafRefSelfReference(leafref, parentNode) ? 1 : 0) != 0, (String)"Leafref %s is referencing itself, incoming StackOverFlowError detected.", (Object)leafref);
            return this.provideTypeForLeafref(leafref, parentNode, inGrouping);
        }
        if (typeDefinition instanceof IdentityrefTypeDefinition) {
            return this.provideTypeForIdentityref((IdentityrefTypeDefinition)typeDefinition);
        }
        return null;
    }

    private Type javaTypeForExtendedType(TypeDefinition<?> typeDefinition, boolean lenient) {
        String typedefName = typeDefinition.getQName().getLocalName();
        TypeDefinition<?> baseTypeDef = AbstractTypeProvider.baseTypeDefForExtendedType(typeDefinition);
        Type returnType = this.javaTypeForLeafrefOrIdentityRef(baseTypeDef, (SchemaNode)typeDefinition, lenient);
        if (returnType == null) {
            if (baseTypeDef instanceof EnumTypeDefinition) {
                EnumTypeDefinition enumTypeDef = (EnumTypeDefinition)baseTypeDef;
                returnType = this.provideTypeForEnum(enumTypeDef, typedefName, (SchemaNode)typeDefinition);
            } else {
                Module module = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, typeDefinition);
                Restrictions r = BindingGeneratorUtil.getRestrictions(typeDefinition);
                if (module != null) {
                    Map<Optional<Revision>, Map<String, Type>> modulesByDate = this.genTypeDefsContextMap.get(module.getName());
                    Map<String, Type> genTOs = modulesByDate.get(module.getRevision());
                    if (genTOs != null) {
                        returnType = genTOs.get(typedefName);
                    }
                    if (returnType == null) {
                        returnType = BaseYangTypes.BASE_YANG_TYPES_PROVIDER.javaTypeForSchemaDefinitionType(baseTypeDef, typeDefinition, r, lenient);
                    }
                }
            }
        }
        return returnType;
    }

    private Type provideTypeForIdentityref(IdentityrefTypeDefinition idref) {
        Set identities = idref.getIdentities();
        if (identities.size() > 1) {
            LOG.warn("Identity reference {} has multiple identities, using only the first one", (Object)idref);
        }
        QName baseIdQName = ((IdentitySchemaNode)identities.iterator().next()).getQName();
        Module module = this.schemaContext.findModule(baseIdQName.getModule()).orElse(null);
        IdentitySchemaNode identity = null;
        for (IdentitySchemaNode id : module.getIdentities()) {
            if (!id.getQName().equals((Object)baseIdQName)) continue;
            identity = id;
        }
        Preconditions.checkArgument((identity != null ? 1 : 0) != 0, (Object)("Target identity '" + baseIdQName + "' do not exists"));
        String basePackageName = BindingMapping.getRootPackageName((QNameModule)module.getQNameModule());
        JavaTypeName identifier = JavaTypeName.create((String)BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)identity.getPath()), (String)BindingMapping.getClassName((QName)identity.getQName()));
        return Types.classType((Type)Types.wildcardTypeFor((JavaTypeName)identifier));
    }

    public Type generatedTypeForExtendedDefinitionType(TypeDefinition<?> typeDefinition, SchemaNode parentNode) {
        Map<Optional<Revision>, Map<String, Type>> modulesByDate;
        Map<String, Type> genTOs;
        Preconditions.checkArgument((typeDefinition != null ? 1 : 0) != 0, (Object)"Type Definition cannot be NULL!");
        if (typeDefinition.getQName() == null) {
            throw new IllegalArgumentException("Type Definition cannot have unspecified QName (QName cannot be NULL!)");
        }
        Preconditions.checkArgument((typeDefinition.getQName().getLocalName() != null ? 1 : 0) != 0, (Object)"Type Definitions Local Name cannot be NULL!");
        TypeDefinition<?> baseTypeDef = AbstractTypeProvider.baseTypeDefForExtendedType(typeDefinition);
        if (baseTypeDef instanceof LeafrefTypeDefinition || baseTypeDef instanceof IdentityrefTypeDefinition) {
            return null;
        }
        Module module = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode);
        if (module != null && (genTOs = (modulesByDate = this.genTypeDefsContextMap.get(module.getName())).get(module.getRevision())) != null) {
            return genTOs.get(typeDefinition.getQName().getLocalName());
        }
        return null;
    }

    private static TypeDefinition<?> baseTypeDefForExtendedType(TypeDefinition<?> extendTypeDef) {
        Preconditions.checkArgument((extendTypeDef != null ? 1 : 0) != 0, (Object)"Type Definition reference cannot be NULL!");
        TypeDefinition ret = extendTypeDef;
        while (ret.getBaseType() != null) {
            ret = ret.getBaseType();
        }
        return ret;
    }

    public Type provideTypeForLeafref(LeafrefTypeDefinition leafrefType, SchemaNode parentNode, boolean inGrouping) {
        SchemaNode dataNode;
        Preconditions.checkArgument((leafrefType != null ? 1 : 0) != 0, (Object)"Leafref Type Definition reference cannot be NULL!");
        RevisionAwareXPath xpath = leafrefType.getPathStatement();
        Preconditions.checkArgument((xpath != null ? 1 : 0) != 0, (Object)"The Path Statement for Leafref Type Definition cannot be NULL!");
        String strXPath = (String)Verify.verifyNotNull((Object)xpath.toString());
        if (strXPath.indexOf(91) != -1) {
            return Types.objectType();
        }
        Module module = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode);
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (String)"Failed to find module for parent %s", (Object)parentNode);
        if (xpath.isAbsolute()) {
            dataNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (Module)module, (RevisionAwareXPath)xpath);
        } else {
            dataNode = SchemaContextUtil.findDataSchemaNodeForRelativeXPath((SchemaContext)this.schemaContext, (Module)module, (SchemaNode)parentNode, (RevisionAwareXPath)xpath);
            if (dataNode == null && inGrouping) {
                LOG.debug("Leafref type {} not found in parent {}, assuming polymorphic object", (Object)leafrefType, (Object)parentNode);
                return Types.objectType();
            }
        }
        Preconditions.checkArgument((dataNode != null ? 1 : 0) != 0, (String)"Failed to find leafref target: %s in module %s (%s)", (Object)strXPath, (Object)this.getParentModule(parentNode).getName(), (Object)parentNode.getQName().getModule());
        Type returnType = null;
        if (AbstractTypeProvider.leafContainsEnumDefinition(dataNode)) {
            returnType = this.referencedTypes.get(dataNode.getPath());
        } else if (AbstractTypeProvider.leafListContainsEnumDefinition(dataNode)) {
            returnType = Types.listTypeFor((Type)this.referencedTypes.get(dataNode.getPath()));
        }
        if (returnType == null) {
            returnType = this.resolveTypeFromDataSchemaNode(dataNode);
        }
        Preconditions.checkArgument((returnType != null ? 1 : 0) != 0, (String)"Failed to find leafref target: %s in module %s (%s)", (Object)strXPath, (Object)this.getParentModule(parentNode).getName(), (Object)parentNode.getQName().getModule(), (Object)this);
        return returnType;
    }

    private static boolean leafContainsEnumDefinition(SchemaNode dataNode) {
        if (dataNode instanceof LeafSchemaNode) {
            LeafSchemaNode leaf = (LeafSchemaNode)dataNode;
            return CompatUtils.compatLeafType((LeafSchemaNode)leaf) instanceof EnumTypeDefinition;
        }
        return false;
    }

    private static boolean leafListContainsEnumDefinition(SchemaNode dataNode) {
        if (dataNode instanceof LeafListSchemaNode) {
            LeafListSchemaNode leafList = (LeafListSchemaNode)dataNode;
            return leafList.getType() instanceof EnumTypeDefinition;
        }
        return false;
    }

    private Enumeration provideTypeForEnum(EnumTypeDefinition enumTypeDef, String enumName, SchemaNode parentNode) {
        Preconditions.checkArgument((enumTypeDef != null ? 1 : 0) != 0, (Object)"EnumTypeDefinition reference cannot be NULL!");
        Preconditions.checkArgument((enumTypeDef.getValues() != null ? 1 : 0) != 0, (Object)"EnumTypeDefinition MUST contain at least ONE value definition!");
        Preconditions.checkArgument((enumTypeDef.getQName() != null ? 1 : 0) != 0, (Object)"EnumTypeDefinition MUST contain NON-NULL QName!");
        Preconditions.checkArgument((enumTypeDef.getQName().getLocalName() != null ? 1 : 0) != 0, (Object)"Local Name in EnumTypeDefinition QName cannot be NULL!");
        Module module = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode);
        AbstractEnumerationBuilder enumBuilder = this.newEnumerationBuilder(JavaTypeName.create((String)BindingMapping.getRootPackageName((QNameModule)module.getQNameModule()), (String)BindingMapping.getClassName((String)enumName)));
        this.addEnumDescription((EnumBuilder)enumBuilder, enumTypeDef);
        enumTypeDef.getReference().ifPresent(arg_0 -> ((AbstractEnumerationBuilder)enumBuilder).setReference(arg_0));
        enumBuilder.setModuleName(module.getName());
        enumBuilder.setSchemaPath(enumTypeDef.getPath());
        enumBuilder.updateEnumPairsFromEnumTypeDef(enumTypeDef);
        return enumBuilder.toInstance(null);
    }

    private Enumeration addInnerEnumerationToTypeBuilder(EnumTypeDefinition enumTypeDef, String enumName, GeneratedTypeBuilderBase<?> typeBuilder) {
        Preconditions.checkArgument((enumTypeDef != null ? 1 : 0) != 0, (Object)"EnumTypeDefinition reference cannot be NULL!");
        Preconditions.checkArgument((enumTypeDef.getValues() != null ? 1 : 0) != 0, (Object)"EnumTypeDefinition MUST contain at least ONE value definition!");
        Preconditions.checkArgument((enumTypeDef.getQName() != null ? 1 : 0) != 0, (Object)"EnumTypeDefinition MUST contain NON-NULL QName!");
        Preconditions.checkArgument((enumTypeDef.getQName().getLocalName() != null ? 1 : 0) != 0, (Object)"Local Name in EnumTypeDefinition QName cannot be NULL!");
        Preconditions.checkArgument((typeBuilder != null ? 1 : 0) != 0, (Object)"Generated Type Builder reference cannot be NULL!");
        EnumBuilder enumBuilder = typeBuilder.addEnumeration(BindingMapping.getClassName((String)enumName));
        this.addEnumDescription(enumBuilder, enumTypeDef);
        enumBuilder.updateEnumPairsFromEnumTypeDef(enumTypeDef);
        return enumBuilder.toInstance((Type)enumBuilder);
    }

    public abstract void addEnumDescription(EnumBuilder var1, EnumTypeDefinition var2);

    public abstract AbstractEnumerationBuilder newEnumerationBuilder(JavaTypeName var1);

    public abstract GeneratedTOBuilder newGeneratedTOBuilder(JavaTypeName var1);

    public abstract GeneratedTypeBuilder newGeneratedTypeBuilder(JavaTypeName var1);

    public abstract Map<String, String> resolveRegExpressions(List<PatternConstraint> var1);

    abstract void addCodegenInformation(GeneratedTypeBuilderBase<?> var1, TypeDefinition<?> var2);

    private Map<String, String> resolveRegExpressionsFromTypedef(TypeDefinition<?> typedef) {
        if (!(typedef instanceof StringTypeDefinition)) {
            return ImmutableMap.of();
        }
        return this.resolveRegExpressions(((StringTypeDefinition)typedef).getPatternConstraints());
    }

    private Type resolveTypeFromDataSchemaNode(SchemaNode dataNode) {
        Type returnType = null;
        if (dataNode != null) {
            if (dataNode instanceof LeafSchemaNode) {
                LeafSchemaNode leaf = (LeafSchemaNode)dataNode;
                TypeDefinition type = CompatUtils.compatLeafType((LeafSchemaNode)leaf);
                returnType = this.javaTypeForSchemaDefinitionType(type, (SchemaNode)leaf);
            } else if (dataNode instanceof LeafListSchemaNode) {
                LeafListSchemaNode leafList = (LeafListSchemaNode)dataNode;
                returnType = this.javaTypeForSchemaDefinitionType(leafList.getType(), (SchemaNode)leafList);
            }
        }
        return returnType;
    }

    private void resolveTypeDefsFromContext() {
        Set modules = this.schemaContext.getModules();
        Preconditions.checkArgument((modules != null ? 1 : 0) != 0, (Object)"Set of Modules cannot be NULL!");
        List modulesSortedByDependency = ModuleDependencySort.sort((Collection)modules);
        for (Module module : modulesSortedByDependency) {
            Map dateTypeMap = this.genTypeDefsContextMap.computeIfAbsent(module.getName(), key -> new HashMap());
            dateTypeMap.put(module.getRevision(), Collections.emptyMap());
            this.genTypeDefsContextMap.put(module.getName(), dateTypeMap);
        }
        for (Module module : modulesSortedByDependency) {
            String basePackageName;
            if (module == null || (basePackageName = BindingMapping.getRootPackageName((QNameModule)module.getQNameModule())) == null) continue;
            List<TypeDefinition<?>> typeDefinitions = TypedefResolver.getAllTypedefs(module);
            for (TypeDefinition<?> typedef : AbstractTypeProvider.sortTypeDefinitionAccordingDepth(typeDefinitions)) {
                this.typedefToGeneratedType(basePackageName, module, typedef);
            }
        }
    }

    private Type typedefToGeneratedType(String basePackageName, Module module, TypeDefinition<?> typedef) {
        GeneratedTOBuilder genTOBuilder;
        GeneratedTransferObject returnType;
        TypeDefinition baseTypedef = typedef.getBaseType();
        if (baseTypedef instanceof LeafrefTypeDefinition || baseTypedef instanceof IdentityrefTypeDefinition) {
            return null;
        }
        String typedefName = typedef.getQName().getLocalName();
        if (baseTypedef.getBaseType() != null) {
            returnType = this.provideGeneratedTOFromExtendedType(typedef, baseTypedef, basePackageName, module.getName());
        } else if (baseTypedef instanceof UnionTypeDefinition) {
            genTOBuilder = this.provideGeneratedTOBuilderForUnionTypeDef(JavaTypeName.create((String)basePackageName, (String)BindingMapping.getClassName((QName)typedef.getQName())), (UnionTypeDefinition)baseTypedef, typedef);
            genTOBuilder.setTypedef(true);
            genTOBuilder.setIsUnion(true);
            AbstractTypeProvider.addUnitsToGenTO(genTOBuilder, typedef.getUnits().orElse(null));
            AbstractTypeProvider.makeSerializable(genTOBuilder);
            returnType = genTOBuilder.build();
            GeneratedTOBuilder unionBuilder = this.newGeneratedTOBuilder(JavaTypeName.create((String)genTOBuilder.getPackageName(), (String)(genTOBuilder.getName() + "Builder")));
            unionBuilder.setIsUnionBuilder(true);
            MethodSignatureBuilder method = unionBuilder.addMethod("getDefaultInstance");
            method.setReturnType((Type)returnType);
            method.addParameter((Type)Types.STRING, "defaultValue");
            method.setAccessModifier(AccessModifier.PUBLIC);
            method.setStatic(true);
            this.additionalTypes.computeIfAbsent(module, key -> new HashSet()).add(unionBuilder.build());
        } else if (baseTypedef instanceof EnumTypeDefinition) {
            EnumTypeDefinition enumTypeDef = (EnumTypeDefinition)baseTypedef;
            returnType = this.provideTypeForEnum(enumTypeDef, typedefName, (SchemaNode)typedef);
        } else if (baseTypedef instanceof BitsTypeDefinition) {
            genTOBuilder = this.provideGeneratedTOBuilderForBitsTypeDefinition(JavaTypeName.create((String)basePackageName, (String)BindingMapping.getClassName((QName)typedef.getQName())), (BitsTypeDefinition)baseTypedef, module.getName());
            genTOBuilder.setTypedef(true);
            AbstractTypeProvider.addUnitsToGenTO(genTOBuilder, typedef.getUnits().orElse(null));
            AbstractTypeProvider.makeSerializable(genTOBuilder);
            returnType = genTOBuilder.build();
        } else {
            Type javaType = this.javaTypeForSchemaDefinitionType(baseTypedef, (SchemaNode)typedef);
            returnType = this.wrapJavaTypeIntoTO(basePackageName, typedef, javaType, module.getName());
        }
        if (returnType != null) {
            Optional moduleRevision;
            Map<Optional<Revision>, Map<String, Type>> modulesByDate = this.genTypeDefsContextMap.get(module.getName());
            Map<String, Type> typeMap = modulesByDate.get(moduleRevision = module.getRevision());
            if (typeMap != null) {
                if (typeMap.isEmpty()) {
                    typeMap = new HashMap<String, Type>(4);
                    modulesByDate.put(moduleRevision, typeMap);
                }
                typeMap.put(typedefName, (Type)returnType);
            }
            return returnType;
        }
        return null;
    }

    private GeneratedTransferObject wrapJavaTypeIntoTO(String basePackageName, TypeDefinition<?> typedef, Type javaType, String moduleName) {
        Objects.requireNonNull(javaType, "javaType cannot be null");
        GeneratedTOBuilder genTOBuilder = this.typedefToTransferObject(basePackageName, typedef, moduleName);
        genTOBuilder.setRestrictions(BindingGeneratorUtil.getRestrictions(typedef));
        GeneratedPropertyBuilder genPropBuilder = genTOBuilder.addProperty("value");
        genPropBuilder.setReturnType(javaType);
        genTOBuilder.addEqualsIdentity(genPropBuilder);
        genTOBuilder.addHashIdentity(genPropBuilder);
        genTOBuilder.addToStringProperty(genPropBuilder);
        genTOBuilder.addImplementsType((Type)BindingTypes.TYPE_OBJECT);
        if (typedef.getStatus() == Status.DEPRECATED) {
            genTOBuilder.addAnnotation("java.lang", "Deprecated");
        }
        if (javaType instanceof ConcreteType && "String".equals(javaType.getName()) && typedef.getBaseType() != null) {
            AbstractTypeProvider.addStringRegExAsConstant(genTOBuilder, this.resolveRegExpressionsFromTypedef(typedef));
        }
        AbstractTypeProvider.addUnitsToGenTO(genTOBuilder, typedef.getUnits().orElse(null));
        genTOBuilder.setTypedef(true);
        AbstractTypeProvider.makeSerializable(genTOBuilder);
        return genTOBuilder.build();
    }

    public GeneratedTOBuilder provideGeneratedTOBuilderForUnionTypeDef(JavaTypeName typeName, UnionTypeDefinition typedef, TypeDefinition<?> parentNode) {
        List<GeneratedTOBuilder> builders = this.provideGeneratedTOBuildersForUnionTypeDef(typeName, typedef, (SchemaNode)parentNode);
        Preconditions.checkState((!builders.isEmpty() ? 1 : 0) != 0, (String)"No GeneratedTOBuilder objects generated from union %s", (Object)typedef);
        GeneratedTOBuilder resultTOBuilder = builders.remove(0);
        builders.forEach(arg_0 -> ((GeneratedTOBuilder)resultTOBuilder).addEnclosingTransferObject(arg_0));
        return resultTOBuilder;
    }

    public List<GeneratedTOBuilder> provideGeneratedTOBuildersForUnionTypeDef(JavaTypeName typeName, UnionTypeDefinition typedef, SchemaNode parentNode) {
        Objects.requireNonNull(typedef, "Type Definition cannot be NULL!");
        Objects.requireNonNull(typedef.getQName(), "Type definition QName cannot be NULL!");
        ArrayList<GeneratedTOBuilder> generatedTOBuilders = new ArrayList<GeneratedTOBuilder>();
        List unionTypes = typedef.getTypes();
        Module module = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode);
        GeneratedTOBuilder unionGenTOBuilder = this.newGeneratedTOBuilder(typeName);
        unionGenTOBuilder.setIsUnion(true);
        unionGenTOBuilder.setSchemaPath(typedef.getPath());
        unionGenTOBuilder.setModuleName(module.getName());
        unionGenTOBuilder.addImplementsType((Type)BindingTypes.TYPE_OBJECT);
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)unionGenTOBuilder, (TypeDefinition<?>)typedef);
        generatedTOBuilders.add(unionGenTOBuilder);
        HashMap<String, String> expressions = new HashMap<String, String>();
        for (TypeDefinition unionType : unionTypes) {
            String unionTypeName = unionType.getQName().getLocalName();
            if (unionType.getBaseType() != null && !(unionType instanceof IdentityrefTypeDefinition)) {
                this.resolveExtendedSubtypeAsUnion(unionGenTOBuilder, unionType, expressions, parentNode);
                continue;
            }
            if (unionType instanceof UnionTypeDefinition) {
                generatedTOBuilders.addAll(this.resolveUnionSubtypeAsUnion(unionGenTOBuilder, (UnionTypeDefinition)unionType, parentNode));
                continue;
            }
            if (unionType instanceof EnumTypeDefinition) {
                Enumeration enumeration = this.addInnerEnumerationToTypeBuilder((EnumTypeDefinition)unionType, unionTypeName, (GeneratedTypeBuilderBase<?>)unionGenTOBuilder);
                AbstractTypeProvider.updateUnionTypeAsProperty(unionGenTOBuilder, (Type)enumeration, unionTypeName);
                continue;
            }
            Type javaType = this.javaTypeForSchemaDefinitionType(unionType, parentNode);
            AbstractTypeProvider.updateUnionTypeAsProperty(unionGenTOBuilder, javaType, unionTypeName);
        }
        AbstractTypeProvider.addStringRegExAsConstant(unionGenTOBuilder, expressions);
        this.storeGenTO((TypeDefinition<?>)typedef, unionGenTOBuilder, parentNode);
        return generatedTOBuilders;
    }

    private List<GeneratedTOBuilder> resolveUnionSubtypeAsUnion(GeneratedTOBuilder parentUnionGenTOBuilder, UnionTypeDefinition unionSubtype, SchemaNode parentNode) {
        JavaTypeName newTOBuilderName = ((JavaTypeName)parentUnionGenTOBuilder.getIdentifier()).createSibling(AbstractTypeProvider.provideAvailableNameForGenTOBuilder(parentUnionGenTOBuilder.getName()));
        List<GeneratedTOBuilder> subUnionGenTOBUilders = this.provideGeneratedTOBuildersForUnionTypeDef(newTOBuilderName, unionSubtype, parentNode);
        GeneratedPropertyBuilder propertyBuilder = parentUnionGenTOBuilder.addProperty(BindingMapping.getPropertyName((String)newTOBuilderName.simpleName()));
        propertyBuilder.setReturnType((Type)subUnionGenTOBUilders.get(0).build());
        parentUnionGenTOBuilder.addEqualsIdentity(propertyBuilder);
        parentUnionGenTOBuilder.addToStringProperty(propertyBuilder);
        return subUnionGenTOBUilders;
    }

    private void resolveExtendedSubtypeAsUnion(GeneratedTOBuilder parentUnionGenTOBuilder, TypeDefinition<?> unionSubtype, Map<String, String> expressions, SchemaNode parentNode) {
        String unionTypeName = unionSubtype.getQName().getLocalName();
        Type genTO = this.findGenTO(unionTypeName, (SchemaNode)unionSubtype);
        if (genTO != null) {
            AbstractTypeProvider.updateUnionTypeAsProperty(parentUnionGenTOBuilder, genTO, genTO.getName());
            return;
        }
        TypeDefinition<?> baseType = AbstractTypeProvider.baseTypeDefForExtendedType(unionSubtype);
        if (unionTypeName.equals(baseType.getQName().getLocalName())) {
            Type javaType = BaseYangTypes.BASE_YANG_TYPES_PROVIDER.javaTypeForSchemaDefinitionType(baseType, parentNode, BindingGeneratorUtil.getRestrictions(unionSubtype));
            if (javaType != null) {
                AbstractTypeProvider.updateUnionTypeAsProperty(parentUnionGenTOBuilder, javaType, unionTypeName);
            }
        } else if (baseType instanceof LeafrefTypeDefinition) {
            Type javaType = this.javaTypeForSchemaDefinitionType(baseType, parentNode);
            boolean typeExist = false;
            for (GeneratedPropertyBuilder generatedPropertyBuilder : parentUnionGenTOBuilder.getProperties()) {
                Type origType = ((GeneratedPropertyBuilderImpl)generatedPropertyBuilder).getReturnType();
                if (origType == null || javaType == null || javaType != origType) continue;
                typeExist = true;
                break;
            }
            if (!typeExist && javaType != null) {
                AbstractTypeProvider.updateUnionTypeAsProperty(parentUnionGenTOBuilder, javaType, javaType.getName() + parentUnionGenTOBuilder.getName() + "Value");
            }
        }
        if (baseType instanceof StringTypeDefinition) {
            expressions.putAll(this.resolveRegExpressionsFromTypedef(unionSubtype));
        }
    }

    private Type findGenTO(String searchedTypeName, SchemaNode parentNode) {
        Map<Optional<Revision>, Map<String, Type>> modulesByDate;
        Map<String, Type> genTOs;
        Module typeModule = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode);
        if (typeModule != null && typeModule.getName() != null && (genTOs = (modulesByDate = this.genTypeDefsContextMap.get(typeModule.getName())).get(typeModule.getRevision())) != null) {
            return genTOs.get(searchedTypeName);
        }
        return null;
    }

    private void storeGenTO(TypeDefinition<?> newTypeDef, GeneratedTOBuilder genTOBuilder, SchemaNode parentNode) {
        Module parentModule;
        if (!(newTypeDef instanceof UnionTypeDefinition) && (parentModule = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode)) != null && parentModule.getName() != null) {
            Map<Optional<Revision>, Map<String, Type>> modulesByDate = this.genTypeDefsContextMap.get(parentModule.getName());
            Map<String, Type> genTOsMap = modulesByDate.get(parentModule.getRevision());
            genTOsMap.put(newTypeDef.getQName().getLocalName(), (Type)genTOBuilder.build());
        }
    }

    private static void updateUnionTypeAsProperty(GeneratedTOBuilder unionGenTransObject, Type type, String propertyName) {
        if (unionGenTransObject != null && type != null && !unionGenTransObject.containsProperty(propertyName)) {
            GeneratedPropertyBuilder propBuilder = unionGenTransObject.addProperty(BindingMapping.getPropertyName((String)propertyName));
            propBuilder.setReturnType(type);
            unionGenTransObject.addEqualsIdentity(propBuilder);
            unionGenTransObject.addHashIdentity(propBuilder);
            unionGenTransObject.addToStringProperty(propBuilder);
        }
    }

    private GeneratedTOBuilder typedefToTransferObject(String basePackageName, TypeDefinition<?> typedef, String moduleName) {
        JavaTypeName name = this.renames.get(typedef);
        if (name == null) {
            name = JavaTypeName.create((String)BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)typedef.getPath()), (String)BindingMapping.getClassName((String)typedef.getQName().getLocalName()));
        }
        GeneratedTOBuilder newType = this.newGeneratedTOBuilder(name);
        newType.setSchemaPath(typedef.getPath());
        newType.setModuleName(moduleName);
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)newType, typedef);
        return newType;
    }

    public GeneratedTOBuilder provideGeneratedTOBuilderForBitsTypeDefinition(JavaTypeName typeName, BitsTypeDefinition typeDef, String moduleName) {
        GeneratedTOBuilder genTOBuilder = this.newGeneratedTOBuilder(typeName);
        genTOBuilder.setSchemaPath(typeDef.getPath());
        genTOBuilder.setModuleName(moduleName);
        genTOBuilder.setBaseType((TypeDefinition)typeDef);
        genTOBuilder.addImplementsType((Type)BindingTypes.TYPE_OBJECT);
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)genTOBuilder, (TypeDefinition<?>)typeDef);
        List bitList = typeDef.getBits();
        for (BitsTypeDefinition.Bit bit : bitList) {
            String name = bit.getName();
            GeneratedPropertyBuilder genPropertyBuilder = genTOBuilder.addProperty(BindingMapping.getPropertyName((String)name));
            genPropertyBuilder.setReadOnly(true);
            genPropertyBuilder.setReturnType(BaseYangTypes.BOOLEAN_TYPE);
            genTOBuilder.addEqualsIdentity(genPropertyBuilder);
            genTOBuilder.addHashIdentity(genPropertyBuilder);
            genTOBuilder.addToStringProperty(genPropertyBuilder);
        }
        return genTOBuilder;
    }

    private static void addStringRegExAsConstant(GeneratedTOBuilder genTOBuilder, Map<String, String> expressions) {
        if (!expressions.isEmpty()) {
            genTOBuilder.addConstant((Type)Types.listTypeFor((Type)BaseYangTypes.STRING_TYPE), "PATTERN_CONSTANTS", (Object)ImmutableMap.copyOf(expressions));
        }
    }

    private GeneratedTransferObject provideGeneratedTOFromExtendedType(TypeDefinition<?> typedef, TypeDefinition<?> innerExtendedType, String basePackageName, String moduleName) {
        String innerTypeDef;
        Type type;
        Preconditions.checkArgument((innerExtendedType != null ? 1 : 0) != 0, (Object)"Extended type cannot be NULL!");
        Preconditions.checkArgument((basePackageName != null ? 1 : 0) != 0, (Object)"String with base package name cannot be NULL!");
        GeneratedTOBuilder genTOBuilder = this.newGeneratedTOBuilder(JavaTypeName.create((String)basePackageName, (String)BindingMapping.getClassName((QName)typedef.getQName())));
        genTOBuilder.setSchemaPath(typedef.getPath());
        genTOBuilder.setModuleName(moduleName);
        genTOBuilder.setTypedef(true);
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)genTOBuilder, typedef);
        Restrictions r = BindingGeneratorUtil.getRestrictions(typedef);
        genTOBuilder.setRestrictions(r);
        AbstractTypeProvider.addStringRegExAsConstant(genTOBuilder, this.resolveRegExpressionsFromTypedef(typedef));
        if (typedef.getStatus() == Status.DEPRECATED) {
            genTOBuilder.addAnnotation("java.lang", "Deprecated");
        }
        if (AbstractTypeProvider.baseTypeDefForExtendedType(innerExtendedType) instanceof UnionTypeDefinition) {
            genTOBuilder.setIsUnion(true);
        }
        Map<Optional<Revision>, Map<String, Type>> modulesByDate = null;
        Map<String, Type> typeMap = null;
        Module parentModule = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, innerExtendedType);
        if (parentModule != null) {
            modulesByDate = this.genTypeDefsContextMap.get(parentModule.getName());
            typeMap = modulesByDate.get(parentModule.getRevision());
        }
        if (typeMap != null && (type = (Type)typeMap.get(innerTypeDef = innerExtendedType.getQName().getLocalName())) instanceof GeneratedTransferObject) {
            genTOBuilder.setExtendsType((GeneratedTransferObject)type);
        }
        AbstractTypeProvider.addUnitsToGenTO(genTOBuilder, typedef.getUnits().orElse(null));
        AbstractTypeProvider.makeSerializable(genTOBuilder);
        return genTOBuilder.build();
    }

    private static void makeSerializable(GeneratedTOBuilder gto) {
        gto.addImplementsType((Type)Types.serializableType());
        GeneratedPropertyBuilderImpl prop = new GeneratedPropertyBuilderImpl("serialVersionUID");
        prop.setValue(Long.toString(BindingGeneratorUtil.computeDefaultSUID((GeneratedTypeBuilderBase)gto)));
        gto.setSUID((GeneratedPropertyBuilder)prop);
    }

    private static List<TypeDefinition<?>> sortTypeDefinitionAccordingDepth(Collection<TypeDefinition<?>> unsortedTypeDefinitions) {
        ArrayList sortedTypeDefinition = new ArrayList();
        TreeMap<Integer, List> typeDefinitionsDepths = new TreeMap<Integer, List>();
        for (TypeDefinition<?> unsortedTypeDefinition : unsortedTypeDefinitions) {
            Integer depth = AbstractTypeProvider.getTypeDefinitionDepth(unsortedTypeDefinition);
            List typeDefinitionsConcreteDepth = typeDefinitionsDepths.computeIfAbsent(depth, k -> new ArrayList());
            typeDefinitionsConcreteDepth.add(unsortedTypeDefinition);
        }
        for (List v : typeDefinitionsDepths.values()) {
            sortedTypeDefinition.addAll(v);
        }
        return sortedTypeDefinition;
    }

    private static int getTypeDefinitionDepth(TypeDefinition<?> typeDefinition) {
        if (typeDefinition == null) {
            return 1;
        }
        TypeDefinition baseType = typeDefinition.getBaseType();
        if (baseType == null) {
            return 1;
        }
        int depth = 1;
        if (baseType.getBaseType() != null) {
            depth += AbstractTypeProvider.getTypeDefinitionDepth(baseType);
        } else if (baseType instanceof UnionTypeDefinition) {
            List childTypeDefinitions = ((UnionTypeDefinition)baseType).getTypes();
            int maxChildDepth = 0;
            int childDepth = 1;
            for (TypeDefinition childTypeDefinition : childTypeDefinitions) {
                if ((childDepth += AbstractTypeProvider.getTypeDefinitionDepth(childTypeDefinition)) <= maxChildDepth) continue;
                maxChildDepth = childDepth;
            }
            return maxChildDepth;
        }
        return depth;
    }

    private static String provideAvailableNameForGenTOBuilder(String name) {
        int dollar = name.indexOf(36);
        if (dollar == -1) {
            return name + "$1";
        }
        int newSuffix = Integer.parseUnsignedInt(name.substring(dollar + 1)) + 1;
        Preconditions.checkState((newSuffix > 0 ? 1 : 0) != 0, (Object)"Suffix counter overflow");
        return name.substring(0, dollar + 1) + newSuffix;
    }

    public static void addUnitsToGenTO(GeneratedTOBuilder to, String units) {
        if (!Strings.isNullOrEmpty((String)units)) {
            to.addConstant((Type)Types.STRING, "_UNITS", (Object)("\"" + units + "\""));
            GeneratedPropertyBuilderImpl prop = new GeneratedPropertyBuilderImpl("UNITS");
            prop.setReturnType((Type)Types.STRING);
            to.addToStringProperty((GeneratedPropertyBuilder)prop);
        }
    }

    public String getTypeDefaultConstruction(LeafSchemaNode node) {
        return this.getTypeDefaultConstruction(node, node.getType().getDefaultValue().orElse(null));
    }

    public String getTypeDefaultConstruction(LeafSchemaNode node, String defaultValue) {
        String className;
        TypeDefinition type = CompatUtils.compatLeafType((LeafSchemaNode)node);
        QName typeQName = type.getQName();
        TypeDefinition<?> base = AbstractTypeProvider.baseTypeDefForExtendedType(type);
        Objects.requireNonNull(type, () -> "Cannot provide default construction for null type of " + node);
        Objects.requireNonNull(defaultValue, () -> "Cannot provide default construction for null default statement of " + node);
        StringBuilder sb = new StringBuilder();
        String result = null;
        if (base instanceof BinaryTypeDefinition) {
            result = AbstractTypeProvider.binaryToDef(defaultValue);
        } else if (base instanceof BitsTypeDefinition) {
            String className2;
            String parentName;
            Module parent = this.getParentModule((SchemaNode)node);
            Iterator path = node.getPath().getPathFromRoot().iterator();
            path.next();
            if (!path.hasNext()) {
                parentName = BindingMapping.getClassName((String)parent.getName()) + "Data";
                String basePackageName = BindingMapping.getRootPackageName((QNameModule)parent.getQNameModule());
                className2 = basePackageName + "." + parentName + "." + BindingMapping.getClassName((QName)node.getQName());
            } else {
                String basePackageName = BindingMapping.getRootPackageName((QNameModule)parent.getQNameModule());
                String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)type.getPath());
                parentName = BindingMapping.getClassName((String)parent.getName());
                className2 = packageName + "." + parentName + "." + BindingMapping.getClassName((QName)node.getQName());
            }
            result = AbstractTypeProvider.bitsToDef((BitsTypeDefinition)base, className2, defaultValue, type.getBaseType() != null);
        } else if (base instanceof BooleanTypeDefinition) {
            result = AbstractTypeProvider.typeToBooleanDef(defaultValue);
        } else if (base instanceof DecimalTypeDefinition) {
            result = AbstractTypeProvider.typeToDef(BigDecimal.class, defaultValue);
        } else if (base instanceof EmptyTypeDefinition) {
            result = AbstractTypeProvider.typeToBooleanDef(defaultValue);
        } else if (base instanceof EnumTypeDefinition) {
            char first;
            Object defValArray = defaultValue.toCharArray();
            defValArray[0] = first = Character.toUpperCase(defaultValue.charAt(0));
            String newDefVal = new String((char[])defValArray);
            if (type.getBaseType() != null) {
                Module m = this.getParentModule((SchemaNode)type);
                String basePackageName = BindingMapping.getRootPackageName((QNameModule)m.getQNameModule());
                String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)type.getPath());
                className = packageName + "." + BindingMapping.getClassName((QName)typeQName);
            } else {
                Module parentModule = this.getParentModule((SchemaNode)node);
                String basePackageName = BindingMapping.getRootPackageName((QNameModule)parentModule.getQNameModule());
                String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)node.getPath());
                className = packageName + "." + BindingMapping.getClassName((QName)node.getQName());
            }
            result = className + "." + newDefVal;
        } else {
            if (base instanceof IdentityrefTypeDefinition) {
                throw new UnsupportedOperationException("Cannot get default construction for identityref type");
            }
            if (base instanceof InstanceIdentifierTypeDefinition) {
                throw new UnsupportedOperationException("Cannot get default construction for instance-identifier type");
            }
            if (BaseTypes.isInt8(base)) {
                result = AbstractTypeProvider.typeToValueOfDef(Byte.class, defaultValue);
            } else if (BaseTypes.isInt16(base)) {
                result = AbstractTypeProvider.typeToValueOfDef(Short.class, defaultValue);
            } else if (BaseTypes.isInt32(base)) {
                result = AbstractTypeProvider.typeToValueOfDef(Integer.class, defaultValue);
            } else if (BaseTypes.isInt64(base)) {
                result = AbstractTypeProvider.typeToValueOfDef(Long.class, defaultValue);
            } else if (base instanceof LeafrefTypeDefinition) {
                result = this.leafrefToDef(node, (LeafrefTypeDefinition)base, defaultValue);
            } else if (base instanceof StringTypeDefinition) {
                result = "\"" + defaultValue + "\"";
            } else if (BaseTypes.isUint8(base)) {
                result = AbstractTypeProvider.typeToValueOfDef(Short.class, defaultValue);
            } else if (BaseTypes.isUint16(base)) {
                result = AbstractTypeProvider.typeToValueOfDef(Integer.class, defaultValue);
            } else if (BaseTypes.isUint32(base)) {
                result = AbstractTypeProvider.typeToValueOfDef(Long.class, defaultValue);
            } else if (BaseTypes.isUint64(base)) {
                switch (defaultValue) {
                    case "0": {
                        result = "java.math.BigInteger.ZERO";
                        break;
                    }
                    case "1": {
                        result = "java.math.BigInteger.ONE";
                        break;
                    }
                    case "10": {
                        result = "java.math.BigInteger.TEN";
                        break;
                    }
                    default: {
                        result = AbstractTypeProvider.typeToDef(BigInteger.class, defaultValue);
                        break;
                    }
                }
            } else {
                result = base instanceof UnionTypeDefinition ? this.unionToDef(node) : "";
            }
        }
        sb.append(result);
        if (!(type.getBaseType() == null || base instanceof LeafrefTypeDefinition || base instanceof EnumTypeDefinition || base instanceof UnionTypeDefinition)) {
            Module m = this.getParentModule((SchemaNode)type);
            String basePackageName = BindingMapping.getRootPackageName((QNameModule)m.getQNameModule());
            String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)type.getPath());
            className = packageName + "." + BindingMapping.getClassName((QName)typeQName);
            sb.insert(0, "new " + className + "(");
            sb.insert(sb.length(), ')');
        }
        return sb.toString();
    }

    private static String typeToDef(Class<?> clazz, String defaultValue) {
        return "new " + clazz.getName() + "(\"" + defaultValue + "\")";
    }

    private static String typeToValueOfDef(Class<?> clazz, String defaultValue) {
        return clazz.getName() + ".valueOf(\"" + defaultValue + "\")";
    }

    private static String typeToBooleanDef(String defaultValue) {
        switch (defaultValue) {
            case "false": {
                return "java.lang.Boolean.FALSE";
            }
            case "true": {
                return "java.lang.Boolean.TRUE";
            }
        }
        return AbstractTypeProvider.typeToValueOfDef(Boolean.class, defaultValue);
    }

    private static String binaryToDef(String defaultValue) {
        StringBuilder sb = new StringBuilder();
        byte[] encoded = Base64.getDecoder().decode(defaultValue);
        sb.append("new byte[] {");
        for (int i = 0; i < encoded.length; ++i) {
            sb.append(encoded[i]);
            if (i == encoded.length - 1) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    private static String bitsToDef(BitsTypeDefinition type, String className, String defaultValue, boolean isExt) {
        ArrayList<BitsTypeDefinition.Bit> bits = new ArrayList<BitsTypeDefinition.Bit>(type.getBits());
        bits.sort(BIT_NAME_COMPARATOR);
        StringBuilder sb = new StringBuilder();
        if (!isExt) {
            sb.append("new ");
            sb.append(className);
            sb.append('(');
        }
        for (int i = 0; i < bits.size(); ++i) {
            if (((BitsTypeDefinition.Bit)bits.get(i)).getName().equals(defaultValue)) {
                sb.append(true);
            } else {
                sb.append(false);
            }
            if (i == bits.size() - 1) continue;
            sb.append(", ");
        }
        if (!isExt) {
            sb.append(')');
        }
        return sb.toString();
    }

    private Module getParentModule(SchemaNode node) {
        QName qname = (QName)node.getPath().getPathFromRoot().iterator().next();
        return this.schemaContext.findModule(qname.getModule()).orElse(null);
    }

    private String leafrefToDef(LeafSchemaNode parentNode, LeafrefTypeDefinition leafrefType, String defaultValue) {
        Preconditions.checkArgument((leafrefType != null ? 1 : 0) != 0, (Object)"Leafref Type Definition reference cannot be NULL!");
        Preconditions.checkArgument((leafrefType.getPathStatement() != null ? 1 : 0) != 0, (Object)"The Path Statement for Leafref Type Definition cannot be NULL!");
        RevisionAwareXPath xpath = leafrefType.getPathStatement();
        String strXPath = xpath.toString();
        if (strXPath != null) {
            if (strXPath.indexOf(91) == -1) {
                Module module = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode);
                if (module != null) {
                    SchemaNode dataNode = xpath.isAbsolute() ? SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (Module)module, (RevisionAwareXPath)xpath) : SchemaContextUtil.findDataSchemaNodeForRelativeXPath((SchemaContext)this.schemaContext, (Module)module, (SchemaNode)parentNode, (RevisionAwareXPath)xpath);
                    String result = this.getTypeDefaultConstruction((LeafSchemaNode)dataNode, defaultValue);
                    return result;
                }
            } else {
                return "new java.lang.Object()";
            }
        }
        return null;
    }

    private String unionToDef(LeafSchemaNode node) {
        String className;
        TypeDefinition type = CompatUtils.compatLeafType((LeafSchemaNode)node);
        if (type.getBaseType() != null) {
            QName typeQName = type.getQName();
            Module module = null;
            Set modules = this.schemaContext.findModules(typeQName.getNamespace());
            if (modules.size() > 1) {
                for (Module m : modules) {
                    if (!m.getRevision().equals(typeQName.getRevision())) continue;
                    module = m;
                    break;
                }
                if (module == null) {
                    ArrayList modulesList = new ArrayList(modules);
                    modulesList.sort((o1, o2) -> Revision.compare((Optional)o1.getRevision(), (Optional)o2.getRevision()));
                    module = (Module)modulesList.get(0);
                }
            } else {
                module = (Module)modules.iterator().next();
            }
            String basePackageName = BindingMapping.getRootPackageName((QNameModule)module.getQNameModule());
            className = basePackageName + "." + BindingMapping.getClassName((QName)typeQName);
        } else {
            Iterator path = node.getPath().getPathFromRoot().iterator();
            QName first = (QName)path.next();
            Module parent = this.schemaContext.findModule(first.getModule()).orElse(null);
            String basePackageName = BindingMapping.getRootPackageName((QNameModule)parent.getQNameModule());
            if (!path.hasNext()) {
                String parentName = BindingMapping.getClassName((String)parent.getName()) + "Data";
                className = basePackageName + "." + parentName + "." + BindingMapping.getClassName((QName)node.getQName());
            } else {
                String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)UNION_PATH);
                className = packageName + "." + BindingMapping.getClassName((QName)node.getQName());
            }
        }
        return AbstractTypeProvider.union(className, node.getType().getDefaultValue().orElse(null), node);
    }

    private static String union(String className, String defaultValue, LeafSchemaNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        sb.append(className);
        sb.append("(\"");
        sb.append(defaultValue);
        sb.append("\".toCharArray())");
        return sb.toString();
    }

    public String getConstructorPropertyName(SchemaNode node) {
        return node instanceof TypeDefinition ? "value" : "";
    }

    public String getParamNameFromType(TypeDefinition<?> type) {
        return BindingMapping.getPropertyName((String)type.getQName().getLocalName());
    }
}

