/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.yang.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

final class TypedefResolver {
    private TypedefResolver() {
        throw new UnsupportedOperationException();
    }

    static List<TypeDefinition<?>> getAllTypedefs(Module module) {
        ArrayList ret = new ArrayList();
        TypedefResolver.fillRecursively(ret, (DataNodeContainer)module);
        Set notifications = module.getNotifications();
        for (NotificationDefinition notificationDefinition : notifications) {
            TypedefResolver.fillRecursively(ret, (DataNodeContainer)notificationDefinition);
        }
        Set rpcs = module.getRpcs();
        for (RpcDefinition rpcDefinition : rpcs) {
            ret.addAll(rpcDefinition.getTypeDefinitions());
            TypedefResolver.fillRecursively(ret, (DataNodeContainer)rpcDefinition.getInput());
            TypedefResolver.fillRecursively(ret, (DataNodeContainer)rpcDefinition.getOutput());
        }
        return ret;
    }

    private static void fillRecursively(List<TypeDefinition<?>> list, DataNodeContainer container) {
        Collection childNodes = container.getChildNodes();
        if (childNodes != null) {
            for (DataSchemaNode childNode : childNodes) {
                if (childNode.isAugmenting()) continue;
                if (childNode instanceof ContainerSchemaNode) {
                    TypedefResolver.fillRecursively(list, (DataNodeContainer)((ContainerSchemaNode)childNode));
                    continue;
                }
                if (childNode instanceof ListSchemaNode) {
                    TypedefResolver.fillRecursively(list, (DataNodeContainer)((ListSchemaNode)childNode));
                    continue;
                }
                if (!(childNode instanceof ChoiceSchemaNode)) continue;
                for (CaseSchemaNode caseNode : ((ChoiceSchemaNode)childNode).getCases().values()) {
                    TypedefResolver.fillRecursively(list, (DataNodeContainer)caseNode);
                }
            }
        }
        list.addAll(container.getTypeDefinitions());
        Set groupings = container.getGroupings();
        if (groupings != null) {
            for (GroupingDefinition grouping : groupings) {
                TypedefResolver.fillRecursively(list, (DataNodeContainer)grouping);
            }
        }
    }
}

