/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.datastore.h2;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.opendaylight.aaa.datastore.h2.IdmLightConfig;

@ParametersAreNonnullByDefault
@Generated(from="IdmLightConfig", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
public final class IdmLightConfigBuilder {
    private static final long INIT_BIT_DB_USER = 1L;
    private static final long INIT_BIT_DB_PWD = 2L;
    private static final long OPT_BIT_DB_NAME = 1L;
    private static final long OPT_BIT_DB_DIRECTORY = 2L;
    private static final long OPT_BIT_DB_DRIVER = 4L;
    private static final long OPT_BIT_DB_VALID_TIME_OUT = 8L;
    private static final long OPT_BIT_DB_CONNECTION_STRING_PREFIX = 16L;
    private static final long OPT_BIT_DB_CONNECTION_STRING = 32L;
    private long initBits = 3L;
    private long optBits;
    @Nullable
    private String dbName;
    @Nullable
    private String dbDirectory;
    @Nullable
    private String dbDriver;
    @Nullable
    private String dbUser;
    @Nullable
    private String dbPwd;
    private int dbValidTimeOut;
    @Nullable
    private String dbConnectionStringPrefix;
    @Nullable
    private String dbConnectionString;

    @CanIgnoreReturnValue
    public final IdmLightConfigBuilder dbName(String dbName) {
        IdmLightConfigBuilder.checkNotIsSet(this.dbNameIsSet(), "dbName");
        this.dbName = Objects.requireNonNull(dbName, "dbName");
        this.optBits |= 1L;
        return this;
    }

    @CanIgnoreReturnValue
    public final IdmLightConfigBuilder dbDirectory(String dbDirectory) {
        IdmLightConfigBuilder.checkNotIsSet(this.dbDirectoryIsSet(), "dbDirectory");
        this.dbDirectory = Objects.requireNonNull(dbDirectory, "dbDirectory");
        this.optBits |= 2L;
        return this;
    }

    @CanIgnoreReturnValue
    public final IdmLightConfigBuilder dbDriver(String dbDriver) {
        IdmLightConfigBuilder.checkNotIsSet(this.dbDriverIsSet(), "dbDriver");
        this.dbDriver = Objects.requireNonNull(dbDriver, "dbDriver");
        this.optBits |= 4L;
        return this;
    }

    @CanIgnoreReturnValue
    public final IdmLightConfigBuilder dbUser(String dbUser) {
        IdmLightConfigBuilder.checkNotIsSet(this.dbUserIsSet(), "dbUser");
        this.dbUser = Objects.requireNonNull(dbUser, "dbUser");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    @CanIgnoreReturnValue
    public final IdmLightConfigBuilder dbPwd(String dbPwd) {
        IdmLightConfigBuilder.checkNotIsSet(this.dbPwdIsSet(), "dbPwd");
        this.dbPwd = Objects.requireNonNull(dbPwd, "dbPwd");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    @CanIgnoreReturnValue
    public final IdmLightConfigBuilder dbValidTimeOut(int dbValidTimeOut) {
        IdmLightConfigBuilder.checkNotIsSet(this.dbValidTimeOutIsSet(), "dbValidTimeOut");
        this.dbValidTimeOut = dbValidTimeOut;
        this.optBits |= 8L;
        return this;
    }

    @CanIgnoreReturnValue
    public final IdmLightConfigBuilder dbConnectionStringPrefix(String dbConnectionStringPrefix) {
        IdmLightConfigBuilder.checkNotIsSet(this.dbConnectionStringPrefixIsSet(), "dbConnectionStringPrefix");
        this.dbConnectionStringPrefix = Objects.requireNonNull(dbConnectionStringPrefix, "dbConnectionStringPrefix");
        this.optBits |= 0x10L;
        return this;
    }

    @CanIgnoreReturnValue
    public final IdmLightConfigBuilder dbConnectionString(String dbConnectionString) {
        IdmLightConfigBuilder.checkNotIsSet(this.dbConnectionStringIsSet(), "dbConnectionString");
        this.dbConnectionString = Objects.requireNonNull(dbConnectionString, "dbConnectionString");
        this.optBits |= 0x20L;
        return this;
    }

    public IdmLightConfig build() {
        this.checkRequiredAttributes();
        return new IdmLightConfigImpl(this);
    }

    private boolean dbNameIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    private boolean dbDirectoryIsSet() {
        return (this.optBits & 2L) != 0L;
    }

    private boolean dbDriverIsSet() {
        return (this.optBits & 4L) != 0L;
    }

    private boolean dbValidTimeOutIsSet() {
        return (this.optBits & 8L) != 0L;
    }

    private boolean dbConnectionStringPrefixIsSet() {
        return (this.optBits & 0x10L) != 0L;
    }

    private boolean dbConnectionStringIsSet() {
        return (this.optBits & 0x20L) != 0L;
    }

    private boolean dbUserIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean dbPwdIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
        if (isSet) {
            throw new IllegalStateException("Builder of IdmLightConfig is strict, attribute is already set: ".concat(name));
        }
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.dbUserIsSet()) {
            attributes.add("dbUser");
        }
        if (!this.dbPwdIsSet()) {
            attributes.add("dbPwd");
        }
        return "Cannot build IdmLightConfig, some of required attributes are not set " + attributes;
    }

    @CheckReturnValue
    @Generated(from="IdmLightConfig", generator="Immutables")
    @Immutable
    private static final class IdmLightConfigImpl
    extends IdmLightConfig {
        private final String dbName;
        private final String dbDirectory;
        private final String dbDriver;
        private final String dbUser;
        private final String dbPwd;
        private final int dbValidTimeOut;
        private final String dbConnectionStringPrefix;
        private final String dbConnectionString;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private IdmLightConfigImpl(IdmLightConfigBuilder builder) {
            this.dbUser = builder.dbUser;
            this.dbPwd = builder.dbPwd;
            if (builder.dbNameIsSet()) {
                this.initShim.dbName(builder.dbName);
            }
            if (builder.dbDirectoryIsSet()) {
                this.initShim.dbDirectory(builder.dbDirectory);
            }
            if (builder.dbDriverIsSet()) {
                this.initShim.dbDriver(builder.dbDriver);
            }
            if (builder.dbValidTimeOutIsSet()) {
                this.initShim.dbValidTimeOut(builder.dbValidTimeOut);
            }
            if (builder.dbConnectionStringPrefixIsSet()) {
                this.initShim.dbConnectionStringPrefix(builder.dbConnectionStringPrefix);
            }
            if (builder.dbConnectionStringIsSet()) {
                this.initShim.dbConnectionString(builder.dbConnectionString);
            }
            this.dbName = this.initShim.getDbName();
            this.dbDirectory = this.initShim.getDbDirectory();
            this.dbDriver = this.initShim.getDbDriver();
            this.dbValidTimeOut = this.initShim.getDbValidTimeOut();
            this.dbConnectionStringPrefix = this.initShim.getDbConnectionStringPrefix();
            this.dbConnectionString = this.initShim.getDbConnectionString();
            this.initShim = null;
        }

        @Override
        public String getDbName() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getDbName() : this.dbName;
        }

        @Override
        public String getDbDirectory() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getDbDirectory() : this.dbDirectory;
        }

        @Override
        public String getDbDriver() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getDbDriver() : this.dbDriver;
        }

        @Override
        public String getDbUser() {
            return this.dbUser;
        }

        @Override
        public String getDbPwd() {
            return this.dbPwd;
        }

        @Override
        public int getDbValidTimeOut() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getDbValidTimeOut() : this.dbValidTimeOut;
        }

        @Override
        public String getDbConnectionStringPrefix() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getDbConnectionStringPrefix() : this.dbConnectionStringPrefix;
        }

        @Override
        public String getDbConnectionString() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getDbConnectionString() : this.dbConnectionString;
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IdmLightConfigImpl && this.equalTo((IdmLightConfigImpl)another);
        }

        private boolean equalTo(IdmLightConfigImpl another) {
            return this.dbName.equals(another.dbName) && this.dbDirectory.equals(another.dbDirectory) && this.dbDriver.equals(another.dbDriver) && this.dbUser.equals(another.dbUser) && this.dbPwd.equals(another.dbPwd) && this.dbValidTimeOut == another.dbValidTimeOut && this.dbConnectionStringPrefix.equals(another.dbConnectionStringPrefix) && this.dbConnectionString.equals(another.dbConnectionString);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.dbName.hashCode();
            h += (h << 5) + this.dbDirectory.hashCode();
            h += (h << 5) + this.dbDriver.hashCode();
            h += (h << 5) + this.dbUser.hashCode();
            h += (h << 5) + this.dbPwd.hashCode();
            h += (h << 5) + this.dbValidTimeOut;
            h += (h << 5) + this.dbConnectionStringPrefix.hashCode();
            h += (h << 5) + this.dbConnectionString.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"IdmLightConfig").omitNullValues().add("dbName", (Object)this.dbName).add("dbDirectory", (Object)this.dbDirectory).add("dbDriver", (Object)this.dbDriver).add("dbUser", (Object)this.dbUser).add("dbPwd", (Object)this.dbPwd).add("dbValidTimeOut", this.dbValidTimeOut).add("dbConnectionStringPrefix", (Object)this.dbConnectionStringPrefix).add("dbConnectionString", (Object)this.dbConnectionString).toString();
        }

        @Generated(from="IdmLightConfig", generator="Immutables")
        private final class InitShim {
            private byte dbNameBuildStage = 0;
            private String dbName;
            private byte dbDirectoryBuildStage = 0;
            private String dbDirectory;
            private byte dbDriverBuildStage = 0;
            private String dbDriver;
            private byte dbValidTimeOutBuildStage = 0;
            private int dbValidTimeOut;
            private byte dbConnectionStringPrefixBuildStage = 0;
            private String dbConnectionStringPrefix;
            private byte dbConnectionStringBuildStage = 0;
            private String dbConnectionString;

            private InitShim() {
            }

            String getDbName() {
                if (this.dbNameBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.dbNameBuildStage == 0) {
                    this.dbNameBuildStage = (byte)-1;
                    this.dbName = Objects.requireNonNull(IdmLightConfigImpl.super.getDbName(), "dbName");
                    this.dbNameBuildStage = 1;
                }
                return this.dbName;
            }

            void dbName(String dbName) {
                this.dbName = dbName;
                this.dbNameBuildStage = 1;
            }

            String getDbDirectory() {
                if (this.dbDirectoryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.dbDirectoryBuildStage == 0) {
                    this.dbDirectoryBuildStage = (byte)-1;
                    this.dbDirectory = Objects.requireNonNull(IdmLightConfigImpl.super.getDbDirectory(), "dbDirectory");
                    this.dbDirectoryBuildStage = 1;
                }
                return this.dbDirectory;
            }

            void dbDirectory(String dbDirectory) {
                this.dbDirectory = dbDirectory;
                this.dbDirectoryBuildStage = 1;
            }

            String getDbDriver() {
                if (this.dbDriverBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.dbDriverBuildStage == 0) {
                    this.dbDriverBuildStage = (byte)-1;
                    this.dbDriver = Objects.requireNonNull(IdmLightConfigImpl.super.getDbDriver(), "dbDriver");
                    this.dbDriverBuildStage = 1;
                }
                return this.dbDriver;
            }

            void dbDriver(String dbDriver) {
                this.dbDriver = dbDriver;
                this.dbDriverBuildStage = 1;
            }

            int getDbValidTimeOut() {
                if (this.dbValidTimeOutBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.dbValidTimeOutBuildStage == 0) {
                    this.dbValidTimeOutBuildStage = (byte)-1;
                    this.dbValidTimeOut = IdmLightConfigImpl.super.getDbValidTimeOut();
                    this.dbValidTimeOutBuildStage = 1;
                }
                return this.dbValidTimeOut;
            }

            void dbValidTimeOut(int dbValidTimeOut) {
                this.dbValidTimeOut = dbValidTimeOut;
                this.dbValidTimeOutBuildStage = 1;
            }

            String getDbConnectionStringPrefix() {
                if (this.dbConnectionStringPrefixBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.dbConnectionStringPrefixBuildStage == 0) {
                    this.dbConnectionStringPrefixBuildStage = (byte)-1;
                    this.dbConnectionStringPrefix = Objects.requireNonNull(IdmLightConfigImpl.super.getDbConnectionStringPrefix(), "dbConnectionStringPrefix");
                    this.dbConnectionStringPrefixBuildStage = 1;
                }
                return this.dbConnectionStringPrefix;
            }

            void dbConnectionStringPrefix(String dbConnectionStringPrefix) {
                this.dbConnectionStringPrefix = dbConnectionStringPrefix;
                this.dbConnectionStringPrefixBuildStage = 1;
            }

            String getDbConnectionString() {
                if (this.dbConnectionStringBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.dbConnectionStringBuildStage == 0) {
                    this.dbConnectionStringBuildStage = (byte)-1;
                    this.dbConnectionString = Objects.requireNonNull(IdmLightConfigImpl.super.getDbConnectionString(), "dbConnectionString");
                    this.dbConnectionStringBuildStage = 1;
                }
                return this.dbConnectionString;
            }

            void dbConnectionString(String dbConnectionString) {
                this.dbConnectionString = dbConnectionString;
                this.dbConnectionStringBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.dbNameBuildStage == -1) {
                    attributes.add("dbName");
                }
                if (this.dbDirectoryBuildStage == -1) {
                    attributes.add("dbDirectory");
                }
                if (this.dbDriverBuildStage == -1) {
                    attributes.add("dbDriver");
                }
                if (this.dbValidTimeOutBuildStage == -1) {
                    attributes.add("dbValidTimeOut");
                }
                if (this.dbConnectionStringPrefixBuildStage == -1) {
                    attributes.add("dbConnectionStringPrefix");
                }
                if (this.dbConnectionStringBuildStage == -1) {
                    attributes.add("dbConnectionString");
                }
                return "Cannot build IdmLightConfig, attribute initializers form cycle " + attributes;
            }
        }
    }
}

