/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.moon;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Set;
import org.opendaylight.aaa.api.Claim;

public class MoonPrincipal {
    private final String username;
    private final String domain;
    private final String userId;
    private final ImmutableSet<String> roles;
    private final String token;

    public MoonPrincipal(String username, String domain, String userId, Set<String> roles, String token) {
        this.username = username;
        this.domain = domain;
        this.userId = userId;
        this.roles = ImmutableSet.copyOf(roles);
        this.token = token;
    }

    public MoonPrincipal createODLPrincipal(String userName, String theDomain, String theUserId, Set<String> theRoles, String theToken) {
        return new MoonPrincipal(userName, theDomain, theUserId, theRoles, theToken);
    }

    public Claim principalToClaim() {
        return new MoonClaim("", this.getUserId(), this.getUsername(), this.getDomain(), this.getRoles());
    }

    public String getUsername() {
        return this.username;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUserId() {
        return this.userId;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public String getToken() {
        return this.token;
    }

    private static class MoonClaim
    implements Claim,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String clientId;
        private final String userId;
        private final String user;
        private final String domain;
        private final ImmutableSet<String> roles;

        MoonClaim(String clientId, String userId, String user, String domain, Set<String> roles) {
            this.clientId = clientId;
            this.userId = userId;
            this.user = user;
            this.domain = domain;
            this.roles = ImmutableSet.copyOf(roles);
            if (userId.isEmpty() || user.isEmpty() || roles.isEmpty() || roles.contains("")) {
                throw new IllegalStateException("The Claim is missing one or more of the required fields.");
            }
        }

        public String clientId() {
            return this.clientId;
        }

        public String userId() {
            return this.userId;
        }

        public String user() {
            return this.user;
        }

        public String domain() {
            return this.domain;
        }

        public Set<String> roles() {
            return this.roles;
        }

        public String toString() {
            return "clientId:" + this.clientId + ",userId:" + this.userId + ",userName:" + this.user + ",domain:" + this.domain + ",roles:" + this.roles;
        }
    }
}

