/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.principal;

import java.util.Set;
import org.opendaylight.aaa.api.Authentication;
import org.opendaylight.aaa.api.shiro.principal.ODLPrincipal;

public final class ODLPrincipalImpl
implements ODLPrincipal {
    private final String username;
    private final String domain;
    private final String userId;
    private final Set<String> roles;

    private ODLPrincipalImpl(String username, String domain, String userId, Set<String> roles) {
        this.username = username;
        this.domain = domain;
        this.userId = userId;
        this.roles = roles;
    }

    public static ODLPrincipal createODLPrincipal(Authentication auth) {
        return ODLPrincipalImpl.createODLPrincipal(auth.user(), auth.domain(), auth.userId(), auth.roles());
    }

    public static ODLPrincipal createODLPrincipal(String username, String domain, String userId, Set<String> roles) {
        return new ODLPrincipalImpl(username, domain, userId, roles);
    }

    public static ODLPrincipal createODLPrincipal(String username, String domain, String userId) {
        return ODLPrincipalImpl.createODLPrincipal(username, domain, userId, null);
    }

    public String getUsername() {
        return this.username;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUserId() {
        return this.userId;
    }

    public Set<String> getRoles() {
        return this.roles;
    }
}

