/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.opendaylight.aaa.api.shiro.principal.ODLPrincipal;
import org.opendaylight.aaa.cert.api.ICertificateManager;
import org.opendaylight.aaa.provider.GsonProvider;
import org.opendaylight.aaa.shiro.keystone.domain.KeystoneAuth;
import org.opendaylight.aaa.shiro.keystone.domain.KeystoneToken;
import org.opendaylight.aaa.shiro.principal.ODLPrincipalImpl;
import org.opendaylight.aaa.shiro.realm.util.http.SimpleHttpClient;
import org.opendaylight.aaa.shiro.realm.util.http.SimpleHttpRequest;
import org.opendaylight.aaa.shiro.realm.util.http.UntrustedSSL;
import org.opendaylight.aaa.shiro.web.env.ThreadLocals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoneAuthRealm
extends AuthorizingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(KeystoneAuthRealm.class);
    private static final String NO_CATALOG_OPTION = "nocatalog";
    private static final String DEFAULT_KEYSTONE_DOMAIN = "Default";
    private static final String USERNAME_DOMAIN_SEPARATOR = "@";
    private static final String FATAL_ERROR_BASIC_AUTH_ONLY = "{\"error\":\"Only basic authentication is supported\"}";
    private static final String FATAL_ERROR_INVALID_URL = "{\"error\":\"Invalid URL to Keystone server\"}";
    private static final String UNABLE_TO_AUTHENTICATE = "{\"error\":\"Could not authenticate\"}";
    private static final String AUTH_PATH = "v3/auth/tokens";
    private static final int CLIENT_EXPIRE_AFTER_ACCESS = 1;
    private static final int CLIENT_EXPIRE_AFTER_WRITE = 10;
    private volatile URI serverUri = null;
    private volatile boolean sslVerification = true;
    private volatile String defaultDomain = "Default";
    private final LoadingCache<Boolean, SimpleHttpClient> clientCache = this.buildCache();
    private final ICertificateManager certManager = Objects.requireNonNull(ThreadLocals.CERT_MANAGER_TL.get());

    public KeystoneAuthRealm() {
        LOG.info("KeystoneAuthRealm created");
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        Object primaryPrincipal = this.getAvailablePrincipal(principalCollection);
        try {
            ODLPrincipal odlPrincipal = (ODLPrincipal)primaryPrincipal;
            return new SimpleAuthorizationInfo(odlPrincipal.getRoles());
        }
        catch (ClassCastException e) {
            LOG.error("Couldn't decode authorization request", (Throwable)e);
            return new SimpleAuthorizationInfo();
        }
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) {
        try {
            boolean hasSslVerification = this.getSslVerification();
            SimpleHttpClient client = (SimpleHttpClient)this.clientCache.getUnchecked((Object)hasSslVerification);
            return this.doGetAuthenticationInfo(authenticationToken, client);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (!Objects.isNull(cause) && cause instanceof AuthenticationException) {
                throw (AuthenticationException)cause;
            }
            throw e;
        }
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken, SimpleHttpClient client) {
        KeystoneToken theToken;
        URI theServerUri = this.getServerUri();
        String theDefaultDomain = this.getDefaultDomain();
        if (!(authenticationToken instanceof UsernamePasswordToken)) {
            LOG.error("Only basic authentication is supported");
            throw new AuthenticationException(FATAL_ERROR_BASIC_AUTH_ONLY);
        }
        if (Objects.isNull(theServerUri)) {
            LOG.error("Invalid URL to Keystone server");
            throw new AuthenticationException(FATAL_ERROR_INVALID_URL);
        }
        UsernamePasswordToken usernamePasswordToken = (UsernamePasswordToken)authenticationToken;
        String qualifiedUser = usernamePasswordToken.getUsername();
        String password = new String(usernamePasswordToken.getPassword());
        String[] qualifiedUserArray = qualifiedUser.split(USERNAME_DOMAIN_SEPARATOR, 2);
        String username = qualifiedUserArray.length > 0 ? qualifiedUserArray[0] : qualifiedUser;
        String domain = qualifiedUserArray.length > 1 ? qualifiedUserArray[1] : theDefaultDomain;
        KeystoneAuth keystoneAuth = new KeystoneAuth(username, password, domain);
        SimpleHttpRequest<KeystoneToken> httpRequest = client.requestBuilder(KeystoneToken.class).uri(theServerUri).path(AUTH_PATH).method("POST").mediaType(MediaType.APPLICATION_JSON_TYPE).entity(keystoneAuth).queryParam(NO_CATALOG_OPTION, "").build();
        try {
            theToken = httpRequest.execute();
        }
        catch (WebApplicationException e) {
            LOG.debug("Unable to authenticate - Keystone result code: {}", (Object)e.getResponse().getStatus(), (Object)e);
            return null;
        }
        Set<String> theRoles = theToken.getToken().getRoles().stream().map(KeystoneToken.Token.Role::getName).collect(Collectors.toSet());
        String userId = username + USERNAME_DOMAIN_SEPARATOR + domain;
        ODLPrincipal odlPrincipal = ODLPrincipalImpl.createODLPrincipal(username, domain, userId, theRoles);
        return new SimpleAuthenticationInfo((Object)odlPrincipal, (Object)password.toCharArray(), this.getName());
    }

    protected LoadingCache<Boolean, SimpleHttpClient> buildCache() {
        return CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.SECONDS).expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Boolean, SimpleHttpClient>(){

            public SimpleHttpClient load(Boolean withSslVerification) throws Exception {
                return KeystoneAuthRealm.this.buildClient(withSslVerification, KeystoneAuthRealm.this.certManager, SimpleHttpClient.clientBuilder());
            }
        });
    }

    protected SimpleHttpClient buildClient(boolean withSslVerification, ICertificateManager certificateManager, SimpleHttpClient.Builder clientBuilder) {
        HostnameVerifier hostnameVerifier;
        SSLContext sslContext;
        if (withSslVerification) {
            sslContext = this.getSecureSSLContext(certificateManager);
            hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        } else {
            sslContext = UntrustedSSL.getSSLContext();
            hostnameVerifier = UntrustedSSL.getHostnameVerifier();
        }
        return clientBuilder.hostnameVerifier(hostnameVerifier).sslContext(sslContext).provider(GsonProvider.class).build();
    }

    private SSLContext getSecureSSLContext(ICertificateManager certificateManager) {
        SSLContext sslContext = Optional.ofNullable(certificateManager).map(ICertificateManager::getServerContext).orElse(null);
        if (Objects.isNull(sslContext)) {
            LOG.error("Could not get a valid SSL context from certificate manager");
            throw new AuthenticationException(UNABLE_TO_AUTHENTICATE);
        }
        return sslContext;
    }

    public URI getServerUri() {
        return this.serverUri;
    }

    public boolean getSslVerification() {
        return this.sslVerification;
    }

    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    public void setUrl(String url) {
        try {
            this.serverUri = new URL(url).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOG.error("The keystone server URL {} could not be correctly parsed", (Object)url, (Object)e);
            this.serverUri = null;
        }
    }

    public void setSslVerification(boolean sslVerification) {
        this.sslVerification = sslVerification;
    }

    public void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }
}

