/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.Destroyable;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.api.shiro.principal.ODLPrincipal;
import org.opendaylight.aaa.shiro.principal.ODLPrincipalImpl;
import org.opendaylight.aaa.shiro.realm.util.TokenUtils;
import org.opendaylight.aaa.shiro.realm.util.http.header.HeaderUtils;
import org.opendaylight.aaa.shiro.web.env.ThreadLocals;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.Authentication;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.Grant;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.Grants;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.Users;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.roles.Roles;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsalRealm
extends AuthorizingRealm
implements Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(MdsalRealm.class);
    private static final DataTreeIdentifier<Authentication> AUTH_TREE_ID = DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)InstanceIdentifier.create(Authentication.class));
    private final PasswordHashService passwordHashService = Objects.requireNonNull(ThreadLocals.PASSWORD_HASH_SERVICE_TL.get());
    private final ListenerRegistration<?> reg;
    private volatile ListenableFuture<Optional<Authentication>> authentication;

    public MdsalRealm() {
        DataBroker dataBroker = Objects.requireNonNull(ThreadLocals.DATABROKER_TL.get());
        try (ReadTransaction tx = dataBroker.newReadOnlyTransaction();){
            this.authentication = tx.read(AUTH_TREE_ID.getDatastoreType(), AUTH_TREE_ID.getRootIdentifier());
        }
        this.reg = dataBroker.registerDataTreeChangeListener(AUTH_TREE_ID, (DataTreeChangeListener)((ClusteredDataTreeChangeListener)this::onAuthenticationChanged));
        LOG.info("MdsalRealm created");
    }

    private void onAuthenticationChanged(Collection<DataTreeModification<Authentication>> changes) {
        Authentication newVal = (Authentication)((DataTreeModification)Iterables.getLast(changes)).getRootNode().getDataAfter();
        LOG.debug("Updating authentication information to {}", (Object)newVal);
        this.authentication = Futures.immediateFuture(Optional.ofNullable(newVal));
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        HashSet authRoles = Sets.newHashSet();
        ODLPrincipal odlPrincipal = (ODLPrincipal)principalCollection.getPrimaryPrincipal();
        Optional<Authentication> opt = this.getAuthenticationContainer();
        if (opt.isPresent()) {
            Authentication auth = opt.get();
            Grants grants = auth.getGrants();
            List grantsList = grants.getGrants();
            for (Grant grant : grantsList) {
                org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.Roles roles;
                if (!grant.getUserid().equals(odlPrincipal.getUserId()) || (roles = auth.getRoles()) == null) continue;
                List rolesList = roles.getRoles();
                for (Roles role : rolesList) {
                    if (!role.getRoleid().equals(grant.getRoleid())) continue;
                    authRoles.add(role.getRoleid());
                }
            }
        }
        return new SimpleAuthorizationInfo((Set)authRoles);
    }

    private Optional<Authentication> getAuthenticationContainer() {
        try {
            return (Optional)this.authentication.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Couldn't access authentication container", (Throwable)e);
            return Optional.empty();
        }
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        String username = TokenUtils.extractUsername(authenticationToken);
        Optional<Authentication> opt = this.getAuthenticationContainer();
        if (opt.isPresent()) {
            Authentication auth = opt.get();
            Users users = auth.getUsers();
            List usersList = users.getUsers();
            for (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.users.Users u : usersList) {
                String inputPassword;
                String inputUsername = HeaderUtils.extractUsername(username);
                String domainId = HeaderUtils.extractDomain(username);
                String inputUserId = String.format("%s@%s", inputUsername, domainId);
                boolean userEnabled = u.isEnabled();
                if (!userEnabled) {
                    LOG.trace("userId={} is skipped because it is disabled", (Object)u.getUserid());
                }
                if (!userEnabled || !u.getUserid().equals(inputUserId) || !this.passwordHashService.passwordsMatch(inputPassword = TokenUtils.extractPassword(authenticationToken), u.getPassword(), u.getSalt())) continue;
                ODLPrincipal odlPrincipal = ODLPrincipalImpl.createODLPrincipal(inputUsername, domainId, inputUserId);
                return new SimpleAuthenticationInfo((Object)odlPrincipal, (Object)inputPassword, this.getName());
            }
        }
        LOG.debug("Couldn't access the authentication container");
        throw new AuthenticationException(String.format("Couldn't authenticate %s", username));
    }

    public void destroy() {
        this.reg.close();
    }
}

