/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.realm.ldap.DefaultLdapRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODLJndiLdapRealmAuthNOnly
extends DefaultLdapRealm {
    private static final Logger LOG = LoggerFactory.getLogger(ODLJndiLdapRealmAuthNOnly.class);

    public ODLJndiLdapRealmAuthNOnly() {
        LOG.info("ODLJndiLdapRealmAuthNOnly realm created");
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        try {
            String username = ODLJndiLdapRealmAuthNOnly.getUsername(token);
            this.logIncomingConnection(username);
            return super.doGetAuthenticationInfo(token);
        }
        catch (ClassCastException e) {
            LOG.info("Couldn't service the LDAP connection", (Throwable)e);
            return null;
        }
    }

    protected void logIncomingConnection(String username) {
        LOG.info("AAA LDAP connection from {}", (Object)username);
    }

    public static String getUsername(AuthenticationToken token) throws ClassCastException {
        if (null == token) {
            return null;
        }
        return (String)token.getPrincipal();
    }
}

