/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.opendaylight.aaa.api.Authentication;
import org.opendaylight.aaa.api.AuthenticationService;
import org.opendaylight.aaa.api.TokenAuth;
import org.opendaylight.aaa.api.TokenStore;
import org.opendaylight.aaa.api.shiro.principal.ODLPrincipal;
import org.opendaylight.aaa.shiro.principal.ODLPrincipalImpl;
import org.opendaylight.aaa.shiro.realm.util.TokenUtils;
import org.opendaylight.aaa.shiro.realm.util.http.header.HeaderUtils;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.TokenAuthenticators;
import org.opendaylight.aaa.shiro.web.env.ThreadLocals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuthRealm
extends AuthorizingRealm {
    private static final String TOKEN_AUTH_REALM_DEFAULT_NAME = "TokenAuthRealm";
    private static final String AUTHENTICATION_SERVICE_UNAVAILABLE_MESSAGE = "{\"error\":\"Authentication service unavailable\"}";
    private static final String FATAL_ERROR_DECODING_CREDENTIALS = "{\"error\":\"Unable to decode credentials\"}";
    private static final String FATAL_ERROR_BASIC_AUTH_ONLY = "{\"error\":\"Only basic authentication is supported by TokenAuthRealm\"}";
    private static final String UNABLE_TO_AUTHENTICATE = "{\"error\":\"Could not authenticate\"}";
    private static final Logger LOG = LoggerFactory.getLogger(TokenAuthRealm.class);
    private final AuthenticationService authenticationService = Objects.requireNonNull(ThreadLocals.AUTH_SETVICE_TL.get());
    private final TokenStore tokenStore = ThreadLocals.TOKEN_STORE_TL.get();
    private final TokenAuthenticators tokenAuthenticators = Objects.requireNonNull(ThreadLocals.TOKEN_AUTHENICATORS_TL.get());

    public TokenAuthRealm() {
        super.setName(TOKEN_AUTH_REALM_DEFAULT_NAME);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        Object primaryPrincipal = principalCollection.getPrimaryPrincipal();
        try {
            ODLPrincipal odlPrincipal = (ODLPrincipal)primaryPrincipal;
            return new SimpleAuthorizationInfo(odlPrincipal.getRoles());
        }
        catch (ClassCastException e) {
            LOG.error("Couldn't decode authorization request", (Throwable)e);
            return new SimpleAuthorizationInfo();
        }
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        String password;
        String domain;
        String username;
        try {
            String possiblyQualifiedUser = TokenUtils.extractUsername(authenticationToken);
            username = HeaderUtils.extractUsername(possiblyQualifiedUser);
            domain = HeaderUtils.extractDomain(possiblyQualifiedUser);
            password = TokenUtils.extractPassword(authenticationToken);
        }
        catch (NullPointerException e) {
            throw new AuthenticationException(FATAL_ERROR_DECODING_CREDENTIALS, (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new AuthenticationException(FATAL_ERROR_BASIC_AUTH_ONLY, (Throwable)e);
        }
        if (!Strings.isNullOrEmpty((String)password)) {
            Map<String, List<String>> headers = HeaderUtils.formHeaders(username, password, domain);
            for (TokenAuth ta : this.tokenAuthenticators.getTokenAuthCollection()) {
                try {
                    LOG.debug("Authentication attempt using {}", (Object)ta.getClass().getName());
                    Authentication auth = ta.validate(headers);
                    if (auth == null) continue;
                    LOG.debug("Authentication attempt successful");
                    this.authenticationService.set(auth);
                    ODLPrincipal odlPrincipal = ODLPrincipalImpl.createODLPrincipal(auth);
                    return new SimpleAuthenticationInfo((Object)odlPrincipal, (Object)password.toCharArray(), this.getName());
                }
                catch (AuthenticationException ae) {
                    LOG.debug("Authentication attempt unsuccessful");
                    throw new AuthenticationException(UNABLE_TO_AUTHENTICATE, (Throwable)ae);
                }
            }
        }
        String token = TokenUtils.extractUsername(authenticationToken);
        try {
            Authentication auth = this.validate(token);
            ODLPrincipal odlPrincipal = ODLPrincipalImpl.createODLPrincipal(auth);
            return new SimpleAuthenticationInfo((Object)odlPrincipal, (Object)"", this.getName());
        }
        catch (AuthenticationException e) {
            LOG.debug("Unknown OAuth2 Token Access Request", (Throwable)e);
            LOG.debug("Authentication failed: exhausted TokenAuth resources");
            return null;
        }
    }

    private Authentication validate(String token) {
        if (this.tokenStore == null) {
            throw new AuthenticationException("Token store not available, could not validate the token " + token);
        }
        Authentication auth = this.tokenStore.get(token);
        if (auth == null) {
            throw new AuthenticationException("Could not validate the token " + token);
        }
        this.authenticationService.set(auth);
        return auth;
    }
}

