/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm.mapping.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.opendaylight.aaa.shiro.realm.mapping.api.GroupsToRolesMappingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestAttemptGroupToRolesMappingStrategy
implements GroupsToRolesMappingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(BestAttemptGroupToRolesMappingStrategy.class);

    @Override
    public Map<String, Set<String>> mapGroupsToRoles(Collection<String> groupNames, String delimiter, Map<String, String> groupRolesMap) {
        ImmutableMap.Builder roleNamesBuilder = ImmutableMap.builder();
        if (groupRolesMap != null) {
            for (String groupName : groupNames) {
                String roleNamesString = groupRolesMap.get(groupName);
                LOG.debug("association discovered: groupName={} and roleNamesString={}", (Object)groupName, (Object)roleNamesString);
                if (roleNamesString == null) continue;
                String[] roleNames = roleNamesString.split(delimiter);
                ImmutableSet.Builder rolesSet = ImmutableSet.builder();
                for (String roleName : roleNames) {
                    rolesSet.add((Object)roleName);
                }
                roleNamesBuilder.put((Object)groupName, (Object)rolesSet.build());
            }
        } else {
            LOG.info("groupRolesMap was unspecified; directly mapping LDAP groups instead: {}", groupNames);
            for (String groupName : groupNames) {
                ImmutableSet.Builder rolesSet = ImmutableSet.builder();
                rolesSet.add((Object)groupName);
                roleNamesBuilder.put((Object)groupName, (Object)rolesSet.build());
            }
        }
        return roleNamesBuilder.build();
    }
}

