/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.jdbc;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.util.Assert;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public class JdbcTransactionalResource
extends XATransactionalResource {
    private XADataSource xaDataSource;
    private XAConnection xaConnection;
    private String user;
    private String password;

    public JdbcTransactionalResource(String serverName, XADataSource xads) {
        super(serverName);
        Assert.notNull("XADataSource must not be null", xads);
        this.xaDataSource = xads;
        this.xaConnection = null;
    }

    private String getUser() {
        String ret = "";
        if (this.user != null) {
            ret = this.user;
        }
        return ret;
    }

    private String getPassword() {
        String ret = "";
        if (this.password != null) {
            ret = this.password;
        }
        return ret;
    }

    @Override
    protected synchronized XAResource refreshXAConnection() throws ResourceException {
        XAResource res = null;
        if (this.xaConnection != null) {
            try {
                this.xaConnection.close();
            }
            catch (Exception err) {
                // empty catch block
            }
        }
        try {
            this.xaConnection = this.createXAConnection();
            if (this.xaConnection != null) {
                res = this.xaConnection.getXAResource();
            }
        }
        catch (SQLException sql) {
            throw new ResourceException("Error in getting XA resource", sql);
        }
        return res;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void close() throws ResourceException {
        super.close();
        try {
            if (this.xaConnection != null) {
                this.xaConnection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private XAConnection createXAConnection() {
        XAConnection conn = null;
        try {
            conn = "".equals(this.getUser()) ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(this.getUser(), this.getPassword());
        }
        catch (SQLException noConnection) {
            conn = null;
        }
        return conn;
    }
}

