/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RecoveryService;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionServicePlugin;
import com.atomikos.icatch.admin.LogControl;
import com.atomikos.icatch.admin.imp.LogControlImp;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.provider.ConfigProperties;
import com.atomikos.icatch.provider.TransactionServiceProvider;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.recovery.AdminLog;
import com.atomikos.recovery.CoordinatorLogEntry;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.RecoveryLog;
import com.atomikos.recovery.TxState;
import com.atomikos.thread.TaskManager;
import com.atomikos.timing.AlarmTimer;
import com.atomikos.timing.AlarmTimerListener;
import com.atomikos.timing.PooledAlarmTimer;
import com.atomikos.util.UniqueIdMgr;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;

public class TransactionServiceImp
implements TransactionServiceProvider,
FSMEnterListener,
SubTxAwareParticipant,
RecoveryService,
AdminLog {
    private static final Logger LOGGER = LoggerFactory.createLogger(TransactionServiceImp.class);
    private static final int NUMLATCHES = 97;
    private long maxTimeout_;
    private Object[] rootLatches_ = null;
    private Hashtable<String, CompositeTransaction> tidToTransactionMap_ = null;
    private Hashtable<String, CoordinatorImp> rootToCoordinatorMap_ = null;
    private boolean shutdownInProgress_ = false;
    private Object shutdownSynchronizer_;
    private UniqueIdMgr tidmgr_ = null;
    private StateRecoveryManager recoverymanager_ = null;
    private boolean initialized_ = false;
    private LogControl control_;
    private boolean otsOverride_;
    private Vector<TransactionServicePlugin> tsListeners_;
    private int maxNumberOfActiveTransactions_;
    private String tmUniqueName_;
    private boolean single_threaded_2pc_;
    private RecoveryLog recoveryLog;
    private PooledAlarmTimer recoveryTimer;

    public TransactionServiceImp(String name, StateRecoveryManager recoverymanager, UniqueIdMgr tidmgr, long maxtimeout, int maxActives, boolean single_threaded_2pc, RecoveryLog recoveryLog) {
        this(name, recoverymanager, tidmgr, maxtimeout, true, maxActives, single_threaded_2pc, recoveryLog);
    }

    private TransactionServiceImp(String name, StateRecoveryManager recoverymanager, UniqueIdMgr tidmgr, long maxtimeout, boolean checkorphans, int maxActives, boolean single_threaded_2pc, RecoveryLog recoveryLog) {
        this.maxNumberOfActiveTransactions_ = maxActives;
        this.otsOverride_ = !checkorphans;
        this.initialized_ = false;
        this.recoverymanager_ = recoverymanager;
        this.tidmgr_ = tidmgr;
        this.tidToTransactionMap_ = new Hashtable();
        this.shutdownSynchronizer_ = new Object();
        this.rootToCoordinatorMap_ = new Hashtable();
        this.rootLatches_ = new Object[97];
        for (int i = 0; i < 97; ++i) {
            this.rootLatches_[i] = new Object();
        }
        this.maxTimeout_ = maxtimeout;
        this.tmUniqueName_ = name;
        this.tsListeners_ = new Vector();
        this.single_threaded_2pc_ = single_threaded_2pc;
        this.recoveryLog = recoveryLog;
    }

    private Object getLatch(String root) {
        return this.rootLatches_[Math.abs(root.toString().hashCode() % 97)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTidToTx(String tid, CompositeTransaction ct) throws IllegalStateException {
        Hashtable<String, CompositeTransaction> hashtable = this.tidToTransactionMap_;
        synchronized (hashtable) {
            if (this.tidToTransactionMap_.containsKey(tid.intern())) {
                throw new IllegalStateException("Already mapped: " + tid);
            }
            this.tidToTransactionMap_.put(tid.intern(), ct);
            ct.addSubTxAwareParticipant(this);
        }
    }

    private Vector<CoordinatorImp> getCoordinatorImpVector() {
        Vector<CoordinatorImp> ret = new Vector<CoordinatorImp>();
        Enumeration<String> tids = this.rootToCoordinatorMap_.keys();
        while (tids.hasMoreElements()) {
            String next = tids.nextElement();
            CoordinatorImp c = this.getCoordinatorImp(next);
            if (c == null) continue;
            ret.addElement(c);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCoordinator(CompositeCoordinator coord) {
        Object object = this.shutdownSynchronizer_;
        synchronized (object) {
            Object object2 = this.getLatch(coord.getCoordinatorId().intern());
            synchronized (object2) {
                this.rootToCoordinatorMap_.remove(coord.getCoordinatorId().intern());
            }
            if (this.rootToCoordinatorMap_.isEmpty()) {
                this.shutdownSynchronizer_.notifyAll();
            }
        }
    }

    private void removeTransaction(CompositeTransaction ct) {
        if (ct == null) {
            return;
        }
        this.tidToTransactionMap_.remove(ct.getTid().intern());
    }

    private CompositeTransactionImp createCT(String tid, CoordinatorImp coordinator, Stack<CompositeTransaction> lineage, boolean serial) throws SysException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("Creating composite transaction: " + tid);
        }
        CompositeTransactionImp ct = new CompositeTransactionImp(this, lineage, tid, serial, coordinator);
        this.setTidToTx(ct.getTid(), ct);
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinatorImp createCC(RecoveryCoordinator adaptor, String root, boolean checkOrphans, boolean heuristic_commit, long timeout) {
        CoordinatorImp cc = null;
        if (this.maxTimeout_ > 0L && timeout > this.maxTimeout_) {
            timeout = this.maxTimeout_;
            LOGGER.logWarning("Attempt to create a transaction with a timeout that exceeds maximum - truncating to: " + this.maxTimeout_);
        }
        Object object = this.shutdownSynchronizer_;
        synchronized (object) {
            if (this.shutdownInProgress_) {
                throw new IllegalStateException("Server is shutting down...");
            }
            if (this.otsOverride_) {
                checkOrphans = false;
            }
            cc = new CoordinatorImp(root, adaptor, heuristic_commit, timeout, checkOrphans, this.single_threaded_2pc_);
            this.recoverymanager_.register(cc);
            Object object2 = this.getLatch(root.intern());
            synchronized (object2) {
                this.rootToCoordinatorMap_.put(root.intern(), cc);
            }
            this.startlistening(cc);
        }
        return cc;
    }

    private void startlistening(CoordinatorImp coordinator) {
        HashSet<TxState> forgetStates = new HashSet<TxState>();
        for (TxState txState : TxState.values()) {
            if (!txState.isFinalStateForOltp()) continue;
            forgetStates.add(txState);
        }
        for (TxState txState : forgetStates) {
            coordinator.addFSMEnterListener(this, txState);
        }
        if (forgetStates.contains((Object)coordinator.getState())) {
            this.removeCoordinator(coordinator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinatorImp getCoordinatorImp(String root) throws SysException {
        root = root.intern();
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        CoordinatorImp cc = null;
        Object object = this.shutdownSynchronizer_;
        synchronized (object) {
            Object object2 = this.getLatch(root);
            synchronized (object2) {
                cc = this.rootToCoordinatorMap_.get(root);
            }
        }
        return cc;
    }

    @Override
    public String getName() {
        return this.tmUniqueName_;
    }

    @Override
    public LogControl getLogControl() {
        return this.control_;
    }

    @Override
    public CompositeCoordinator getCompositeCoordinator(String root) throws SysException {
        return this.getCoordinatorImp(root);
    }

    @Override
    public void addTSListener(TransactionServicePlugin listener) throws IllegalStateException {
        if (!this.tsListeners_.contains(listener)) {
            this.tsListeners_.addElement(listener);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("Added TSListener: " + listener);
            }
        }
    }

    @Override
    public void removeTSListener(TransactionServicePlugin listener) {
        this.tsListeners_.removeElement(listener);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("Removed TSListener: " + listener);
        }
    }

    @Override
    public synchronized void init(Properties properties) throws SysException {
        this.shutdownInProgress_ = false;
        this.control_ = new LogControlImp((AdminLog)((Object)this.recoveryLog));
        ConfigProperties configProperties = new ConfigProperties(properties);
        long recoveryDelay = configProperties.getRecoveryDelay();
        this.recoveryTimer = new PooledAlarmTimer(recoveryDelay);
        this.recoveryTimer.addAlarmTimerListener(new AlarmTimerListener(){

            @Override
            public void alarm(AlarmTimer timer) {
                TransactionServiceImp.this.performRecovery();
            }
        });
        TaskManager.SINGLETON.executeTask(this.recoveryTimer);
        this.initialized_ = true;
    }

    private void performRecovery() {
        Enumeration<RecoverableResource> resources = Configuration.getResources();
        while (resources.hasMoreElements()) {
            RecoverableResource recoverableResource = resources.nextElement();
            try {
                recoverableResource.recover();
            }
            catch (Throwable e) {
                LOGGER.logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public Participant getParticipant(String root) throws SysException {
        return this.getCoordinatorImp(root);
    }

    @Override
    public void entered(FSMEnterEvent event) {
        CoordinatorImp cc = (CoordinatorImp)event.getSource();
        this.removeCoordinator(cc);
    }

    @Override
    public void committed(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    @Override
    public void rolledback(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeTransaction getCompositeTransaction(String tid) {
        CompositeTransaction ret = null;
        Hashtable<String, CompositeTransaction> hashtable = this.tidToTransactionMap_;
        synchronized (hashtable) {
            ret = this.tidToTransactionMap_.get(tid.intern());
        }
        return ret;
    }

    CompositeTransaction createSubTransaction(CompositeTransaction parent) {
        if (Configuration.getConfigProperties().getAllowSubTransactions()) {
            CompositeTransactionImp ret = null;
            Stack lineage = (Stack)parent.getLineage().clone();
            lineage.push(parent);
            String tid = this.tidmgr_.get();
            CoordinatorImp ccParent = (CoordinatorImp)parent.getCompositeCoordinator();
            CoordinatorImp cc = this.createCC(null, tid, false, ccParent.prefersHeuristicCommit(), parent.getTimeout());
            ret = this.createCT(tid, cc, lineage, parent.isSerial());
            ret.noLocalAncestors = false;
            return ret;
        }
        throw new SysException("Subtransactions not allowed - set config property com.atomikos.icatch.allow_subtransactions=true to enable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CompositeTransaction recreateCompositeTransaction(Propagation context, boolean orphancheck, boolean heur_commit) throws SysException {
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.maxNumberOfActiveTransactions_ >= 0 && this.tidToTransactionMap_.size() >= this.maxNumberOfActiveTransactions_) {
            throw new IllegalStateException("Max number of active transactions reached:" + this.maxNumberOfActiveTransactions_);
        }
        CoordinatorImp cc = null;
        CompositeTransactionImp ct = null;
        try {
            String tid = this.tidmgr_.get();
            boolean serial = context.isSerial();
            Stack<CompositeTransaction> lineage = context.getLineage();
            if (lineage.empty()) {
                throw new SysException("Empty lineage in propagation: empty lineage");
            }
            Stack<CompositeTransaction> tmp = new Stack<CompositeTransaction>();
            while (!lineage.empty()) {
                tmp.push(lineage.pop());
            }
            CompositeTransaction root = (CompositeTransaction)tmp.peek();
            while (!tmp.empty()) {
                lineage.push((CompositeTransaction)tmp.pop());
            }
            CompositeTransaction parent = lineage.peek();
            Object object = this.shutdownSynchronizer_;
            synchronized (object) {
                Object object2 = this.getLatch(root.getTid());
                synchronized (object2) {
                    cc = this.getCoordinatorImp(root.getTid());
                    if (cc == null) {
                        RecoveryCoordinator coord = parent.getCompositeCoordinator().getRecoveryCoordinator();
                        cc = this.createCC(coord, root.getTid(), orphancheck, heur_commit, context.getTimeOut());
                    }
                    cc.incLocalSiblingCount();
                }
            }
            ct = this.createCT(tid, cc, lineage, serial);
        }
        catch (Exception e) {
            throw new SysException("Error in recreate.", e);
        }
        return ct;
    }

    @Override
    public void shutdown(boolean force) {
        this.shutdown(force, Long.MAX_VALUE);
    }

    @Override
    public void shutdown(long maxWaitTime) {
        this.shutdown(false, maxWaitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean force, long maxWaitTime) {
        boolean wasShuttingDown = false;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("Transaction Service: Entering shutdown ( " + force + " )...");
        }
        if (!wasShuttingDown && force) {
            Enumeration<String> enumm = this.rootToCoordinatorMap_.keys();
            while (enumm.hasMoreElements()) {
                String tid = enumm.nextElement();
                LOGGER.logTrace("Transaction Service: Stopping thread for root " + tid + "...");
                CoordinatorImp c = this.rootToCoordinatorMap_.get(tid);
                if (c != null) {
                    c.dispose();
                }
                LOGGER.logTrace("Transaction Service: Thread stopped.");
            }
        }
        Object object = this.shutdownSynchronizer_;
        synchronized (object) {
            LOGGER.logTrace("Transaction Service: Shutdown acquired lock on waiter.");
            wasShuttingDown = this.shutdownInProgress_;
            this.shutdownInProgress_ = true;
            while (!this.rootToCoordinatorMap_.isEmpty() && !force) {
                this.performRecovery();
                this.recoveryLog.close(maxWaitTime);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace("Transaction Service: Purging coordinators for shutdown...");
                }
                Hashtable<String, CoordinatorImp> clone = new Hashtable<String, CoordinatorImp>(this.rootToCoordinatorMap_);
                Enumeration<String> coordinatorIds = clone.keys();
                while (coordinatorIds.hasMoreElements()) {
                    String id = coordinatorIds.nextElement();
                    this.rootToCoordinatorMap_.remove(id);
                }
            }
            this.initialized_ = false;
            if (!wasShuttingDown) {
                try {
                    this.recoverymanager_.close();
                }
                catch (LogException le) {
                    throw new SysException("Error in shutdown: " + le.getMessage(), le);
                }
                this.recoveryTimer.stop();
            }
        }
        this.shutdownSystemExecutors();
    }

    private void shutdownSystemExecutors() {
        TaskManager exec = TaskManager.SINGLETON;
        if (exec != null) {
            exec.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finalize() throws Throwable {
        try {
            if (!this.shutdownInProgress_ && this.initialized_) {
                this.shutdown(true);
            }
        }
        catch (Exception e) {
            LOGGER.logWarning("Error in GC of TransactionServiceImp", e);
        }
        finally {
            super.finalize();
        }
    }

    public RecoveryCoordinator getSuperiorRecoveryCoordinator(String root) {
        RecoveryCoordinator ret = null;
        CoordinatorImp c = this.getCoordinatorImp(root);
        if (c != null) {
            ret = c.getSuperiorRecoveryCoordinator();
        }
        return ret;
    }

    @Override
    public CompositeTransaction createCompositeTransaction(long timeout) throws SysException {
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.maxNumberOfActiveTransactions_ >= 0 && this.tidToTransactionMap_.size() >= this.maxNumberOfActiveTransactions_) {
            throw new IllegalStateException("Max number of active transactions reached:" + this.maxNumberOfActiveTransactions_);
        }
        String tid = this.tidmgr_.get();
        Stack<CompositeTransaction> lineage = new Stack<CompositeTransaction>();
        CoordinatorImp cc = this.createCC(null, tid, true, false, timeout);
        CompositeTransactionImp ct = this.createCT(tid, cc, lineage, false);
        return ct;
    }

    @Override
    public RecoveryService getRecoveryService() {
        return this;
    }

    @Override
    public CoordinatorLogEntry[] getCoordinatorLogEntries() {
        Vector<CoordinatorImp> coordinatorImpVector = this.getCoordinatorImpVector();
        ArrayList<CoordinatorLogEntry> coordinatorLogEntries = new ArrayList<CoordinatorLogEntry>(coordinatorImpVector.size());
        for (CoordinatorImp coordinatorImp : coordinatorImpVector) {
            CoordinatorLogEntry coordinatorLogEntry = coordinatorImp.getCoordinatorLogEntry();
            if (coordinatorLogEntry == null) continue;
            coordinatorLogEntries.add(coordinatorLogEntry);
        }
        return coordinatorLogEntries.toArray(new CoordinatorLogEntry[coordinatorLogEntries.size()]);
    }

    @Override
    public void remove(String coordinatorId) {
        Vector<CoordinatorImp> coordinatorImpVector = this.getCoordinatorImpVector();
        for (CoordinatorImp coordinatorImp : coordinatorImpVector) {
            if (!coordinatorImp.getId().equals(coordinatorId)) continue;
            coordinatorImp.forget();
        }
    }

    @Override
    public RecoveryLog getRecoveryLog() {
        return this.recoveryLog;
    }
}

