/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.transactions.internal;

import com.atomikos.icatch.jta.UserTransactionImp;
import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class AtomikosActivator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosActivator.class);
    private UserTransactionManager utm;
    private ServiceRegistration utmRegistration;
    private ServiceRegistration userTransactionRegistration;
    private UserTransactionImp userTransaction;

    public void start(BundleContext context) throws Exception {
        try {
            this.utm = new UserTransactionManager();
            this.utm.init();
            Hashtable<String, String> tmProps = new Hashtable<String, String>();
            ((Dictionary)tmProps).put("osgi.jndi.service.name", "AtomikosV4");
            this.utmRegistration = context.registerService(TransactionManager.class.getName(), (Object)this.utm, tmProps);
            this.userTransaction = new UserTransactionImp();
            Hashtable<String, String> utmProps = new Hashtable<String, String>();
            ((Dictionary)utmProps).put("osgi.jndi.service.name", "AtomikosV4");
            this.userTransactionRegistration = context.registerService(UserTransaction.class.getName(), (Object)this.userTransaction, utmProps);
        }
        catch (Exception e) {
            LOGGER.logFatal(e.getMessage(), e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.utmRegistration != null) {
                this.utmRegistration.unregister();
                this.utmRegistration = null;
            }
            if (this.utm != null) {
                this.utm.close();
            }
            if (this.userTransactionRegistration != null) {
                this.userTransactionRegistration.unregister();
                this.userTransactionRegistration = null;
            }
        }
        catch (Exception e) {
            LOGGER.logError(e.getMessage(), e);
        }
    }
}

