/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsaltrace.rev160908;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsaltrace.rev160908.Config;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder
implements Builder<Config> {
    private List<String> _registrationWatches;
    private List<String> _writeWatches;
    private Boolean _transactionDebugContextEnabled;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }

    public ConfigBuilder(Config base) {
        Map aug;
        this._registrationWatches = base.getRegistrationWatches();
        this._writeWatches = base.getWriteWatches();
        this._transactionDebugContextEnabled = base.isTransactionDebugContextEnabled();
        if (base instanceof ConfigImpl) {
            ConfigImpl impl = (ConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
    }

    public List<String> getRegistrationWatches() {
        return this._registrationWatches;
    }

    public List<String> getWriteWatches() {
        return this._writeWatches;
    }

    public Boolean isTransactionDebugContextEnabled() {
        return this._transactionDebugContextEnabled;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ConfigBuilder setRegistrationWatches(List<String> values) {
        this._registrationWatches = values;
        return this;
    }

    public ConfigBuilder setWriteWatches(List<String> values) {
        this._writeWatches = values;
        return this;
    }

    public ConfigBuilder setTransactionDebugContextEnabled(Boolean value) {
        this._transactionDebugContextEnabled = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Class<? extends Augmentation<Config>> augmentationType, Augmentation<Config> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    implements Config {
        private final List<String> _registrationWatches;
        private final List<String> _writeWatches;
        private final Boolean _transactionDebugContextEnabled;
        private Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            this._registrationWatches = base.getRegistrationWatches();
            this._writeWatches = base.getWriteWatches();
            this._transactionDebugContextEnabled = base.isTransactionDebugContextEnabled();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Config> getImplementedInterface() {
            return Config.class;
        }

        @Override
        public List<String> getRegistrationWatches() {
            return this._registrationWatches;
        }

        @Override
        public List<String> getWriteWatches() {
            return this._writeWatches;
        }

        @Override
        public Boolean isTransactionDebugContextEnabled() {
            return this._transactionDebugContextEnabled;
        }

        public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._registrationWatches);
            result = 31 * result + Objects.hashCode(this._writeWatches);
            result = 31 * result + Objects.hashCode(this._transactionDebugContextEnabled);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Config.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Config other = (Config)obj;
            if (!Objects.equals(this._registrationWatches, other.getRegistrationWatches())) {
                return false;
            }
            if (!Objects.equals(this._writeWatches, other.getWriteWatches())) {
                return false;
            }
            if (!Objects.equals(this._transactionDebugContextEnabled, other.isTransactionDebugContextEnabled())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ConfigImpl otherImpl = (ConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Config>>, Augmentation<Config>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Config");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_registrationWatches", this._registrationWatches);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_writeWatches", this._writeWatches);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_transactionDebugContextEnabled", (Object)this._transactionDebugContextEnabled);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

