/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.resolver.obr.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.aries.application.management.ResolverException;
import org.apache.aries.application.management.spi.repository.RepositoryGenerator;
import org.apache.aries.application.management.spi.runtime.LocalPlatform;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.ModelledResourceManager;
import org.apache.aries.application.resolver.obr.ext.BundleResource;
import org.apache.aries.application.resolver.obr.ext.BundleResourceTransformer;
import org.apache.aries.util.filesystem.FileSystem;
import org.apache.aries.util.filesystem.FileUtils;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.io.IOUtils;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Property;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class RepositoryGeneratorImpl
implements RepositoryGenerator {
    private RepositoryAdmin repositoryAdmin;
    private ModelledResourceManager modelledResourceManager;
    private LocalPlatform tempDir;
    private static Logger logger = LoggerFactory.getLogger(RepositoryGeneratorImpl.class);
    private static Collection<BundleResourceTransformer> bundleResourceTransformers = new ArrayList<BundleResourceTransformer>();
    private static final String MANDATORY_DIRECTIVE = "mandatory:";

    public void setModelledResourceManager(ModelledResourceManager modelledResourceManager) {
        this.modelledResourceManager = modelledResourceManager;
    }

    public void setTempDir(LocalPlatform tempDir) {
        this.tempDir = tempDir;
    }

    public void setBundleResourceTransformers(List<BundleResourceTransformer> brts) {
        bundleResourceTransformers = brts;
    }

    public RepositoryGeneratorImpl(RepositoryAdmin repositoryAdmin) {
        this.repositoryAdmin = repositoryAdmin;
    }

    private static void addProperty(Document doc, Element capability, String name, String value, String type) {
        logger.debug("Method entry: {}, args {}", (Object)"addProperty", (Object)new Object[]{doc, capability, name, value, type});
        Element p = doc.createElement("p");
        p.setAttribute("n", name);
        p.setAttribute("v", value);
        if (type != null) {
            p.setAttribute("t", type);
        }
        capability.appendChild(p);
        logger.debug("Method entry: {}, args {}", (Object)"addProperty", (Object)new Object[0]);
    }

    private static void writeResource(Resource r, String uri, Document doc, Element root) throws IOException {
        logger.debug("Method entry: {}, args {}", (Object)"writeResource", (Object)new Object[]{r, uri, doc, root});
        Element resource = doc.createElement("resource");
        resource.setAttribute("version", r.getVersion().toString());
        resource.setAttribute("uri", r.getURI());
        resource.setAttribute("symbolicname", r.getSymbolicName());
        resource.setAttribute("id", r.getSymbolicName() + "/" + r.getVersion());
        resource.setAttribute("presentationname", r.getPresentationName());
        root.appendChild(resource);
        for (Capability capability : r.getCapabilities()) {
            RepositoryGeneratorImpl.writeCapability(capability, doc, resource);
        }
        for (Capability capability : r.getRequirements()) {
            RepositoryGeneratorImpl.writeRequirement((Requirement)capability, doc, resource);
        }
        logger.debug("Method exit: {}, returning {}", (Object)"writeResource");
    }

    private static void writeCapability(Capability c, Document doc, Element resource) throws IOException {
        Property[] props;
        logger.debug("Method entry: {}, args {}", (Object)"writeCapability", (Object)new Object[]{c, doc, resource});
        Element capability = doc.createElement("capability");
        capability.setAttribute("name", c.getName());
        resource.appendChild(capability);
        for (Property entry : props = c.getProperties()) {
            String type;
            String name = entry.getName();
            String objectAttrs = entry.getValue();
            String string = type = entry.getType() == null ? RepositoryGeneratorImpl.getType(name) : entry.getType();
            if (objectAttrs.startsWith("\"") && objectAttrs.endsWith("\"")) {
                objectAttrs = objectAttrs.substring(1, objectAttrs.length() - 1);
            }
            RepositoryGeneratorImpl.addProperty(doc, capability, name, objectAttrs, type);
        }
        logger.debug("Method exit: {}, returning {}", (Object)"writeCapability");
    }

    private static void writeRequirement(Requirement req, Document doc, Element resource) throws IOException {
        logger.debug("Method entry: {}, args {}", (Object)"writeRequirement", (Object)new Object[]{req, doc, resource});
        Element requirement = doc.createElement("require");
        requirement.setAttribute("name", req.getName());
        requirement.setAttribute("extend", String.valueOf(req.isExtend()));
        requirement.setAttribute("multiple", String.valueOf(req.isMultiple()));
        requirement.setAttribute("optional", String.valueOf(req.isOptional()));
        requirement.setAttribute("filter", req.getFilter());
        requirement.setTextContent(req.getComment());
        resource.appendChild(requirement);
        logger.debug("Method exit: {}, returning {}", (Object)"writeRequirement");
    }

    public void generateRepository(String repositoryName, Collection<? extends ModelledResource> byValueBundles, OutputStream os) throws ResolverException, IOException {
        logger.debug("Method entry: {}, args {}", (Object)"generateRepository", (Object)new Object[]{repositoryName, byValueBundles, os});
        RepositoryGeneratorImpl.generateRepository(this.repositoryAdmin, repositoryName, byValueBundles, os);
        logger.debug("Method exit: {}, returning {}", (Object)"generateRepository");
    }

    public static void generateRepository(RepositoryAdmin repositoryAdmin, String repositoryName, Collection<? extends ModelledResource> byValueBundles, OutputStream os) throws ResolverException, IOException {
        Document doc;
        logger.debug("Method entry: {}, args {}", (Object)"generateRepository", (Object)new Object[]{repositoryAdmin, repositoryName, byValueBundles, os});
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new ResolverException((Exception)pce);
        }
        Element root = doc.createElement("repository");
        root.setAttribute("name", repositoryName);
        doc.appendChild(root);
        for (ModelledResource modelledResource : byValueBundles) {
            BundleResource bundleResource = new BundleResource(modelledResource, repositoryAdmin);
            if (bundleResourceTransformers.size() > 0) {
                for (BundleResourceTransformer brt : bundleResourceTransformers) {
                    bundleResource = brt.transform(bundleResource);
                }
            }
            RepositoryGeneratorImpl.writeResource(bundleResource, modelledResource.getLocation(), doc, root);
        }
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.transform(new DOMSource(doc), new StreamResult(os));
        }
        catch (TransformerException te) {
            logger.debug("Method exit: {}, returning {}", (Object)"generateRepository", (Object)te);
            throw new ResolverException((Exception)te);
        }
        logger.debug("Method exit: {}, returning {}", (Object)"generateRepository");
    }

    private static String getType(String name) {
        logger.debug("Method entry: {}, args {}", (Object)"getType", (Object)new Object[]{name});
        String type = null;
        if ("version".equals(name) || "bundle-version".equals(name)) {
            type = "version";
        } else if ("objectClass".equals(name) || MANDATORY_DIRECTIVE.equals(name)) {
            type = "set";
        }
        logger.debug("Method exit: {}, returning {}", (Object)"getType", (Object)new Object[]{type});
        return type;
    }

    public void generateRepository(String[] source, OutputStream fout) throws IOException {
        logger.debug("Method entry: {}, args {}", (Object)"generateRepository", (Object)new Object[]{source, fout});
        ArrayList<URI> jarFiles = new ArrayList<URI>();
        InputStream in = null;
        FileOutputStream out = null;
        File wstemp = null;
        HashSet<ModelledResource> mrs = new HashSet<ModelledResource>();
        if (source != null) {
            try {
                for (String urlString : source) {
                    try {
                        File f = new File(urlString);
                        URI entry = f.exists() ? f.toURI() : new URI(urlString);
                        if ("file".equals(entry.toURL().getProtocol())) {
                            jarFiles.addAll(FileUtils.getBundlesRecursive((URI)entry));
                            continue;
                        }
                        jarFiles.add(entry);
                    }
                    catch (URISyntaxException use) {
                        throw new IOException(urlString + " is not a valide uri.");
                    }
                }
                for (URI jarFileURI : jarFiles) {
                    String uriString = jarFileURI.toString();
                    File f = null;
                    if ("file".equals(jarFileURI.toURL().getProtocol())) {
                        f = new File(jarFileURI);
                    } else {
                        int lastIndexOfSlash = uriString.lastIndexOf("/");
                        String fileName = uriString.substring(lastIndexOfSlash + 1);
                        URLConnection jarConn = jarFileURI.toURL().openConnection();
                        in = jarConn.getInputStream();
                        if (wstemp == null) {
                            wstemp = new File(this.tempDir.getTemporaryDirectory(), "generateRepositoryXML_" + System.currentTimeMillis());
                            boolean created = wstemp.mkdirs();
                            if (created) {
                                logger.debug("The temp directory was created successfully.");
                            } else {
                                logger.debug("The temp directory was NOT created.");
                            }
                        }
                        f = new File(wstemp, fileName);
                        out = new FileOutputStream(f);
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    IDirectory jarDir = FileSystem.getFSRoot((File)f);
                    mrs.add(this.modelledResourceManager.getModelledResource(uriString, jarDir));
                }
                this.generateRepository("Resource Repository", mrs, fout);
            }
            catch (Exception e) {
                logger.debug("Method exit: {}, returning {}", (Object)"generateRepository");
                throw new IOException(e);
            }
            finally {
                IOUtils.close(in);
                IOUtils.close(out);
                if (wstemp != null) {
                    IOUtils.deleteRecursive(wstemp);
                }
            }
        } else {
            logger.debug("The URL list is empty");
        }
        logger.debug("Method exit: {}, returning {}", (Object)"generateRepository");
    }
}

