/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jndi.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.aries.proxy.ProxyManager;
import org.apache.karaf.jndi.JndiService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class JndiServiceImpl
implements JndiService {
    private BundleContext bundleContext;
    private ProxyManager proxyManager;
    private static final String OSGI_JNDI_CONTEXT_PREFIX = "osgi:service";
    private static final String OSGI_JNDI_SERVICE_PROPERTY = "osgi.jndi.service.name";

    @Override
    public Map<String, String> names() throws Exception {
        Map<String, String> result = this.names("/");
        result.putAll(this.names(OSGI_JNDI_CONTEXT_PREFIX));
        return result;
    }

    @Override
    public Map<String, String> names(String name) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        if (name.startsWith(OSGI_JNDI_CONTEXT_PREFIX)) {
            Bundle[] bundles;
            for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
                ServiceReference[] services = bundle.getRegisteredServices();
                if (services == null) continue;
                for (ServiceReference service : services) {
                    if (service.getProperty(OSGI_JNDI_SERVICE_PROPERTY) == null) continue;
                    Object actualService = this.bundleContext.getService(service);
                    if (this.proxyManager.isProxy(actualService)) {
                        actualService = this.proxyManager.unwrap(actualService).call();
                    }
                    if (service.getProperty(OSGI_JNDI_SERVICE_PROPERTY).toString().startsWith("/")) {
                        map.put(OSGI_JNDI_CONTEXT_PREFIX + service.getProperty(OSGI_JNDI_SERVICE_PROPERTY), actualService.getClass().getName());
                    } else {
                        map.put("osgi:service/" + service.getProperty(OSGI_JNDI_SERVICE_PROPERTY), actualService.getClass().getName());
                    }
                    this.bundleContext.ungetService(service);
                }
            }
        } else {
            InitialContext context = new InitialContext();
            NamingEnumeration<NameClassPair> pairs = context.list(name);
            while (pairs.hasMoreElements()) {
                NameClassPair pair = (NameClassPair)pairs.nextElement();
                Object o = name != null ? context.lookup(name + "/" + pair.getName()) : context.lookup(pair.getName());
                if (o instanceof Context) {
                    StringBuilder sb = new StringBuilder();
                    if (pair.getName().contains(":")) {
                        sb.append(pair.getName());
                    } else {
                        sb.append("/" + pair.getName());
                    }
                    JndiServiceImpl.names((Context)o, sb, map);
                    continue;
                }
                if (pair.getName().contains(":")) {
                    map.put(pair.getName(), pair.getClassName());
                    continue;
                }
                map.put("/" + pair.getName(), pair.getClassName());
            }
        }
        return map;
    }

    @Override
    public List<String> contexts() throws Exception {
        return this.contexts("/");
    }

    @Override
    public List<String> contexts(String name) throws Exception {
        ArrayList<String> contexts = new ArrayList<String>();
        InitialContext context = new InitialContext();
        NamingEnumeration<NameClassPair> pairs = context.list(name);
        while (pairs.hasMoreElements()) {
            NameClassPair pair = (NameClassPair)pairs.nextElement();
            Object o = name != null ? context.lookup(name + "/" + pair.getName()) : context.lookup(pair.getName());
            if (!(o instanceof Context)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("/" + pair.getName());
            this.contexts((Context)o, sb, contexts);
        }
        return contexts;
    }

    private void contexts(Context context, StringBuilder sb, List<String> contexts) throws Exception {
        NamingEnumeration<Binding> list = context.listBindings("");
        while (list.hasMore()) {
            Binding item = list.next();
            String name = item.getName();
            Object o = item.getObject();
            if (!(o instanceof Context)) continue;
            if (((Context)o).list("").hasMoreElements()) {
                sb.append("/").append(name);
                this.contexts((Context)o, sb, contexts);
                continue;
            }
            contexts.add(sb.toString() + "/" + name);
        }
    }

    private static final void names(Context ctx, StringBuilder sb, Map<String, String> map) throws Exception {
        NamingEnumeration<Binding> list = ctx.listBindings("");
        while (list.hasMore()) {
            Binding item = list.next();
            String className = item.getClassName();
            String name = item.getName();
            Object o = item.getObject();
            if (o instanceof Context) {
                sb.append("/").append(name);
                JndiServiceImpl.names((Context)o, sb, map);
                continue;
            }
            map.put(sb.toString() + "/" + name, className);
        }
    }

    @Override
    public void create(String name) throws Exception {
        Context context = new InitialContext();
        String[] splitted = name.split("/");
        if (splitted.length > 0) {
            for (String split : splitted) {
                try {
                    Object o = context.lookup(split);
                    if (!(o instanceof Context)) {
                        throw new NamingException("Name " + split + " already exists");
                    }
                }
                catch (NameNotFoundException e) {
                    context.createSubcontext(split);
                }
                context = (Context)context.lookup(split);
            }
        } else {
            context.createSubcontext(name);
        }
    }

    @Override
    public void delete(String name) throws Exception {
        InitialContext context = new InitialContext();
        context.destroySubcontext(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(long serviceId, String name) throws Exception {
        Bundle[] bundles;
        Context context = new InitialContext();
        for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
            ServiceReference[] services = bundle.getRegisteredServices();
            if (services == null) continue;
            for (ServiceReference service : services) {
                if (service.getProperty("service.id") == null || (Long)service.getProperty("service.id") != serviceId) continue;
                Object actualService = this.bundleContext.getService(service);
                if (this.proxyManager.isProxy(actualService)) {
                    actualService = this.proxyManager.unwrap(actualService).call();
                }
                try {
                    String[] splitted = name.split("/");
                    if (splitted.length > 0) {
                        for (int i = 0; i < splitted.length - 1; ++i) {
                            try {
                                Object o = context.lookup(splitted[i]);
                                if (!(o instanceof Context)) {
                                    throw new NamingException("Name " + splitted[i] + " already exists");
                                }
                            }
                            catch (NameNotFoundException nnfe) {
                                context.createSubcontext(splitted[i]);
                            }
                            context = (Context)context.lookup(splitted[i]);
                        }
                        name = splitted[splitted.length - 1];
                    }
                    context.bind(name, actualService);
                }
                finally {
                    this.bundleContext.ungetService(service);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alias(String name, String alias) throws Exception {
        Context context = new InitialContext();
        if (name.startsWith(OSGI_JNDI_CONTEXT_PREFIX)) {
            Bundle[] bundles;
            for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
                ServiceReference[] services = bundle.getRegisteredServices();
                if (services == null) continue;
                for (ServiceReference service : services) {
                    if (service.getProperty(OSGI_JNDI_SERVICE_PROPERTY) == null || !service.getProperty(OSGI_JNDI_SERVICE_PROPERTY).equals(name.substring(OSGI_JNDI_CONTEXT_PREFIX.length() + 1))) continue;
                    Object actualService = this.bundleContext.getService(service);
                    try {
                        String[] splitted;
                        if (this.proxyManager.isProxy(actualService)) {
                            actualService = this.proxyManager.unwrap(actualService).call();
                        }
                        if ((splitted = alias.split("/")).length > 0) {
                            for (int i = 0; i < splitted.length - 1; ++i) {
                                try {
                                    Object o = context.lookup(splitted[i]);
                                    if (!(o instanceof Context)) {
                                        throw new NamingException("Name " + splitted[i] + " already exists");
                                    }
                                }
                                catch (NameNotFoundException nnfe) {
                                    context.createSubcontext(splitted[i]);
                                }
                                context = (Context)context.lookup(splitted[i]);
                            }
                            alias = splitted[splitted.length - 1];
                        }
                        context.bind(alias, actualService);
                    }
                    finally {
                        this.bundleContext.ungetService(service);
                    }
                }
            }
        } else {
            Object object = context.lookup(name);
            String[] splitted = alias.split("/");
            if (splitted.length > 0) {
                for (int i = 0; i < splitted.length - 1; ++i) {
                    try {
                        Object o = context.lookup(splitted[i]);
                        if (!(o instanceof Context)) {
                            throw new NamingException("Name " + splitted[i] + " already exists");
                        }
                    }
                    catch (NameNotFoundException nnfe) {
                        context.createSubcontext(splitted[i]);
                    }
                    context = (Context)context.lookup(splitted[i]);
                }
                alias = splitted[splitted.length - 1];
            }
            context.bind(alias, object);
        }
    }

    @Override
    public void unbind(String name) throws Exception {
        InitialContext context = new InitialContext();
        if (name.startsWith(OSGI_JNDI_CONTEXT_PREFIX)) {
            throw new IllegalArgumentException("You can't unbind a name from the osgi:service JNDI context.");
        }
        context.unbind(name);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public void setProxyManager(ProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }
}

