/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentedException
extends Exception {
    public static final String RPC_ERROR = "rpc-error";
    public static final String ERROR_TYPE = "error-type";
    public static final String ERROR_TAG = "error-tag";
    public static final String ERROR_SEVERITY = "error-severity";
    public static final String ERROR_APP_TAG = "error-app-tag";
    public static final String ERROR_PATH = "error-path";
    public static final String ERROR_MESSAGE = "error-message";
    public static final String ERROR_INFO = "error-info";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DocumentedException.class);
    private static final DocumentBuilderFactory BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private final ErrorType errorType;
    private final ErrorTag errorTag;
    private final ErrorSeverity errorSeverity;
    private final Map<String, String> errorInfo;

    public DocumentedException(String message) {
        this(message, ErrorType.APPLICATION, ErrorTag.INVALID_VALUE, ErrorSeverity.ERROR);
    }

    public DocumentedException(String message, Exception cause) {
        this(message, cause, ErrorType.APPLICATION, ErrorTag.INVALID_VALUE, ErrorSeverity.ERROR);
    }

    public DocumentedException(String message, ErrorType errorType, ErrorTag errorTag, ErrorSeverity errorSeverity) {
        this(message, errorType, errorTag, errorSeverity, Collections.emptyMap());
    }

    public DocumentedException(String message, ErrorType errorType, ErrorTag errorTag, ErrorSeverity errorSeverity, Map<String, String> errorInfo) {
        super(message);
        this.errorType = errorType;
        this.errorTag = errorTag;
        this.errorSeverity = errorSeverity;
        this.errorInfo = errorInfo;
    }

    public DocumentedException(String message, Exception cause, ErrorType errorType, ErrorTag errorTag, ErrorSeverity errorSeverity) {
        this(message, cause, errorType, errorTag, errorSeverity, Collections.emptyMap());
    }

    public DocumentedException(String message, Exception cause, ErrorType errorType, ErrorTag errorTag, ErrorSeverity errorSeverity, Map<String, String> errorInfo) {
        super(message, cause);
        this.errorType = errorType;
        this.errorTag = errorTag;
        this.errorSeverity = errorSeverity;
        this.errorInfo = errorInfo;
    }

    public static <E extends Exception> DocumentedException wrap(E exception) throws DocumentedException {
        HashMap<String, String> errorInfo = new HashMap<String, String>();
        errorInfo.put(ErrorTag.OPERATION_FAILED.name(), "Exception thrown");
        throw new DocumentedException(exception.getMessage(), exception, ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR, errorInfo);
    }

    public static DocumentedException fromXMLDocument(Document fromDoc) {
        ErrorType errorType = ErrorType.APPLICATION;
        ErrorTag errorTag = ErrorTag.OPERATION_FAILED;
        ErrorSeverity errorSeverity = ErrorSeverity.ERROR;
        Map<String, String> errorInfo = null;
        String errorMessage = "";
        Element rpcReply = fromDoc.getDocumentElement();
        NodeList replyChildren = rpcReply.getChildNodes();
        for (int i = 0; i < replyChildren.getLength(); ++i) {
            Node replyChild = replyChildren.item(i);
            if (!RPC_ERROR.equals(replyChild.getNodeName())) continue;
            NodeList rpcErrorChildren = replyChild.getChildNodes();
            for (int j = 0; j < rpcErrorChildren.getLength(); ++j) {
                Node rpcErrorChild = rpcErrorChildren.item(j);
                if (ERROR_TYPE.equals(rpcErrorChild.getNodeName())) {
                    errorType = ErrorType.from(rpcErrorChild.getTextContent());
                    continue;
                }
                if (ERROR_TAG.equals(rpcErrorChild.getNodeName())) {
                    errorTag = ErrorTag.from(rpcErrorChild.getTextContent());
                    continue;
                }
                if (ERROR_SEVERITY.equals(rpcErrorChild.getNodeName())) {
                    errorSeverity = ErrorSeverity.from(rpcErrorChild.getTextContent());
                    continue;
                }
                if (ERROR_MESSAGE.equals(rpcErrorChild.getNodeName())) {
                    errorMessage = rpcErrorChild.getTextContent();
                    continue;
                }
                if (!ERROR_INFO.equals(rpcErrorChild.getNodeName())) continue;
                errorInfo = DocumentedException.parseErrorInfo(rpcErrorChild);
            }
            break;
        }
        return new DocumentedException(errorMessage, errorType, errorTag, errorSeverity, errorInfo);
    }

    private static Map<String, String> parseErrorInfo(Node node) {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            infoMap.put(child.getNodeName(), child.getTextContent());
        }
        return infoMap;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public ErrorTag getErrorTag() {
        return this.errorTag;
    }

    public ErrorSeverity getErrorSeverity() {
        return this.errorSeverity;
    }

    public Map<String, String> getErrorInfo() {
        return this.errorInfo;
    }

    public Document toXMLDocument() {
        Document doc = null;
        try {
            doc = BUILDER_FACTORY.newDocumentBuilder().newDocument();
            Element rpcReply = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "rpc-reply");
            doc.appendChild(rpcReply);
            Element rpcError = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", RPC_ERROR);
            rpcReply.appendChild(rpcError);
            rpcError.appendChild(this.createTextNode(doc, ERROR_TYPE, this.getErrorType().getTypeValue()));
            rpcError.appendChild(this.createTextNode(doc, ERROR_TAG, this.getErrorTag().getTagValue()));
            rpcError.appendChild(this.createTextNode(doc, ERROR_SEVERITY, this.getErrorSeverity().getSeverityValue()));
            rpcError.appendChild(this.createTextNode(doc, ERROR_MESSAGE, this.getLocalizedMessage()));
            Map<String, String> errorInfoMap = this.getErrorInfo();
            if (errorInfoMap != null && !errorInfoMap.isEmpty()) {
                Element errorInfoNode = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", ERROR_INFO);
                errorInfoNode.setPrefix(rpcReply.getPrefix());
                rpcError.appendChild(errorInfoNode);
                for (Map.Entry<String, String> entry : errorInfoMap.entrySet()) {
                    errorInfoNode.appendChild(this.createTextNode(doc, entry.getKey(), entry.getValue()));
                }
            }
        }
        catch (ParserConfigurationException e) {
            LOG.error("Error outputting to XML document", (Throwable)e);
        }
        return doc;
    }

    private Node createTextNode(Document doc, String tag, String textContent) {
        Element node = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", tag);
        node.setTextContent(textContent);
        return node;
    }

    @Override
    public String toString() {
        return "NetconfDocumentedException{message=" + this.getMessage() + ", errorType=" + (Object)((Object)this.errorType) + ", errorTag=" + (Object)((Object)this.errorTag) + ", errorSeverity=" + (Object)((Object)this.errorSeverity) + ", errorInfo=" + this.errorInfo + '}';
    }

    static {
        try {
            BUILDER_FACTORY.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            BUILDER_FACTORY.setFeature("http://xml.org/sax/features/external-general-entities", false);
            BUILDER_FACTORY.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            BUILDER_FACTORY.setXIncludeAware(false);
            BUILDER_FACTORY.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        BUILDER_FACTORY.setNamespaceAware(true);
        BUILDER_FACTORY.setCoalescing(true);
        BUILDER_FACTORY.setIgnoringElementContentWhitespace(true);
        BUILDER_FACTORY.setIgnoringComments(true);
    }

    public static enum ErrorSeverity {
        ERROR("error"),
        WARNING("warning");

        private final String severityValue;

        private ErrorSeverity(String severityValue) {
            this.severityValue = (String)Preconditions.checkNotNull((Object)severityValue);
        }

        public String getSeverityValue() {
            return this.severityValue;
        }

        public static ErrorSeverity from(String text) {
            for (ErrorSeverity e : ErrorSeverity.values()) {
                if (!e.getSeverityValue().equalsIgnoreCase(text)) continue;
                return e;
            }
            return ERROR;
        }
    }

    public static enum ErrorTag {
        ACCESS_DENIED("access-denied"),
        BAD_ATTRIBUTE("bad-attribute"),
        BAD_ELEMENT("bad-element"),
        DATA_EXISTS("data-exists"),
        DATA_MISSING("data-missing"),
        IN_USE("in-use"),
        INVALID_VALUE("invalid-value"),
        LOCK_DENIED("lock-denied"),
        MALFORMED_MESSAGE("malformed-message"),
        MISSING_ATTRIBUTE("missing-attribute"),
        MISSING_ELEMENT("missing-element"),
        OPERATION_FAILED("operation-failed"),
        OPERATION_NOT_SUPPORTED("operation-not-supported"),
        RESOURCE_DENIED("resource-denied"),
        ROLLBCK_FAILED("rollback-failed"),
        TOO_BIG("too-big"),
        UNKNOWN_ATTRIBUTE("unknown-attribute"),
        UNKNOWN_ELEMENT("unknown-element"),
        UNKNOWN_NAMESPACE("unknown-namespace");

        private final String tagValue;

        private ErrorTag(String tagValue) {
            this.tagValue = tagValue;
        }

        public String getTagValue() {
            return this.tagValue;
        }

        public static ErrorTag from(String text) {
            for (ErrorTag e : ErrorTag.values()) {
                if (!e.getTagValue().equals(text)) continue;
                return e;
            }
            return OPERATION_FAILED;
        }
    }

    public static enum ErrorType {
        TRANSPORT("transport"),
        RPC("rpc"),
        PROTOCOL("protocol"),
        APPLICATION("application");

        private final String typeValue;

        private ErrorType(String typeValue) {
            this.typeValue = (String)Preconditions.checkNotNull((Object)typeValue);
        }

        public String getTypeValue() {
            return this.typeValue;
        }

        public static ErrorType from(String text) {
            for (ErrorType e : ErrorType.values()) {
                if (!e.getTypeValue().equalsIgnoreCase(text)) continue;
                return e;
            }
            return APPLICATION;
        }
    }
}

