/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class NetconfMessage {
    private static final Transformer TRANSFORMER;
    private final Document doc;

    public NetconfMessage() {
        this.doc = null;
    }

    public NetconfMessage(Document doc) {
        this.doc = doc;
    }

    public Document getDocument() {
        return this.doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(this.doc.getDocumentElement());
        try {
            Transformer transformer = TRANSFORMER;
            synchronized (transformer) {
                TRANSFORMER.transform(source, result);
            }
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Failed to encode document", e);
        }
        return result.getWriter().toString();
    }

    static {
        Transformer t;
        try {
            t = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException | TransformerFactoryConfigurationError e) {
            throw new ExceptionInInitializerError(e);
        }
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("omit-xml-declaration", "yes");
        TRANSFORMER = t;
    }
}

