/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.coordinator;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.equinox.coordinator.CoordinationImpl;
import org.eclipse.equinox.coordinator.CoordinationReferent;
import org.eclipse.equinox.coordinator.CoordinationTimerTask;
import org.eclipse.equinox.coordinator.CoordinationWeakReference;
import org.eclipse.equinox.coordinator.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;
import org.osgi.service.coordinator.CoordinationPermission;
import org.osgi.service.coordinator.Coordinator;
import org.osgi.service.coordinator.Participant;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinatorImpl
implements Coordinator {
    private static long lastId;
    private static final Map<Long, CoordinationImpl> idToCoordination;
    private static final Map<Participant, CoordinationImpl> participantToCoordination;
    private static ThreadLocal<WeakCoordinationStack> coordinationStack;
    private final Bundle bundle;
    private final List<CoordinationImpl> coordinations;
    private final LogService logService;
    private final long maxTimeout;
    private final Timer timer;
    private boolean shutdown;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        idToCoordination = new HashMap<Long, CoordinationImpl>();
        participantToCoordination = new IdentityHashMap<Participant, CoordinationImpl>();
        coordinationStack = new ThreadLocal<WeakCoordinationStack>(){

            @Override
            protected WeakCoordinationStack initialValue() {
                return new WeakCoordinationStack();
            }
        };
    }

    private static synchronized long getNextId() {
        if (Long.MAX_VALUE == lastId) {
            throw new IllegalStateException(Messages.MaxCoordinationIdExceeded);
        }
        return ++lastId;
    }

    public CoordinatorImpl(Bundle bundle, LogService logService, Timer timer, long maxTimeout) {
        this.bundle = bundle;
        this.logService = logService;
        this.timer = timer;
        this.coordinations = new ArrayList<CoordinationImpl>();
        if (maxTimeout < 0L) {
            throw new IllegalArgumentException(Messages.InvalidTimeInterval);
        }
        this.maxTimeout = maxTimeout;
    }

    @Override
    public boolean addParticipant(Participant participant) throws CoordinationException {
        CoordinationWeakReference.processOrphanedCoordinations();
        Coordination coordination = this.peek();
        if (coordination == null) {
            return false;
        }
        coordination.addParticipant(participant);
        return true;
    }

    @Override
    public Coordination begin(String name, long timeout) {
        Coordination coordination = this.create(name, timeout);
        coordination.push();
        return coordination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Coordination create(String name, long timeout) {
        CoordinationWeakReference.processOrphanedCoordinations();
        this.checkPermission("initiate", name);
        if (this.maxTimeout != 0L && (timeout == 0L || this.maxTimeout < timeout)) {
            this.logService.log(2, NLS.bind(Messages.MaximumTimeout, new Long(timeout), new Long(this.maxTimeout)));
            timeout = this.maxTimeout;
        }
        CoordinationImpl coordination = new CoordinationImpl(CoordinatorImpl.getNextId(), name, timeout, this);
        CoordinationReferent referent = new CoordinationReferent(coordination);
        coordination.reference = new CoordinationWeakReference(referent, coordination);
        CoordinatorImpl coordinatorImpl = this;
        synchronized (coordinatorImpl) {
            if (this.shutdown) {
                throw new IllegalStateException(Messages.CoordinatorShutdown);
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.coordinator.CoordinatorImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                this.coordinations.add(coordination);
                idToCoordination.put(new Long(coordination.getId()), coordination);
                // ** MonitorExit[var7_6] (shouldn't be in output)
            }
        }
        {
            if (timeout > 0L) {
                CoordinationTimerTask timerTask = new CoordinationTimerTask(coordination);
                coordination.setTimerTask(timerTask);
            }
            return referent;
        }
    }

    @Override
    public boolean fail(Throwable reason) {
        CoordinationWeakReference.processOrphanedCoordinations();
        Coordination coordination = this.peek();
        if (coordination == null) {
            return false;
        }
        return coordination.fail(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Coordination getCoordination(long id) {
        CoordinationWeakReference.processOrphanedCoordinations();
        CoordinationReferent result = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.coordinator.CoordinatorImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            CoordinationImpl c = idToCoordination.get(new Long(id));
            if (c != null) {
                result = c.getReferent();
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (result != null && !result.isTerminated()) {
                try {
                    this.checkPermission("admin", result.getName());
                }
                catch (SecurityException e) {
                    this.logService.log(4, Messages.GetCoordinationNotPermitted, (Throwable)e);
                    result = null;
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Coordination> getCoordinations() {
        CoordinationWeakReference.processOrphanedCoordinations();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.coordinator.CoordinatorImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            ArrayList<Coordination> result = new ArrayList<Coordination>(idToCoordination.size());
            for (CoordinationImpl coordination : idToCoordination.values()) {
                if (coordination.isTerminated()) continue;
                try {
                    this.checkPermission("admin", coordination.getName());
                    result.add(coordination.getReferent());
                }
                catch (SecurityException e) {
                    this.logService.log(4, Messages.GetCoordinationNotPermitted, (Throwable)e);
                }
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            result.trimToSize();
            return result;
        }
    }

    @Override
    public Coordination peek() {
        CoordinationWeakReference.processOrphanedCoordinations();
        CoordinationImpl c = coordinationStack.get().peek();
        if (c == null) {
            return null;
        }
        return c.getReferent();
    }

    @Override
    public Coordination pop() {
        CoordinationWeakReference.processOrphanedCoordinations();
        CoordinationImpl c = coordinationStack.get().peek();
        if (c == null) {
            return null;
        }
        this.checkPermission("initiate", c.getName());
        return coordinationStack.get().pop().getReferent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CoordinationImpl addParticipant(Participant participant, CoordinationImpl coordination) {
        CoordinationImpl result = null;
        Map<Participant, CoordinationImpl> map = participantToCoordination;
        synchronized (map) {
            result = participantToCoordination.get(participant);
            if (result == null) {
                participantToCoordination.put(participant, coordination);
            }
        }
        return result;
    }

    void checkPermission(String permissionType, String coordinationName) {
        this.checkPermission(new CoordinationPermission(coordinationName, this.bundle, permissionType));
    }

    void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        securityManager.checkPermission(permission);
    }

    Bundle getBundle() {
        return this.bundle;
    }

    LogService getLogService() {
        return this.logService;
    }

    long getMaxTimeout() {
        return this.maxTimeout;
    }

    void purge() {
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.util.Timer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            clazz.getMethod("purge", null).invoke((Object)this.timer, null);
        }
        catch (Exception e) {
            this.logService.log(4, Messages.CanceledTaskNotPurged, (Throwable)e);
        }
    }

    void push(CoordinationImpl coordination) throws CoordinationException {
        coordinationStack.get().push(coordination);
    }

    void schedule(TimerTask task, Date deadline) {
        this.timer.schedule(task, deadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        ArrayList<CoordinationImpl> coords;
        CoordinationWeakReference.processOrphanedCoordinations();
        CoordinatorImpl coordinatorImpl = this;
        synchronized (coordinatorImpl) {
            this.shutdown = true;
            coords = new ArrayList<CoordinationImpl>(this.coordinations);
        }
        for (CoordinationImpl coordination : coords) {
            coordination.fail(Coordination.RELEASED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate(CoordinationImpl coordination, List<Participant> participants) {
        CoordinatorImpl coordinatorImpl = this;
        synchronized (coordinatorImpl) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.coordinator.CoordinatorImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                this.coordinations.remove(coordination);
                idToCoordination.remove(new Long(coordination.getId()));
                participantToCoordination.keySet().removeAll(participants);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
    }

    private static class WeakCoordinationStack {
        private final LinkedList<CoordinationImpl> coordinations = new LinkedList();

        public boolean contains(CoordinationImpl c) {
            return this.coordinations.contains(c);
        }

        public CoordinationImpl peek() {
            if (this.coordinations.isEmpty()) {
                return null;
            }
            return this.coordinations.getFirst();
        }

        public CoordinationImpl pop() {
            if (this.coordinations.isEmpty()) {
                return null;
            }
            CoordinationImpl c = this.coordinations.removeFirst();
            if (c != null) {
                c.setThreadAndEnclosingCoordination(null, null);
            }
            return c;
        }

        public void push(CoordinationImpl c) {
            if (this.contains(c)) {
                throw new CoordinationException(Messages.CoordinationAlreadyExists, c.getReferent(), 5);
            }
            c.setThreadAndEnclosingCoordination(Thread.currentThread(), this.coordinations.isEmpty() ? null : this.coordinations.getFirst());
            this.coordinations.addFirst(c);
        }
    }
}

