/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.akka.impl;

import akka.actor.ActorSystem;
import akka.actor.Props;
import com.typesafe.config.Config;
import java.util.EventListener;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.cluster.ActorSystemProviderListener;
import org.opendaylight.controller.cluster.datastore.TerminationMonitor;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class ActorSystemProviderImpl
implements ActorSystemProvider,
AutoCloseable {
    private static final String ACTOR_SYSTEM_NAME = "opendaylight-cluster-data";
    private static final Logger LOG = LoggerFactory.getLogger(ActorSystemProviderImpl.class);
    private final ActorSystem actorSystem;
    private final ListenerRegistry<ActorSystemProviderListener> listeners = new ListenerRegistry();

    public ActorSystemProviderImpl(ClassLoader classLoader, Props quarantinedMonitorActorProps, Config akkaConfig) {
        LOG.info("Creating new ActorSystem");
        this.actorSystem = ActorSystem.create((String)ACTOR_SYSTEM_NAME, (Config)akkaConfig, (ClassLoader)classLoader);
        this.actorSystem.actorOf(Props.create(TerminationMonitor.class, (Object[])new Object[0]), "termination-monitor");
        this.actorSystem.actorOf(quarantinedMonitorActorProps, "quarantined-monitor");
    }

    public ActorSystem getActorSystem() {
        return this.actorSystem;
    }

    public ListenerRegistration<ActorSystemProviderListener> registerActorSystemProviderListener(ActorSystemProviderListener listener) {
        return this.listeners.register((EventListener)listener);
    }

    @Override
    public void close() {
        LOG.info("Shutting down ActorSystem");
        try {
            Await.result((Awaitable)this.actorSystem.terminate(), (Duration)FiniteDuration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        }
        catch (Exception e) {
            LOG.warn("Error awaiting actor termination", (Throwable)e);
        }
    }
}

