/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.opendaylight.controller.cluster.databroker.AbstractDOMBrokerTransaction;
import org.opendaylight.controller.cluster.databroker.AbstractDOMTransactionFactory;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.broker.TransactionCommitFailedExceptionMapper;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionFactory;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDOMBrokerWriteTransaction<T extends DOMStoreWriteTransaction>
extends AbstractDOMBrokerTransaction<T>
implements DOMDataTreeWriteTransaction {
    private static final AtomicReferenceFieldUpdater<AbstractDOMBrokerWriteTransaction, AbstractDOMTransactionFactory> IMPL_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractDOMBrokerWriteTransaction.class, AbstractDOMTransactionFactory.class, "commitImpl");
    private static final AtomicReferenceFieldUpdater<AbstractDOMBrokerWriteTransaction, Future> FUTURE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractDOMBrokerWriteTransaction.class, Future.class, "commitFuture");
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDOMBrokerWriteTransaction.class);
    private static final Future<?> CANCELLED_FUTURE = Futures.immediateCancelledFuture();
    private volatile AbstractDOMTransactionFactory<?> commitImpl;
    private volatile Future<?> commitFuture;

    protected AbstractDOMBrokerWriteTransaction(Object identifier, Map<LogicalDatastoreType, ? extends DOMStoreTransactionFactory> storeTxFactories, AbstractDOMTransactionFactory<?> commitImpl) {
        super(identifier, storeTxFactories);
        this.commitImpl = (AbstractDOMTransactionFactory)Preconditions.checkNotNull(commitImpl, (Object)"commitImpl must not be null.");
    }

    public void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.checkRunning(this.commitImpl);
        AbstractDOMBrokerWriteTransaction.checkInstanceIdentifierReferencesData(path, data);
        ((DOMStoreWriteTransaction)this.getSubtransaction(store)).write(path, data);
    }

    private static void checkInstanceIdentifierReferencesData(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (String)"Attempted to store null data at %s", (Object)path);
        YangInstanceIdentifier.PathArgument lastArg = path.getLastPathArgument();
        Preconditions.checkArgument((lastArg == data.getIdentifier() || lastArg != null && lastArg.equals(data.getIdentifier()) ? 1 : 0) != 0, (String)"Instance identifier references %s but data identifier is %s", (Object)lastArg, data);
    }

    public void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        this.checkRunning(this.commitImpl);
        ((DOMStoreWriteTransaction)this.getSubtransaction(store)).delete(path);
    }

    public void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.checkRunning(this.commitImpl);
        AbstractDOMBrokerWriteTransaction.checkInstanceIdentifierReferencesData(path, data);
        ((DOMStoreWriteTransaction)this.getSubtransaction(store)).merge(path, data);
    }

    public boolean cancel() {
        Future<?> future;
        AbstractDOMTransactionFactory impl = IMPL_UPDATER.getAndSet(this, null);
        if (impl != null) {
            LOG.trace("Transaction {} cancelled before submit", this.getIdentifier());
            FUTURE_UPDATER.lazySet(this, CANCELLED_FUTURE);
            this.closeSubtransactions();
            return true;
        }
        while ((future = this.commitFuture) == null) {
        }
        return future.cancel(false);
    }

    public FluentFuture<? extends CommitInfo> commit() {
        FluentFuture<CommitInfo> ret;
        AbstractDOMTransactionFactory impl = IMPL_UPDATER.getAndSet(this, null);
        this.checkRunning(impl);
        Collection txns = this.getSubtransactions();
        ArrayList<DOMStoreThreePhaseCommitCohort> cohorts = new ArrayList<DOMStoreThreePhaseCommitCohort>(txns.size());
        try {
            for (DOMStoreWriteTransaction txn : txns) {
                cohorts.add(txn.ready());
            }
            ret = impl.commit(this, cohorts);
        }
        catch (RuntimeException e) {
            ret = FluentFuture.from((ListenableFuture)Futures.immediateFailedFuture((Throwable)TransactionCommitFailedExceptionMapper.COMMIT_ERROR_MAPPER.apply((Exception)e)));
        }
        FUTURE_UPDATER.lazySet(this, (Future)ret);
        return ret;
    }

    private void checkRunning(AbstractDOMTransactionFactory<?> impl) {
        Preconditions.checkState((impl != null ? 1 : 0) != 0, (String)"Transaction %s is no longer running", (Object)this.getIdentifier());
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("running", this.commitImpl == null);
    }
}

