/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.opendaylight.controller.cluster.databroker.AbstractDOMBroker;
import org.opendaylight.controller.cluster.databroker.AbstractDOMTransactionFactory;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DOMBrokerTransactionChain
extends AbstractDOMTransactionFactory<DOMStoreTransactionChain>
implements DOMTransactionChain {
    private static final AtomicIntegerFieldUpdater<DOMBrokerTransactionChain> COUNTER_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DOMBrokerTransactionChain.class, "counter");
    private static final AtomicReferenceFieldUpdater<DOMBrokerTransactionChain, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DOMBrokerTransactionChain.class, State.class, "state");
    private static final Logger LOG = LoggerFactory.getLogger(DOMBrokerTransactionChain.class);
    private final AtomicLong txNum = new AtomicLong();
    private final AbstractDOMBroker broker;
    private final DOMTransactionChainListener listener;
    private final long chainId;
    private volatile State state = State.RUNNING;
    private volatile int counter = 0;

    DOMBrokerTransactionChain(long chainId, Map<LogicalDatastoreType, DOMStoreTransactionChain> chains, AbstractDOMBroker broker, DOMTransactionChainListener listener) {
        super(chains);
        this.chainId = chainId;
        this.broker = (AbstractDOMBroker)Preconditions.checkNotNull((Object)broker);
        this.listener = (DOMTransactionChainListener)Preconditions.checkNotNull((Object)listener);
    }

    private void checkNotFailed() {
        Preconditions.checkState((this.state != State.FAILED ? 1 : 0) != 0, (Object)"Transaction chain has failed");
    }

    @Override
    protected Object newTransactionIdentifier() {
        return "DOM-CHAIN-" + this.chainId + "-" + this.txNum.getAndIncrement();
    }

    @Override
    public FluentFuture<? extends CommitInfo> commit(final DOMDataTreeWriteTransaction transaction, Collection<DOMStoreThreePhaseCommitCohort> cohorts) {
        this.checkNotFailed();
        this.checkNotClosed();
        FluentFuture<CommitInfo> ret = this.broker.commit(transaction, cohorts);
        COUNTER_UPDATER.incrementAndGet(this);
        ret.addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                DOMBrokerTransactionChain.this.transactionCompleted();
            }

            public void onFailure(Throwable failure) {
                DOMBrokerTransactionChain.this.transactionFailed(transaction, failure);
            }
        }, MoreExecutors.directExecutor());
        return ret;
    }

    @Override
    public void close() {
        boolean success = STATE_UPDATER.compareAndSet(this, State.RUNNING, State.CLOSING);
        if (!success) {
            LOG.debug("Chain {} is no longer running", (Object)this);
            return;
        }
        super.close();
        for (DOMStoreTransactionChain subChain : this.getTxFactories().values()) {
            subChain.close();
        }
        if (this.counter == 0) {
            this.finishClose();
        }
    }

    private void finishClose() {
        this.state = State.CLOSED;
        this.listener.onTransactionChainSuccessful((DOMTransactionChain)this);
    }

    private void transactionCompleted() {
        if (COUNTER_UPDATER.decrementAndGet(this) == 0 && this.state == State.CLOSING) {
            this.finishClose();
        }
    }

    private void transactionFailed(DOMDataTreeWriteTransaction tx, Throwable cause) {
        this.state = State.FAILED;
        LOG.debug("Transaction chain {}\u00a0failed.", (Object)this, (Object)cause);
        this.listener.onTransactionChainFailed((DOMTransactionChain)this, (DOMDataTreeTransaction)tx, cause);
    }

    private static enum State {
        RUNNING,
        CLOSING,
        CLOSED,
        FAILED;

    }
}

