/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.Props;
import akka.japi.Creator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientActor;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.DistributedDataStoreClientBehavior;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;

public final class DistributedDataStoreClientActor
extends AbstractDataStoreClientActor {
    private DistributedDataStoreClientActor(FrontendIdentifier frontendId, ActorContext actorContext) {
        super(frontendId, actorContext);
    }

    @Override
    AbstractDataStoreClientBehavior initialBehavior(ClientActorContext context, ActorContext actorContext) {
        return new DistributedDataStoreClientBehavior(context, actorContext);
    }

    public static Props props(@Nonnull MemberName memberName, @Nonnull String storeName, ActorContext ctx) {
        String name = "datastore-" + storeName;
        FrontendIdentifier frontendId = FrontendIdentifier.create((MemberName)memberName, (FrontendType)FrontendType.forName((String)name));
        return Props.create(DistributedDataStoreClientActor.class, (Creator & Serializable)() -> new DistributedDataStoreClientActor(frontendId, ctx));
    }
}

