/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.base.Preconditions;
import java.util.concurrent.CompletionStage;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractShardBackendResolver;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
final class SimpleShardBackendResolver
extends AbstractShardBackendResolver {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleShardBackendResolver.class);
    private final String shardName;
    private volatile AbstractShardBackendResolver.ShardState state;

    SimpleShardBackendResolver(ClientIdentifier clientId, ActorContext actorContext, String shardName) {
        super(clientId, actorContext);
        this.shardName = (String)Preconditions.checkNotNull((Object)shardName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<ShardBackendInfo> getBackendInfo(long cookie) {
        Preconditions.checkArgument((cookie == 0L ? 1 : 0) != 0);
        AbstractShardBackendResolver.ShardState existing = this.state;
        if (existing != null) {
            return existing.getStage();
        }
        SimpleShardBackendResolver simpleShardBackendResolver = this;
        synchronized (simpleShardBackendResolver) {
            AbstractShardBackendResolver.ShardState newState;
            AbstractShardBackendResolver.ShardState recheck = this.state;
            if (recheck != null) {
                return recheck.getStage();
            }
            this.state = newState = this.resolveBackendInfo(this.shardName, 0L);
            CompletionStage<ShardBackendInfo> stage = newState.getStage();
            stage.whenComplete((info, failure) -> {
                if (failure != null) {
                    SimpleShardBackendResolver simpleShardBackendResolver = this;
                    synchronized (simpleShardBackendResolver) {
                        if (this.state == newState) {
                            this.state = null;
                        }
                    }
                }
            });
            return stage;
        }
    }

    public CompletionStage<ShardBackendInfo> getBackendInfo(Long cookie) {
        return this.getBackendInfo((long)cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<? extends ShardBackendInfo> refreshBackendInfo(Long cookie, ShardBackendInfo staleInfo) {
        AbstractShardBackendResolver.ShardState existing = this.state;
        if (existing != null) {
            if (!staleInfo.equals((Object)existing.getResult())) {
                return existing.getStage();
            }
            SimpleShardBackendResolver simpleShardBackendResolver = this;
            synchronized (simpleShardBackendResolver) {
                LOG.debug("Invalidating backend information {}", (Object)staleInfo);
                this.flushCache(this.shardName);
                LOG.trace("Invalidated cache {}", (Object)staleInfo);
                this.state = null;
            }
        }
        return this.getBackendInfo(cookie);
    }

    public String resolveCookieName(Long cookie) {
        return this.shardName;
    }
}

