/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.common.actor.Dispatchers;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.databroker.actors.dds.DistributedDataStoreClientActor;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.DataTreeChangeListenerProxy;
import org.opendaylight.controller.cluster.datastore.DataTreeCohortRegistrationProxy;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.DatastoreContextPropertiesUpdater;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardManagerIdentifier;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.DatastoreConfigurationMXBeanImpl;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.DatastoreInfoMXBeanImpl;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardManagerCreator;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.opendaylight.controller.cluster.datastore.utils.PrimaryShardInfoFutureCache;
import org.opendaylight.mdsal.dom.api.ClusteredDOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohort;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistration;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistry;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataStore
implements DistributedDataStoreInterface,
SchemaContextListener,
DatastoreContextPropertiesUpdater.Listener,
DOMStoreTreeChangePublisher,
DOMDataTreeCommitCohortRegistry,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataStore.class);
    private static final long READY_WAIT_FACTOR = 3L;
    private final ActorContext actorContext;
    private final long waitTillReadyTimeInMillis;
    private AutoCloseable closeable;
    private DatastoreConfigurationMXBeanImpl datastoreConfigMXBean;
    private DatastoreInfoMXBeanImpl datastoreInfoMXBean;
    private final CountDownLatch waitTillReadyCountDownLatch = new CountDownLatch(1);
    private final ClientIdentifier identifier;
    private final DataStoreClient client;

    protected AbstractDataStore(ActorSystem actorSystem, ClusterWrapper cluster, Configuration configuration, DatastoreContextFactory datastoreContextFactory, DatastoreSnapshot restoreFromSnapshot) {
        Preconditions.checkNotNull((Object)actorSystem, (Object)"actorSystem should not be null");
        Preconditions.checkNotNull((Object)cluster, (Object)"cluster should not be null");
        Preconditions.checkNotNull((Object)configuration, (Object)"configuration should not be null");
        Preconditions.checkNotNull((Object)datastoreContextFactory, (Object)"datastoreContextFactory should not be null");
        String shardManagerId = ShardManagerIdentifier.builder().type(datastoreContextFactory.getBaseDatastoreContext().getDataStoreName()).build().toString();
        LOG.info("Creating ShardManager : {}", (Object)shardManagerId);
        String shardDispatcher = new Dispatchers(actorSystem.dispatchers()).getDispatcherPath(Dispatchers.DispatcherType.Shard);
        PrimaryShardInfoFutureCache primaryShardInfoCache = new PrimaryShardInfoFutureCache();
        ShardManagerCreator creator = (ShardManagerCreator)((ShardManagerCreator)((ShardManagerCreator)((ShardManagerCreator)((ShardManagerCreator)((ShardManagerCreator)((ShardManagerCreator)new ShardManagerCreator().cluster(cluster)).configuration(configuration)).datastoreContextFactory(datastoreContextFactory)).waitTillReadyCountDownLatch(this.waitTillReadyCountDownLatch)).primaryShardInfoCache(primaryShardInfoCache)).restoreFromSnapshot(restoreFromSnapshot)).distributedDataStore(this);
        this.actorContext = new ActorContext(actorSystem, AbstractDataStore.createShardManager(actorSystem, creator, shardDispatcher, shardManagerId), cluster, configuration, datastoreContextFactory.getBaseDatastoreContext(), primaryShardInfoCache);
        Props clientProps = DistributedDataStoreClientActor.props(cluster.getCurrentMemberName(), datastoreContextFactory.getBaseDatastoreContext().getDataStoreName(), this.actorContext);
        ActorRef clientActor = actorSystem.actorOf(clientProps);
        try {
            this.client = DistributedDataStoreClientActor.getDistributedDataStoreClient(clientActor, 30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.error("Failed to get actor for {}", (Object)clientProps, (Object)e);
            clientActor.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        this.identifier = this.client.getIdentifier();
        LOG.debug("Distributed data store client {} started", (Object)this.identifier);
        this.waitTillReadyTimeInMillis = this.actorContext.getDatastoreContext().getShardLeaderElectionTimeout().duration().toMillis() * 3L;
        this.datastoreConfigMXBean = new DatastoreConfigurationMXBeanImpl(datastoreContextFactory.getBaseDatastoreContext().getDataStoreMXBeanType());
        this.datastoreConfigMXBean.setContext(datastoreContextFactory.getBaseDatastoreContext());
        this.datastoreConfigMXBean.registerMBean();
        this.datastoreInfoMXBean = new DatastoreInfoMXBeanImpl(datastoreContextFactory.getBaseDatastoreContext().getDataStoreMXBeanType(), this.actorContext);
        this.datastoreInfoMXBean.registerMBean();
    }

    @VisibleForTesting
    protected AbstractDataStore(ActorContext actorContext, ClientIdentifier identifier) {
        this.actorContext = (ActorContext)Preconditions.checkNotNull((Object)actorContext, (Object)"actorContext should not be null");
        this.client = null;
        this.identifier = (ClientIdentifier)Preconditions.checkNotNull((Object)identifier);
        this.waitTillReadyTimeInMillis = actorContext.getDatastoreContext().getShardLeaderElectionTimeout().duration().toMillis() * 3L;
    }

    @VisibleForTesting
    protected AbstractDataStore(ActorContext actorContext, ClientIdentifier identifier, DataStoreClient clientActor) {
        this.actorContext = (ActorContext)Preconditions.checkNotNull((Object)actorContext, (Object)"actorContext should not be null");
        this.client = clientActor;
        this.identifier = (ClientIdentifier)Preconditions.checkNotNull((Object)identifier);
        this.waitTillReadyTimeInMillis = actorContext.getDatastoreContext().getShardLeaderElectionTimeout().duration().toMillis() * 3L;
    }

    protected final DataStoreClient getClient() {
        return this.client;
    }

    final ClientIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setCloseable(AutoCloseable closeable) {
        this.closeable = closeable;
    }

    public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerTreeChangeListener(YangInstanceIdentifier treeId, L listener) {
        Preconditions.checkNotNull((Object)treeId, (Object)"treeId should not be null");
        Preconditions.checkNotNull(listener, (Object)"listener should not be null");
        String shardName = this.actorContext.getShardStrategyFactory().getStrategy(treeId).findShard(treeId);
        LOG.debug("Registering tree listener: {} for tree: {} shard: {}", new Object[]{listener, treeId, shardName});
        DataTreeChangeListenerProxy<L> listenerRegistrationProxy = new DataTreeChangeListenerProxy<L>(this.actorContext, listener, treeId);
        listenerRegistrationProxy.init(shardName);
        return listenerRegistrationProxy;
    }

    public <C extends DOMDataTreeCommitCohort> DOMDataTreeCommitCohortRegistration<C> registerCommitCohort(DOMDataTreeIdentifier subtree, C cohort) {
        YangInstanceIdentifier treeId = ((DOMDataTreeIdentifier)Preconditions.checkNotNull((Object)subtree, (Object)"subtree should not be null")).getRootIdentifier();
        Preconditions.checkNotNull(cohort, (Object)"listener should not be null");
        String shardName = this.actorContext.getShardStrategyFactory().getStrategy(treeId).findShard(treeId);
        LOG.debug("Registering cohort: {} for tree: {} shard: {}", new Object[]{cohort, treeId, shardName});
        DataTreeCohortRegistrationProxy<C> cohortProxy = new DataTreeCohortRegistrationProxy<C>(this.actorContext, subtree, cohort);
        cohortProxy.init(shardName);
        return cohortProxy;
    }

    public void onGlobalContextUpdated(SchemaContext schemaContext) {
        this.actorContext.setSchemaContext(schemaContext);
    }

    @Override
    public void onDatastoreContextUpdated(DatastoreContextFactory contextFactory) {
        LOG.info("DatastoreContext updated for data store {}", (Object)this.actorContext.getDataStoreName());
        this.actorContext.setDatastoreContext(contextFactory);
        this.datastoreConfigMXBean.setContext(contextFactory.getBaseDatastoreContext());
    }

    @Override
    public void close() {
        LOG.info("Closing data store {}", (Object)this.identifier);
        if (this.datastoreConfigMXBean != null) {
            this.datastoreConfigMXBean.unregisterMBean();
        }
        if (this.datastoreInfoMXBean != null) {
            this.datastoreInfoMXBean.unregisterMBean();
        }
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (Exception e) {
                LOG.debug("Error closing instance", (Throwable)e);
            }
        }
        this.actorContext.shutdown();
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public ActorContext getActorContext() {
        return this.actorContext;
    }

    public void waitTillReady() {
        LOG.info("Beginning to wait for data store to become ready : {}", (Object)this.identifier);
        try {
            if (this.waitTillReadyCountDownLatch.await(this.waitTillReadyTimeInMillis, TimeUnit.MILLISECONDS)) {
                LOG.debug("Data store {} is now ready", (Object)this.identifier);
            } else {
                LOG.error("Shard leaders failed to settle in {} seconds, giving up", (Object)TimeUnit.MILLISECONDS.toSeconds(this.waitTillReadyTimeInMillis));
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while waiting for shards to settle", (Throwable)e);
        }
    }

    private static ActorRef createShardManager(ActorSystem actorSystem, ShardManagerCreator creator, String shardDispatcher, String shardManagerId) {
        Exception lastException = null;
        for (int i = 0; i < 100; ++i) {
            try {
                return actorSystem.actorOf(creator.props().withDispatcher(shardDispatcher), shardManagerId);
            }
            catch (Exception e) {
                lastException = e;
                Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                LOG.debug("Could not create actor {} because of {} - waiting for sometime before retrying (retry count = {})", new Object[]{shardManagerId, e.getMessage(), i});
                continue;
            }
        }
        throw new IllegalStateException("Failed to create Shard Manager", lastException);
    }

    @VisibleForTesting
    public CountDownLatch getWaitTillReadyCountDownLatch() {
        return this.waitTillReadyCountDownLatch;
    }

    public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerProxyListener(YangInstanceIdentifier shardLookup, YangInstanceIdentifier insideShard, DOMDataTreeChangeListener delegate) {
        Preconditions.checkNotNull((Object)shardLookup, (Object)"shardLookup should not be null");
        Preconditions.checkNotNull((Object)insideShard, (Object)"insideShard should not be null");
        Preconditions.checkNotNull((Object)delegate, (Object)"delegate should not be null");
        String shardName = this.actorContext.getShardStrategyFactory().getStrategy(shardLookup).findShard(shardLookup);
        LOG.debug("Registering tree listener: {} for tree: {} shard: {}, path inside shard: {}", new Object[]{delegate, shardLookup, shardName, insideShard});
        DataTreeChangeListenerProxy<ClusteredDOMDataTreeChangeListener> listenerRegistrationProxy = new DataTreeChangeListenerProxy<ClusteredDOMDataTreeChangeListener>(this.actorContext, arg_0 -> ((DOMDataTreeChangeListener)delegate).onDataTreeChanged(arg_0), insideShard);
        listenerRegistrationProxy.init(shardName);
        return listenerRegistrationProxy;
    }

    public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerShardConfigListener(YangInstanceIdentifier internalPath, DOMDataTreeChangeListener delegate) {
        Preconditions.checkNotNull((Object)delegate, (Object)"delegate should not be null");
        LOG.debug("Registering a listener for the configuration shard: {}", (Object)internalPath);
        DataTreeChangeListenerProxy<DOMDataTreeChangeListener> proxy = new DataTreeChangeListenerProxy<DOMDataTreeChangeListener>(this.actorContext, delegate, internalPath);
        proxy.init("prefix-configuration-shard");
        return proxy;
    }
}

