/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshotList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatastoreSnapshotRestore {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreSnapshotRestore.class);
    private static AtomicReference<DatastoreSnapshotRestore> instance = new AtomicReference();
    private final String restoreDirectoryPath;
    private final Map<String, DatastoreSnapshot> datastoreSnapshots = new ConcurrentHashMap<String, DatastoreSnapshot>();

    public static DatastoreSnapshotRestore instance(String restoreDirectoryPath) {
        instance.compareAndSet(null, new DatastoreSnapshotRestore(restoreDirectoryPath));
        return instance.get();
    }

    private DatastoreSnapshotRestore(String restoreDirectoryPath) {
        this.restoreDirectoryPath = (String)Preconditions.checkNotNull((Object)restoreDirectoryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initialize() {
        File restoreDirectoryFile = new File(this.restoreDirectoryPath);
        String[] files = restoreDirectoryFile.list();
        if (files == null || files.length == 0) {
            LOG.debug("Restore directory {} does not exist or is empty", (Object)restoreDirectoryFile);
            return;
        }
        if (files.length > 1) {
            LOG.error("Found {} files in clustered datastore restore directory {} - expected 1. No restore will be attempted", (Object)files.length, (Object)restoreDirectoryFile);
            return;
        }
        File restoreFile = new File(restoreDirectoryFile, files[0]);
        LOG.info("Clustered datastore will be restored from file {}", (Object)restoreFile);
        try (FileInputStream fis = new FileInputStream(restoreFile);){
            DatastoreSnapshotList snapshots = DatastoreSnapshotRestore.deserialize(fis);
            LOG.debug("Deserialized {} snapshots", (Object)snapshots.size());
            for (DatastoreSnapshot snapshot : snapshots) {
                this.datastoreSnapshots.put(snapshot.getType(), snapshot);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.error("Error reading clustered datastore restore file {}", (Object)restoreFile, (Object)e);
        }
        finally {
            if (!restoreFile.delete()) {
                LOG.error("Could not delete clustered datastore restore file {}", (Object)restoreFile);
            }
        }
    }

    private static DatastoreSnapshotList deserialize(InputStream inputStream) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(inputStream);){
            DatastoreSnapshotList datastoreSnapshotList = (DatastoreSnapshotList)ois.readObject();
            return datastoreSnapshotList;
        }
    }

    public DatastoreSnapshot getAndRemove(String datastoreType) {
        this.initialize();
        return this.datastoreSnapshots.remove(datastoreType);
    }
}

