/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeChangeListenerPublisher;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.spi.AbstractDOMDataTreeChangeListenerRegistration;
import org.opendaylight.mdsal.dom.spi.store.AbstractDOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class DefaultShardDataTreeChangeListenerPublisher
extends AbstractDOMStoreTreeChangePublisher
implements ShardDataTreeChangeListenerPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultShardDataTreeChangeListenerPublisher.class);
    private String logContext;

    DefaultShardDataTreeChangeListenerPublisher(String logContext) {
        this.logContext = logContext;
    }

    @Override
    public void publishChanges(DataTreeCandidate candidate) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: publishChanges: {}", (Object)this.logContext, (Object)candidate);
        } else {
            LOG.debug("{}: publishChanges: rootPath: {}", (Object)this.logContext, (Object)candidate.getRootPath());
        }
        this.processCandidateTree(candidate);
    }

    protected void notifyListener(AbstractDOMDataTreeChangeListenerRegistration<?> registration, Collection<DataTreeCandidate> changes) {
        LOG.debug("{}: notifyListener: listener: {}", (Object)this.logContext, registration.getInstance());
        ((DOMDataTreeChangeListener)registration.getInstance()).onDataTreeChanged(changes);
    }

    protected void registrationRemoved(AbstractDOMDataTreeChangeListenerRegistration<?> registration) {
        LOG.debug("Registration {} removed", registration);
    }

    @Override
    public void registerTreeChangeListener(YangInstanceIdentifier treeId, DOMDataTreeChangeListener listener, Optional<DataTreeCandidate> initialState, Consumer<ListenerRegistration<DOMDataTreeChangeListener>> onRegistration) {
        this.registerTreeChangeListener(treeId, listener, onRegistration);
        if (initialState.isPresent()) {
            DefaultShardDataTreeChangeListenerPublisher.notifySingleListener(treeId, listener, (DataTreeCandidate)initialState.get(), this.logContext);
        } else {
            listener.onInitialData();
        }
    }

    void registerTreeChangeListener(YangInstanceIdentifier treeId, DOMDataTreeChangeListener listener, Consumer<ListenerRegistration<DOMDataTreeChangeListener>> onRegistration) {
        LOG.debug("{}: registerTreeChangeListener: path: {}, listener: {}", new Object[]{this.logContext, treeId, listener});
        AbstractDOMDataTreeChangeListenerRegistration registration = super.registerTreeChangeListener(treeId, listener);
        onRegistration.accept((ListenerRegistration<DOMDataTreeChangeListener>)registration);
    }

    static void notifySingleListener(YangInstanceIdentifier treeId, DOMDataTreeChangeListener listener, DataTreeCandidate state, String logContext) {
        LOG.debug("{}: notifySingleListener: path: {}, listener: {}", new Object[]{logContext, treeId, listener});
        DefaultShardDataTreeChangeListenerPublisher publisher = new DefaultShardDataTreeChangeListenerPublisher(logContext);
        publisher.logContext = logContext;
        publisher.registerTreeChangeListener(treeId, listener);
        if (!publisher.processCandidateTree(state)) {
            listener.onInitialData();
        }
    }
}

