/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import java.util.EventListener;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.cluster.datastore.DataTreeChangeListenerSupport;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeChangeListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;

class DelayedDataTreeChangeListenerRegistration<L extends EventListener>
implements ListenerRegistration<L> {
    private final RegisterDataTreeChangeListener registrationMessage;
    private final ActorRef registrationActor;
    @GuardedBy(value="this")
    private boolean closed;

    DelayedDataTreeChangeListenerRegistration(RegisterDataTreeChangeListener registrationMessage, ActorRef registrationActor) {
        this.registrationMessage = registrationMessage;
        this.registrationActor = registrationActor;
    }

    synchronized void doRegistration(DataTreeChangeListenerSupport support) {
        if (!this.closed) {
            support.doRegistration(this.registrationMessage, this.registrationActor);
        }
    }

    public L getInstance() {
        throw new UnsupportedOperationException("getInstance should not be called on this instance since it could be null");
    }

    public synchronized void close() {
        this.closed = true;
    }
}

