/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.Executor;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTransactionContext;
import org.opendaylight.controller.cluster.datastore.LocalThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.LocalTransactionReadySupport;
import org.opendaylight.controller.cluster.datastore.messages.AbstractRead;
import org.opendaylight.controller.cluster.datastore.modification.AbstractModification;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import scala.concurrent.Future;

abstract class LocalTransactionContext
extends AbstractTransactionContext {
    private final DOMStoreTransaction txDelegate;
    private final LocalTransactionReadySupport readySupport;
    private Exception operationError;

    LocalTransactionContext(DOMStoreTransaction txDelegate, TransactionIdentifier identifier, LocalTransactionReadySupport readySupport) {
        super(identifier);
        this.txDelegate = (DOMStoreTransaction)Preconditions.checkNotNull((Object)txDelegate);
        this.readySupport = readySupport;
    }

    protected abstract DOMStoreWriteTransaction getWriteDelegate();

    protected abstract DOMStoreReadTransaction getReadDelegate();

    @Override
    public void executeModification(AbstractModification modification, Boolean havePermit) {
        this.incrementModificationCount();
        if (this.operationError == null) {
            try {
                modification.apply(this.getWriteDelegate());
            }
            catch (Exception e) {
                this.operationError = e;
            }
        }
    }

    @Override
    public <T> void executeRead(AbstractRead<T> readCmd, final SettableFuture<T> proxyFuture, Boolean havePermit) {
        Futures.addCallback(readCmd.apply(this.getReadDelegate()), (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                proxyFuture.set(result);
            }

            public void onFailure(Throwable failure) {
                proxyFuture.setException(failure instanceof Exception ? ReadFailedException.MAPPER.apply((Exception)failure) : failure);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private LocalThreePhaseCommitCohort ready() {
        this.logModificationCount();
        return this.readySupport.onTransactionReady(this.getWriteDelegate(), this.operationError);
    }

    @Override
    public Future<ActorSelection> readyTransaction(Boolean havePermit, Optional<SortedSet<String>> participatingShardNames) {
        LocalThreePhaseCommitCohort cohort = this.ready();
        return cohort.initiateCoordinatedCommit(participatingShardNames);
    }

    @Override
    public Future<Object> directCommit(Boolean havePermit) {
        LocalThreePhaseCommitCohort cohort = this.ready();
        return cohort.initiateDirectCommit();
    }

    @Override
    public void closeTransaction() {
        this.txDelegate.close();
    }
}

