/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.UntypedActorContext;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardTransaction;
import org.opendaylight.controller.cluster.datastore.TransactionType;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.shard.ShardStats;

class ShardTransactionActorFactory {
    private static final AtomicLong ACTOR_NAME_COUNTER = new AtomicLong();
    private final ShardDataTree dataTree;
    private final DatastoreContext datastoreContext;
    private final String txnDispatcherPath;
    private final ShardStats shardMBean;
    private final UntypedActorContext actorContext;
    private final ActorRef shardActor;
    private final String shardName;

    ShardTransactionActorFactory(ShardDataTree dataTree, DatastoreContext datastoreContext, String txnDispatcherPath, ActorRef shardActor, UntypedActorContext actorContext, ShardStats shardMBean, String shardName) {
        this.dataTree = (ShardDataTree)Preconditions.checkNotNull((Object)dataTree);
        this.datastoreContext = (DatastoreContext)Preconditions.checkNotNull((Object)datastoreContext);
        this.txnDispatcherPath = (String)Preconditions.checkNotNull((Object)txnDispatcherPath);
        this.shardMBean = (ShardStats)Preconditions.checkNotNull((Object)shardMBean);
        this.actorContext = (UntypedActorContext)Preconditions.checkNotNull((Object)actorContext);
        this.shardActor = (ActorRef)Preconditions.checkNotNull((Object)shardActor);
        this.shardName = (String)Preconditions.checkNotNull((Object)shardName);
    }

    private String actorNameFor(TransactionIdentifier txId) {
        LocalHistoryIdentifier historyId = txId.getHistoryId();
        ClientIdentifier clientId = historyId.getClientId();
        FrontendIdentifier frontendId = clientId.getFrontendId();
        StringBuilder sb = new StringBuilder("shard-");
        sb.append(this.shardName).append('-').append(frontendId.getMemberName().getName()).append(':').append(frontendId.getClientType().getName()).append('@').append(clientId.getGeneration()).append(':');
        if (historyId.getHistoryId() != 0L) {
            sb.append(historyId.getHistoryId()).append('-');
        }
        return sb.append(txId.getTransactionId()).append('_').append(ACTOR_NAME_COUNTER.incrementAndGet()).toString();
    }

    ActorRef newShardTransaction(TransactionType type, TransactionIdentifier transactionID) {
        AbstractShardDataTreeTransaction transaction;
        switch (type) {
            case READ_ONLY: {
                transaction = this.dataTree.newReadOnlyTransaction(transactionID);
                this.shardMBean.incrementReadOnlyTransactionCount();
                break;
            }
            case READ_WRITE: {
                transaction = this.dataTree.newReadWriteTransaction(transactionID);
                this.shardMBean.incrementReadWriteTransactionCount();
                break;
            }
            case WRITE_ONLY: {
                transaction = this.dataTree.newReadWriteTransaction(transactionID);
                this.shardMBean.incrementWriteOnlyTransactionCount();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported transaction type " + (Object)((Object)type));
            }
        }
        return this.actorContext.actorOf(ShardTransaction.props(type, transaction, this.shardActor, this.datastoreContext, this.shardMBean).withDispatcher(this.txnDispatcherPath), this.actorNameFor(transactionID));
    }
}

