/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.identifiers;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opendaylight.controller.cluster.access.concepts.MemberName;

public class ShardIdentifier {
    private static final Pattern PATTERN = Pattern.compile("(\\S+)-shard-(\\S+)-(\\S+)");
    private final String shardName;
    private final MemberName memberName;
    private final String type;
    private final String fullName;

    ShardIdentifier(String shardName, MemberName memberName, String type) {
        this.shardName = (String)Preconditions.checkNotNull((Object)shardName, (Object)"shardName should not be null");
        this.memberName = (MemberName)Preconditions.checkNotNull((Object)memberName, (Object)"memberName should not be null");
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type should not be null");
        this.fullName = memberName.getName() + "-shard-" + shardName + "-" + type;
    }

    public static ShardIdentifier create(String shardName, MemberName memberName, String type) {
        return new ShardIdentifier(shardName, memberName, type);
    }

    public static ShardIdentifier fromShardIdString(String shardIdString) {
        Matcher matcher = PATTERN.matcher(shardIdString);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid shard id \"%s\"", (Object)shardIdString);
        return new ShardIdentifier(matcher.group(2), MemberName.forName((String)matcher.group(1)), matcher.group(3));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShardIdentifier that = (ShardIdentifier)obj;
        if (!this.memberName.equals((Object)that.memberName)) {
            return false;
        }
        if (!this.shardName.equals(that.shardName)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.shardName.hashCode();
        result = 31 * result + this.memberName.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return this.fullName;
    }

    public String getShardName() {
        return this.shardName;
    }

    public MemberName getMemberName() {
        return this.memberName;
    }

    public String getType() {
        return this.type;
    }

    public static class Builder {
        private String shardName;
        private MemberName memberName;
        private String type;

        public ShardIdentifier build() {
            return new ShardIdentifier(this.shardName, this.memberName, this.type);
        }

        public Builder shardName(String newShardName) {
            this.shardName = newShardName;
            return this;
        }

        public Builder memberName(MemberName newMemberName) {
            this.memberName = newMemberName;
            return this;
        }

        public Builder type(String newType) {
            this.type = newType;
            return this;
        }

        public Builder fromShardIdString(String shardId) {
            Matcher matcher = PATTERN.matcher(shardId);
            if (matcher.matches()) {
                this.memberName = MemberName.forName((String)matcher.group(1));
                this.shardName = matcher.group(2);
                this.type = matcher.group(3);
            }
            return this;
        }
    }
}

