/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.modification.MutableCompositeModification;

public class BatchedModifications
extends MutableCompositeModification {
    private static final long serialVersionUID = 1L;
    private boolean ready;
    private boolean doCommitOnReady;
    private int totalMessagesSent;
    private TransactionIdentifier transactionId;
    @Nullable
    private SortedSet<String> participatingShardNames;

    public BatchedModifications() {
    }

    public BatchedModifications(TransactionIdentifier transactionId, short version) {
        super(version);
        this.transactionId = Objects.requireNonNull(transactionId, "transactionID can't be null");
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(Optional<SortedSet<String>> possibleParticipatingShardNames) {
        this.ready = true;
        this.participatingShardNames = Objects.requireNonNull(possibleParticipatingShardNames).orElse(null);
        Preconditions.checkArgument((this.participatingShardNames == null || this.participatingShardNames.size() > 1 ? 1 : 0) != 0);
    }

    public void setReady() {
        this.setReady(Optional.empty());
    }

    public Optional<SortedSet<String>> getParticipatingShardNames() {
        return Optional.ofNullable(this.participatingShardNames);
    }

    public boolean isDoCommitOnReady() {
        return this.doCommitOnReady;
    }

    public void setDoCommitOnReady(boolean doCommitOnReady) {
        this.doCommitOnReady = doCommitOnReady;
    }

    public int getTotalMessagesSent() {
        return this.totalMessagesSent;
    }

    public void setTotalMessagesSent(int totalMessagesSent) {
        this.totalMessagesSent = totalMessagesSent;
    }

    public TransactionIdentifier getTransactionId() {
        return this.transactionId;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int count;
        super.readExternal(in);
        this.transactionId = TransactionIdentifier.readFrom((DataInput)in);
        this.ready = in.readBoolean();
        this.totalMessagesSent = in.readInt();
        this.doCommitOnReady = in.readBoolean();
        if (this.getVersion() >= 9 && (count = in.readInt()) != 0) {
            TreeSet<String> shardNames = new TreeSet<String>();
            for (int i = 0; i < count; ++i) {
                shardNames.add((String)in.readObject());
            }
            this.participatingShardNames = shardNames;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.transactionId.writeTo((DataOutput)out);
        out.writeBoolean(this.ready);
        out.writeInt(this.totalMessagesSent);
        out.writeBoolean(this.doCommitOnReady);
        if (this.getVersion() >= 9) {
            if (this.participatingShardNames != null) {
                out.writeInt(this.participatingShardNames.size());
                for (String shardName : this.participatingShardNames) {
                    out.writeObject(shardName);
                }
            } else {
                out.writeInt(0);
            }
        }
    }

    @Override
    public String toString() {
        return "BatchedModifications [transactionId=" + this.transactionId + ", ready=" + this.isReady() + ", participatingShardNames=" + this.participatingShardNames + ", totalMessagesSent=" + this.totalMessagesSent + ", modifications size=" + this.getModifications().size() + "]";
    }
}

