/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.VersionedExternalizableMessage;
import org.opendaylight.yangtools.concepts.Identifiable;

public class CloseTransactionChain
extends VersionedExternalizableMessage
implements Identifiable<LocalHistoryIdentifier> {
    private static final long serialVersionUID = 1L;
    private LocalHistoryIdentifier transactionChainId;

    public CloseTransactionChain() {
    }

    public CloseTransactionChain(LocalHistoryIdentifier transactionChainId, short version) {
        super(version);
        this.transactionChainId = (LocalHistoryIdentifier)Preconditions.checkNotNull((Object)transactionChainId);
    }

    public LocalHistoryIdentifier getIdentifier() {
        return this.transactionChainId;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.transactionChainId = LocalHistoryIdentifier.readFrom((DataInput)in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.transactionChainId.writeTo((DataOutput)out);
    }

    public static CloseTransactionChain fromSerializable(Object serializable) {
        Preconditions.checkArgument((boolean)(serializable instanceof CloseTransactionChain));
        return (CloseTransactionChain)serializable;
    }

    public static boolean isSerializedType(Object message) {
        return message instanceof CloseTransactionChain;
    }
}

