/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.datastore.messages.SerializableMessage;

public abstract class VersionedExternalizableMessage
implements Externalizable,
SerializableMessage {
    private static final long serialVersionUID = 1L;
    private short version = (short)9;

    public VersionedExternalizableMessage() {
    }

    public VersionedExternalizableMessage(short version) {
        this.version = (short)(version <= 9 ? version : 9);
    }

    public short getVersion() {
        return this.version;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.version = in.readShort();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.version);
    }

    @Override
    public final Object toSerializable() {
        if (this.getVersion() < 5) {
            throw new UnsupportedOperationException("Versions prior to 5 are not supported");
        }
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [version=" + this.getVersion() + "]";
    }
}

